@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Dispatching Orders</div>
                    <div style="float:right; margin:10px">
                    @if(auth()->user()->role == "Dispatch Manager")
                    <a class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModalSmallreport" href="#">Report</a>
                    @else
                    <a class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModalSmallreport" href="#">Report</a>
                    @endif
                    </div>
                </div>
                <div class="card-body">
                    <!-- Row start -->
                    <div class="table-responsive">
                    <table id="highlightRowColumn" class="table custom-table">
                    <thead>
                        <tr>
                            <th>Invoice Number</th>
                            <th>Customer Contact</th>
                            <th>Outlet</th>
                            <th>Total Cost</th>
                            <th>Delivery Fee</th>
                            <th>Rider Name</th>
                            <th>Rider Contact</th>
                            <th>Dispatch </br>Time</th>
                            @if(auth()->user()->role == "Dispatch Manager")
                            <th>Action</th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($process as $order)
                        <tr>
                            <td><a href="{{route('orderTransaction',$order->order_number)}}">#{{$order->order_number}}</a>
                                <br>Ordered Time: <strong>{{$order->ordered_at}}</strong>
                            </td>
                            <td>{{$order->customer_phone}}</td>
                            <td>{{$order->dispatch_branch}}</td>
                            <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($order->amount)</td>
                            <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($order->deliveryamount)</td>
                            <td>{{$order->rd_name}}</td>
                            <td>{!! strstr($order->rd_name, "PICK") == true ? '<span class="badge bg-info">'. "No Contact" .'</span>' : $order->rd_phone !!}</td>
                            <td>{!! empty($order->dispatched_at) ? '<span class="badge bg-info">'. "Processing" .'</span>' : '<span class="badge bg-success">' . $order->dispatched_at . '<span>'!!}</td>
                            @if(auth()->user()->role == "Dispatch Manager")
                            <td>
                                <a href="#" onclick="markComplete(this.id)" id="<?php  echo $order->order_number?>" class="btn btn-info btn-sm mb-2">
                                <i class="fa fa-check" aria-hidden="true"></i>Complete
                                </a>

                                <a href="#" class="btn btn-dark btn-sm mb-2" onclick="confirmReject()">
                                <i class="fa fa-ban" aria-hidden="true"></i>Reject
                                </a>
                            </td>
                            @endif
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


<!-- Modal start -->
<div class="modal fade" id="exampleModalSmallreport" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">{{auth()->user()->role == "Call Center" ? "My Transactions": "Report On Dispatch"}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            @if(auth()->user()->role == "Call Center")
            <form action="{{route('dateReportByUser')}}" method="GET">
                        @csrf
                <div class="d-flex justify-content-end">
                    <!-- Field wrapper start -->
                    
                    <div class="field-wrapper m-0">
                        <div class="input-group">
                            <input type="text" name="user_id" id="user_id" hidden value="{{auth()->user()->id}}">
                            <input type="text" name="date" class="form-control custom-daterange2">
                            <span class="input-group-text">
                                <i class="icon-calendar1"></i>
                            </span>
                        </div>
                        <div class="field-placeholder">Select Date</div>
                    </div>
                    <!-- Field wrapper end -->
                    <button type="submit" class="btn btn-primary"><i class="icon-eye1" aria-hidden="true"></i></button>
                </div>
            </form>
            @else
           <form action="{{route('DispatchReport')}}" method="GET">
                <!-- Field wrapper start -->
                <div class="field-wrapper">
                    <div class="input-group">
                        <input type="text" name="date" class="form-control custom-daterange">
                        <span class="input-group-text">
                            <i class="icon-calendar1"></i>
                        </span>
                    </div>
                    <div class="field-placeholder">Select Date</div>
                </div>
                <!-- Field wrapper end -->

                <div class="field-wrapper">
                <button class="btn btn-outline-primary btn-sm">
                    Report</button>
                </div>
           </form>
           @endif
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
										<!-- Modal end -->


<script>

   function confirmReject() {
    const swalWithBootstrapButtons = Swal.mixin({
                    customClass: {
                        confirmButton: 'btn btn-success',
                        cancelButton: 'btn btn-danger'
                    },
                    buttonsStyling: false
                    })

                    swalWithBootstrapButtons.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!, contact Administrator for Assistance",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Mark Rejected!',
                    cancelButtonText: 'No, cancel!',
                    reverseButtons: true
                    }).then((result) => {
                    if (result.isConfirmed) {
                        swalWithBootstrapButtons.fire(
                        'Rejected!',
                        'the Order has been Rejected.',
                        'success'
                        )
                    } else if (
                        /* Read more about handling dismissals below */
                        result.dismiss === Swal.DismissReason.cancel
                    ) {
                        swalWithBootstrapButtons.fire(
                        'Cancelled',
                        'Process the Order if neccessary:)',
                        'error'
                        )
                    }
                    })
   }



      function markComplete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "Do you really want to mark order as Completed!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Complete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    window.location.href= "/ceqa-dashboard/view-orders/processing-by-rider";
                }
                xhttp.open("GET", "/ceqa-dashboard/dispatch/"+ id);
                xhttp.send();

                Swal.fire(
                'Confirm!',
                'The Order is Marked Completed.',
                'success'
                )
            }
        })
   }
</script>


@endsection