@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
            <div class="card-header-lg">
            <div class="card-title">
            <h5>Advance Product Setting</h5>
            <p><small class="text-info">Set Product BOM, Activate Product, Import Bill of Material</small></p>
            </div>
                @if(auth()->user()->role == "Administrator")
                <form action="{{route('loadBillofMaterial')}}" method="post" enctype="multipart/form-data">
                                @csrf
                        <!-- Row start -->
                        <div class="row gutters">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">														
                                        <input type="file" name="file" class="form-control" id="inputGroupFile01">
                                        <button class="btn btn-outline-primary" type="submit" required>Upload</button>
                                    </div>
                                    <div class="field-placeholder">Import Bill of Material</div>
                                    <small class="text-primary"><a href="/uploads/dispatch_items.csv">Download Sample CSV</a></small>
                                </div>
                                <!-- Field wrapper end -->

                            </div>
                        </div>
                        <!-- Row end -->
                    </form>
                @endif
            </div>
            
                <div class="card-body">
                <form action="{{route('SetBomData')}}" id="bomstock" method="post">
                    @csrf
                    <div class="table-responsive">
                    <table id="basicExample" class="table table-striped custom-table">
                            <thead>
                                <tr>
                                  <th>Products</th>		
                                  <th>Deactivate Product</th>
                                  <th>Bill of Material</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($items as $item)
                                <tr>
                                  <td>
                                  <div class="d-flex align-items-center">
                                        <div class="me-2">
                                            <img src="/uploads/{{empty($item->product_image) ? 'no-product.png' : $item->product_image}}" class="img-36" alt="Avatar">
                                        </div>
                                        <div >
                                            <b>{!!@strtoupper($item->Name)!!}</b>
                                            <div>
                                                <small class="text-muted">{{@strtoupper($item->product_code)}}</small>
                                            </div>
                                        </div>
                                    </div>
                                  </td>
                                  <td>NO</td>
                                  <td>
                                      <?php $bom = \DB::table('material_product_compositons')->where('product_id', $item->FinalProductionID)->get() ?>
                                      <!-- Field wrapper start -->
                                      <div id="loadproduct{{$item->FinalProductionID}}">
                                      @foreach($bom as $bom)
                                        <div class="field-wrapper" id="loadbom{{$bom->id}}">
                                            <div class="input-group">	
                                                <input type="number" id="composition{{$bom->id}}" class="form-control" value="{{$bom->composition_id}}" hidden>													
                                                <input type="number" id="unit_measure{{$bom->id}}" min="0" step="0.001" class="form-control" value="{{$bom->unit_measure}}">
                                                <button id="{{$bom->id}}" onclick="DeleteItem(this.id)" class="btn btn-outline-dark" type="button"><i class="icon-cancel"></i> Delete</button>
                                                <button id="{{$bom->id}}" onclick="SaveItem(this.id)" class="btn btn-outline-primary" type="button"> <i class="icon-save"></i> Save</button>
                                            </div>
                                            <div class="field-placeholder">{{$bom->product_name}}</div>
                                            <div class="form-check form-check-inline mt-3">
                                                <input class="form-check-input" name="product[]" type="checkbox" id="{{$bom->product_name}}" value="{{$bom->id}}">
                                                <label class="form-check-label" for="{{$bom->product_name}}">Remove Item</label>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                        <!-- Field wrapper end -->
                                        <button type="button" class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#bomModel{{$item->FinalProductionID}}"><i class="icon-add-to-list"></i> Add BOM</button>
                                  </td>	
                                </tr>
                                @endforeach
                               
                            </tbody>
                    </table>
                    </div>
                    <input type="text" name="remove_bom" value="Remove Selected" id="remove_bom" hidden>

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-3">
                            <button type="submit" class="btn btn-info">Save Changes</button>
                            <button type="button" onclick="confirmDelete()" class="btn btn-primary"> <i class="icon-trash"></i> Remove Selected</button>
                        </div>
                    </form>
                </div>
                
                </div>
                
        </div>
        
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


@foreach($items as $item)
<!-- Modal start -->
<div class="modal fade" id="bomModel{{$item->FinalProductionID}}" tabindex="-1" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLongTitle">{{$item->Name}}</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
        <form id="productmaterial">
                @csrf
            <input type="text" value="{{$item->FinalProductionID}}" id="product_id" name="product_id" readonly hidden>
            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <div class="input-group">
                        <select name="product" class="select-single js-states" title="Select Product Category" data-live-search="true">
                            <option selected disabled id="item">Select Item</option>
                            @foreach($Allitems as $material)
                            <option value="{{$material->id}} - {!!$material->item_name!!}">{!!$material->item_name!!}</option>
                            @endforeach
                        </select>
                        </div>
                        <div class="field-placeholder">Select Material <span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>

                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <div class="input-group">
                            <input class="form-control" type="number" step="0.001" id="unit_measure" name="unit_measure">
                        </div>
                        <div class="field-placeholder">Unit Quantity <span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->


                </div>

                <input class="form-control" type="text" name="Product_code" value="{{$item->product_code}}" hidden>


                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <button class="btn btn-outline-info">Submit</button>
                </div>
            </div>
            <!-- Row end -->
        </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
    </div>
    <!-- Modal end -->
@endforeach


<script type="text/javascript">            

    $("#productmaterial").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('MaterialProductCompositon')}}",
                dataType: "json",
                data: $('#productmaterial').serialize(),
                success: function(data){
                    $("#loadproduct"+data).load(" #loadproduct"+data);
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'bottom-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Bill of Material Added Successfully'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });


    function DeleteItem(id) {
        Swal.fire({
                title: 'Remove Item, Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Delete BOM!'
                }).then((result) => {
                if (result.isConfirmed) {
                    const xhttp = new XMLHttpRequest();
                    xhttp.onload = function() {
                        $("#loadbom"+id).load(" #loadbom"+id);
                    }
                    xhttp.open("GET", "/ceqa-dashboard/remove-bom-from-list/"+id);
                    xhttp.send();
                }
                })
    }


    function SaveItem(id) {
        $unit = document.getElementById('unit_measure'+id).value;
        composition = document.getElementById('composition'+id).value;
        Swal.fire({
                title: 'Save new unit, Are you sure?',
                text: "This will override existing material quantity",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Save & Update!'
                }).then((result) => {
                if (result.isConfirmed) {
                    const xhttp = new XMLHttpRequest();
                    xhttp.onload = function() {
                        const Toast = Swal.mixin({
                    toast: true,
                    position: 'bottom-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'BOM Unit updated Successfully'
                    })
                    }
                    xhttp.open("GET", "/ceqa-dashboard/save-unit/"+id+"/"+$unit+"/"+composition);
                    xhttp.send();
                }
                })
    }



    function confirmDelete(){
        document.getElementById('remove_bom').value = "remove_bom";
        Swal.fire({
                title: 'Remove Selected Item, Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Remove!'
                }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("bomstock").submit();
                }
                })
    }
</script> 








@endsection