@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

   <!-- Row start -->
   <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title"><strong>BOM:</strong>  {{$name}}</div>
                </div>
                <div class="card-body">
                    <form id="productmaterial">
                        @csrf
                        <input type="text" value="{{$id}}" id="product_id" name="product_id" readonly hidden>
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">
                                <select name="product" class="select-single js-states" title="Select Product Category" data-live-search="true">
                                 <option selected disabled id="item">Select Item</option>
                                 @foreach($Allitems as $material)
                                    <option value="{{$material->id}} - {!!$material->item_name!!}">{!!$material->item_name!!}</option>
                                 @endforeach
                                </select>
                                </div>
                                <div class="field-placeholder">Select Material <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">
                                    <input class="form-control" type="number" step="0.001" id="unit_measure" name="unit_measure">
                                </div>
                                <div class="field-placeholder">Unit Quantity <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->


                        </div>

                        <input class="form-control" type="text" name="Product_code" value="{{$product_code}}" hidden>


                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <button class="btn btn-outline-info rounded-pill">Submit</button>
                            <button class="btn btn-outline-primary rounded-pill" type="button" id="{{$id}}" onclick="deleteItem(this.id)" class="btn btn-primary"><i class="icon-trash"></i> Remove Product</button>
                        </div>
                    </div>
                    <!-- Row end -->
                    </form>
                </div>
            </div>
            <!-- Card end -->

            <div class="card">
                <div class="card-body">
                    <form id="ActivateBranch">
                        @csrf
                        <input type="text" name="product_id" value="{{$id}}" hidden>
                        
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">					
                            <!-- Field wrapper start -->
                            
                            <div class="field-wrapper">
                                <select name="branches[]" class="select-multiple js-states" title="Select Product Category" multiple="multiple">
                                @foreach(json_decode($products->activated_branches) as $branch)
                                    <option selected>{{$branch}}</option>
                                @endforeach
                                    @foreach($all_branch_ as $branch)
                                        <option>{{$branch->branch_name}}</option>
                                    @endforeach
                                </select>
                                <div class="field-placeholder">Outlet</div>
                                <small class="text-info">Make Product & service inactive at selected outlets</small>
                            </div>

                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <button class="btn btn-outline-primary btn-sm">Make Inactive</button>
                            </div>
                            
                            <!-- Field wrapper end -->
                            </div>
                           
                        </div>

                        
                    </form>
            </div>
        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">BILL OF MATERIAL</div>
                </div>
                <div class="card-body" id="compo">
                    
                <div class="table-responsive">
                <table id="basicExample" class="table custom-table table-sm">
                            <thead>
                                <tr>
                                    <th>Item Name</th>
                                    <th>Unit</th>
                                    <th>Cost</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            @foreach($p_comp as $comp)
                            <tr>
                                <td>{{$comp->product_name}}</td>
                                <td>{{(float)$comp->unit_measure}}</td>
                                <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($comp->cost)</td>
                                <td>
                                    <a class="btn btn-outline-primary rounded-pill rounded btn-sm" href="{{route('removeProductComposition', $comp->id)}}"><i class="icon-trash"></i></a>
                                </td>
                            </tr>
                            @endforeach
                    </table>

                </div>

                <div style="margin:10px">
                    <span>Estimated Cost: <strong>{{empty($app->currency) ? "GHS" : $app->currency}} @convert($estimated_cost)</strong></span>
                    <span style="float:right">Profit(%): <strong>@convert((($products->UnitPrice-$estimated_cost)/$products->UnitPrice)*100)%</strong></span>
                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>



   <!-- Row start -->
   <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">MAKE CHANGES: {{@strtoupper($name)}}</div>
                </div>
                <div class="card-body">
                    <form action="{{route('EditProduct', $products->FinalProductionID)}}" method="POST" enctype="multipart/form-data">
                        @csrf
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">
                                <input type="text" name="p_name" value="{{$products->Name}}">
                                </div>
                                <div class="field-placeholder">Product Name<span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <input class="form-control" type="text" value="{{$products->product_code}}" name="product_code" hidden>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">
                                    <input class="form-control" type="number" step="0.001" value="{{$products->UnitPrice}}" name="p_unit_price">
                                </div>
                                <div class="field-placeholder">Unit Price <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>


                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <select  name="p_category" class="select-single js-states" title="Select Product Category" data-live-search="true">
                                <option selected>{{$products->production_category}}</option>
                                @foreach($item_category as $category)
                                <option>{{$category->category_name}}</option>
                                @endforeach
                                </select>
                                <div class="field-placeholder">Category</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <select name="p_brand" class="select-single js-states" title="Select Product Category" data-live-search="true">
                                <option selected>{{$products->brand}}</option>
                                @foreach($brands as $brand)
                                <option>{{$brand->brand_name}}</option>
                                @endforeach
                                </select>
                                <div class="field-placeholder">Brand</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">
                                    <input class="form-control" readonly required type="text" value="{{$products->product_code}}" name="product_code">
                                </div>
                                <div class="field-placeholder">Product Code<span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">
                                    <input class="form-control" onKeydown="return event.key != 'Enter';" type="text" value="{{$products->barcode}}" name="barcode">
                                </div>
                                <div class="field-placeholder">Barcode</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper m-0">
                                <textarea class="form-control" name="p_description" rows="3">{{$products->description}}</textarea>
                                <div class="field-placeholder">Description</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>


                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="file" class="form-control" name="image">
                                <div class="field-placeholder">Product Image</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>


                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="checkbox" id="checkSms2" <?= $products->store_category == 1 ? 'checked' : '' ?> value="1" name="store_category">
                                    <label class="form-check-label" for="checkSms2">Bar Menu Item</label>
                                </div>

                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="checkbox" id="checkSms3" value="1" <?= $products->website_display == 1 ? 'checked' : '' ?> name="store_active">
                                    <label class="form-check-label" for="checkSms3">Active Online</label>
                                </div>
                            </div>
                        </div>


                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <button class="btn btn-info">Save Changes</button>
                        </div>
                    </div>
                    <!-- Row end -->
                    </form>
                </div>
            </div>
            <!-- Card end -->

        </div>



        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

<!-- Card start -->
<div class="card">
<div class="carousel-inner">
    <img src="/uploads/{{empty($products->product_image) ? "no-product.png" : $products->product_image}}" class="d-block w-100" alt="Product-image">
    <div class="carousel-caption d-none d-md-block">
        <h5 class="text-dark"><strong>{{$products->Name}}</strong></h5>
        <p class="text-dark">{{$products->description}}</p>
    </div>
</div>
</div>
<!-- Card end -->

</div>


</div>
</div>


<script>
     $("#productmaterial").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('MaterialProductCompositon')}}",
                dataType: "json",
                data: $('#productmaterial').serialize(),
                success: function(data){
                    document.getElementById('unit_measure').value = "";
                    document.getElementById('item').value = "";
                    $("#compo").load(" #compo");
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });


        function deleteItem(data) {
            Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Remove it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/ceqa-dashboard/remove-product-from-list/"+ data;
            }
            })
        }



        function inActiveOutlet(id) {
            var product_id = document.getElementById('product_id').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                $("#tabler").load(" #tabler");
            }
            xhttp.open("GET", "/ceqa-dashboard/change-activated-state/"+id + "/" + product_id);
            xhttp.send();
        }




        $("#ActivateBranch").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('activateProduct')}}",
                dataType: "json",
                data: $('#ActivateBranch').serialize(),
                success: function(data){
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'bottom-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Product activation was successfull'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong! Mismatch Coupon Code or Gift Card',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });
</script>

@endsection