@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
            <div class="card-header-lg">
            <h5> Materials</h5>
                @if(auth()->user()->role == "Administrator")
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addNewDocument"><i class="fas fa-plus"></i> Add Item</button>
                @endif
                <div class="modal fade" id="addNewDocument" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="addNewDocumentLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="addNewDocumentLabel">Add New Product</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true"></span>
                                </button>
                            </div>
                            <div class="modal-body">

            <form action="{{route('store.rawmaterial')}}" method="post">
                @csrf
                <div id="basic-example">
                    <section>
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="basicpill-firstname-input">Raw Material Name</label>
                                        <input type="text" class="form-control" id="basicpill-firstname-input" placeholder="Enter Name" name="raw_material_name">
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="basicpill-lastname-input">Measurement Unit</label>
                                            <select class="form-select" name="raw_material_measurement">
                                                    <option selected>select option</option>
                                                    <option>Kg</option>
                                                    <option>Pcs</option>
                                            </select>
                                    </div>
                                </div>


                                <div class="row">
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="basicpill-firstname-input">Raw Material Code</label>
                                        <input type="text" class="form-control" value="<?php echo "RAW-".substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 6) . date("hi"); ?>" placeholder="Enter Code" name="raw_material_code">
                                    </div>
                                </div>
                            </div>
                        </section>
                        <button class="btn btn-primary" type="submit">Save</button>
                </div>
            <!-- end card body -->
            </form>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>  

        <div class="card-body">
                   
            <div class="table-responsive">
                <table id="copy-print-csv" class="table v-middle">
                    <thead>
                            <tr>
                                <th>Material Code</th>
                                <th>Material Name</th>
                                <th>Measurement</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($all_rawmaterial as $material)
                            <tr>
                            <td>{{$material->raw_material_code}}</td>
                                <td>{{$material->raw_material_name}}</td>
                                <td>{{$material->raw_material_measurement}}</td>
                                <td>{!! $material->status == 1 ? '<span class="badge bg-success">'.'Sold Raw' . '</span>' : '<span class="badge bg-danger">'.'Processed' . '</span>'!!}</td>
                                <td>
                                <a href="{{route('DeleteMaterial', $material -> id)}}" class="btn btn-danger btn-sm btn-rounded waves-effect waves-light">
                                <i class="fas fa-trash-alt"></i>
                                </a>
                                </td>
                            </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection