@extends('layouts.app')

@section('content')
<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">
<div style="padding:15px">
    <h4>REPORT FROM {{Request()->date}}</h4>
</div>
<div class="container">
  <div class="row">
    <div class="col-sm">
      <!-- Field wrapper start -->
      <div class="field-wrapper">
            <input class="form-control" readonly type="text" placeholder="Full Name" value="{{$user_data -> name}}">
            <div class="field-placeholder">Name <span class="text-danger">*</span></div>
        </div>
        <!-- Field wrapper end -->
    </div>
    <div class="col-sm">
           <!-- Field wrapper start -->
           <div class="field-wrapper">
            <input class="form-control" readonly type="text" value="<?= $user_data -> sales_person_category . " Service" ?>">
            <div class="field-placeholder">Sales Category <span class="text-danger">*</span></div>
        </div>
        <!-- Field wrapper end -->
    </div>
    <div class="col-sm">
           <!-- Field wrapper start -->
           <div class="field-wrapper">
            <input class="form-control" type="text" value="{{$user_data -> branch}}" readonly>
            <div class="field-placeholder">Current Branch<span class="text-danger">*</span></div>
        </div>
        <!-- Field wrapper end -->
    </div>
  </div>
</div>

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    @if($user_data -> sales_person_category == "Delivery")
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($general_total_general - $deliveryAmount)</h2>
                        <p><strong>Net Sales</strong></p>
                    </div>
                    @else
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($general_total_general)</h2>
                        <p><strong>Net Sales</strong></p>
                    </div>
                    @endif
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($general_total_house)</h2>
                        <p><a href="">On the House</a></p>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-check-circle"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($general_total_reject)</h2>
                        <p><a href="#">Rejected Items</a></p>
                    </div>
                </div>
            </div>
        </div>


    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
            <div class="card-header">
                <form action="{{route('departmentSummarybyDate')}}" method="get">
                    <input type="text" name="date" value="{{request()->date}}" readonly hidden>
                    <input type="text" name="user_id" value="{{$user_data->id}}" readonly hidden>
                    <button class="btn btn-outline-primary rounded-pill" type="submit">Category Report</button>
                </form>
                <form action="{{route('ItemSummarybyDate')}}" method="get">
                    <input type="text" name="date" value="{{request()->date}}" readonly hidden>
                    <input type="text" name="user_id" value="{{$user_data->id}}" readonly hidden>
                    <button class="btn btn-outline-primary rounded-pill" type="submit">Product Report</button>
                </form>
            </div>
                <div class="card-body">
                    <div class="card-title">Transactions</div>
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                                <thead>
                                    <tr>
                                        <th>Order No.</th>
                                        <th>Ordered Date</th>
                                        <th>Product</th>
                                        <th>Quantity</th>												
                                        <th> Unit Price</th>
                                        <th>Department</th>
                                        <th>Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($sales_today_general as $list)
                                    <tr>
                                        <td>#{{$list->invoice_number}}</td>
                                        <td>{{$list->created_at}}</td>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                        <td>{{$list->invoice_category}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->


    <!-- on the house sales and rejected orders -->

        <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">No Charge Items</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">        
                        <table id="apiCallbacks" class="table custom-table">

                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        <th>Quantity</th>												
                                        <th> Unit Price</th>
                                        <th>Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($general_total_house_list as $list)
                                    <tr>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Rejected Items</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="table-responsive">
                        <table id="fixedHeader" class="table custom-table">
                                <thead>
                                    <tr>
                                        <th>Order No.</th>
                                        <th>Product</th>
                                        <th>Quantity</th>												
                                        <th> Unit Price</th>
                                        <th>Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($general_total_reject_list as $list)
                                    <tr>
                                        <td>#{{$list->invoice_number}}</td>
                                        <td>{{$list->invoice_product_name}}</td>
                                        <td>{{$list->invoice_quantity}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

        </div>
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Orders</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                        <table id="hideSearchExample" class="table custom-table">
                                <thead>
                                    <tr>
                                        <th>Order No.</th>
                                        <th>Outlet</th>
                                        <th>Total Cost</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($order as $list)
                                    <tr>
                                        <td>#{{$list->order_id}}</td>
                                        <td>{{$list->branch}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->total_cost_order}}</td>
                                        <td><a class="text-primary" style="text-decoration:underline" href="{{route('orderTransaction', $list->order_id)}}">view</a></td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                           
                        
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
</div>
</div>
<!-- Content wrapper end -->




@endsection