@extends('layouts.app')

@section('content')
<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

<div>
    <h4><strong></strong> SALES REPORT  FROM {{request()->date}},  | Category Type: {{request()->category}}</h4>
</div>

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    @if(request()->category == "Delivery")
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($branch_total_general - $deliveriesToday)</h2>
                        <p>Net Sales</p>
                    </div>
                    @else
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($branch_total_general)</h2>
                        <p>Net Sales</p>
                    </div>
                    @endif
                    
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($branch_total_house)</h2>
                        <p><a href="">No Charge</a></p>
                    </div>
                    <div class="sale-graph">
                        <div id="sparklineLine2"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-check-circle"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}{{$branch_total_reject}}</h2>
                        <p><a href="#">Rejected Items</a></p>
                    </div>
                </div>
            </div>
        </div>

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                                <thead>
                                    <tr>
                                        <th>Order No.</th>
                                        <th>Ordered Date</th>
                                        <th>Product</th>
                                        <th>Quantity</th>	
                                        <th>Category</th>											
                                        <th>Unit Price</th>
                                        <th>Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($sales_today_branch as $list)
                                    <tr>
                                        <td>#{{$list->invoice_number}}</td>
                                        <td>{{$list->created_at}}</td>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{@strtoupper($list->invoice_category)}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_unit_price)</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_total_price)</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->




    <!-- on the house sales and rejected orders -->

        <!-- Row start -->
        <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">No Charge</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">        
                        <table                         id="apiCallbacks" class="table custom-table">

                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        <th>Quantity</th>												
                                        <th>Unit Price</th>
                                        <th>Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($branch_total_house_list as $list)
                                    <tr>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_unit_price)</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_total_price)</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Rejected Order</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                        <table id="copy-print-csv" class="table v-middle">
                                <thead>
                                    <tr>
                                        <th>Order No.</th>
                                        <th>Product</th>
                                        <th>Quantity</th>												
                                        <th> Unit Price</th>
                                        <th>Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($branch_total_reject_list as $list)
                                    <tr>
                                        <td>{{$list->invoice_number}}</td>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                           
                        
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->


        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Invoice List</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                        <table id="scrollVertical" class="table custom-table">
                                <thead>
                                    <tr>
                                        <th>Invoice Number.</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($order as $list)
                                    <tr>
                                        <td>#{{$list->order_id}}</td>
                                        <td><a href="{{route('orderTransaction',$list->order_id)}}" class="text-primary" style="text-decoration:underline">view</a></td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                           
                        
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
</div>
</div>
<!-- Content wrapper end -->




@endsection