@extends('layouts.app')

@section('content')
<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

<div>
    <h5><strong>SALES REPORT  FOR </strong> - {{request()->branch}} | Category Type: {{request()->category}}, Date: {{request()->date}}</h5>
</div>

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($branch_total_general - $deliveriesToday)</h2>
                        <p><strong>Net Sales</strong></p>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($branch_total_house)</h2>
                        <p><a href="">On the House</a></p>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-check-circle"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($branch_total_reject)</h2>
                        <p><a href="#">Rejected Items</a></p>
                    </div>
                </div>
            </div>
        </div>



        
    <!-- Row start -->
    <div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
            <div class="card h-180">
                
                <div class="card-header">
                    <form action="{{route('departmentSummaryDate')}}" method="get">
                        @csrf
                        <input type="text"  name="date" value="{{request()->date}}" readonly hidden>
                        <input type="text"  name="category" value="{{request()->category}}" readonly hidden>
                        <input type="text"  name="branch" value="{{request()->branch}}" readonly hidden>
                        <button class="btn btn-outline-primary rounded-pill">Category Report</button>
                    </form>
                    <form action="{{route('itemSummaryDate')}}" method="get">
                        @csrf
                        <input type="text"  name="date" value="{{request()->date}}" readonly hidden>
                        <input type="text"  name="category" value="{{request()->category}}" readonly hidden>
                        <input type="text"  name="branch" value="{{request()->branch}}" readonly hidden>
                        <button class="btn btn-outline-primary rounded-pill">Product Report</button>
                    </form>
                    <hr>
                </div>
                
                <div class="card-body">
                    <div class="create-offer-container">
                    <div class="card-title">
                        SUMMARY
                    </div>
                    @include('inc.report-summary-salesperson')
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-2 col-lg-2 col-md-4 col-sm-4 col-6">
            <div class="social-tile h-180">
                <p>Discounts</p>
                <h3>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($discounts)</h3>
                <a href="#" class="btn btn-outline-primary rounded-pill" data-bs-toggle="modal" data-bs-target="#exampleModalFullScreen">view</a>
            </div>
        </div>

       @if(request()->category == "Delivery")
        <div class="col-xl-2 col-lg-2 col-md-4 col-sm-4 col-6">
            <div class="social-tile h-180">
                <p>Total Delivery Fees</p>
                <h3>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($deliveriesToday)</h3>
            </div>
        </div>
       @endif
        <div class="col-xl-2 col-lg-2 col-md-4 col-sm-4 col-12">
            <div class="social-tile h-180">
                <p><strong>Expected Amount</strong></p>
                <h3>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($orders)</h3>
            </div>
        </div>
    </div>
    <!-- Row end -->

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                                <thead>
                                    <tr>
                                        <th>Order No.</th>
                                        <th>Ordered Date</th>
                                        <th>Product</th>
                                        <th>Quantity</th>												
                                        <th> Unit Price</th>
                                        <th>Category</th>
                                        <th>Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($sales_today_branch as $list)
                                    <tr>
                                        <td>#{{$list->invoice_number}}</td>
                                        <td>{{$list->created_at}}</td>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                        <td>{{$list->invoice_category}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->




    <!-- on the house sales and rejected orders -->

        <!-- Row start -->
        <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">On the House</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">        
                        <table                         id="apiCallbacks" class="table custom-table">

                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        <th>Quantity</th>												
                                        <th> Unit Price</th>
                                        <th>Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($branch_total_house_list as $list)
                                    <tr>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Rejected Order</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                    <div class="table-responsive">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <table id="fixedHeader" class="table custom-table">
                                <thead>
                                    <tr>
                                        <th>Order No.</th>
                                        <th>Product</th>
                                        <th>Quantity</th>												
                                        <th> Unit Price</th>
                                        <th>Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($branch_total_reject_list as $list)
                                    <tr>
                                        <td>#{{$list->invoice_number}}</td>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                           
                        </div>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->


    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Invoice List</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                        <table id="scrollVertical" class="table custom-table">
                                <thead>
                                    <tr>
                                        <th>Invoice No.</th>
                                        <th>Order Cost</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($order as $list)
                                    <tr>
                                        <td>#{{$list->order_id}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->total_cost_order}}</td>
                                        <td><a href="{{route('orderTransaction',$list->order_id)}}">view Transaction</a></td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                           
                        
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
</div>
</div>
<!-- Content wrapper end -->

<!-- Modal for Discount Orders -->
@include('inc.discount-items')


@endsection