@extends('layouts.app')

@section('content')
<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

@if(auth()->user()->role == "Administrator")
    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    
                    <div class="table-responsive">
                        <table id="copy-print-csv" class="table v-middle">
                            <thead>
                                <tr>
                                  <th>Outlet</th>
                                  <th>Outlet Code</th>
                                  <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($branches as $branches)
                                <tr>												  
                                  <td>{{$branches->branch_name}}</td>
                                  <td>{{$branches->branch_code}}</td>
                                  <td>
                                  <form action="{{route('branchSales')}}" method="get">
                                          @csrf
                                          <input type="text" name="branch" hidden readonly value="{{$branches->branch_name}}">
                                            <button class="btn btn-outline-primary btn-sm"><i class="icon-bubble_chart" aria-hidden="true"></i> Report</button>
                                      </form>
                                  </td>
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

@else

     <!-- Row start -->
     <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    
                    <div class="table-responsive">
                        <table id="copy-print-csv" class="table v-middle">
                            <thead>
                                <tr>
                                  <th>Outlet</th>
                                  <th>Description</th>
                                  <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>												  
                                  <td>{{@strtoupper($branch_officer->branch_name)}}</td>
                                  <td>{{$branch_officer->branch_description}}</td>
                                  <td>
                                      <form action="{{route('branchSales')}}" method="get">
                                          @csrf
                                          <input type="text" name="branch" hidden readonly value="{{$branch_officer->branch_name}}">
                                          <button class="btn btn-outline-primary btn-sm"><i class="icon-eye1" aria-hidden="true"></i> Report</button>
                                        </form>
                                  </td>
                                </tr>
                            </tbody>
                    </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

@endif



@if(auth()->user()->role == "Administrator")
<!-- For Admins -->
    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                <div><h6>USER REPORT</h6></div>
                <hr>
                    <div class="table-responsive">
                    <table id="fixedHeader" class="table custom-table">
                            <thead>
                                <tr>
                                  <th>Name</th>
                                  <th>Category</th>
                                  <th>email</th>
                                  <th>outlet</th>
                                  <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($all_users as $users)
                                <tr>												  
                                  <td>{{@strtoupper($users->name)}}</td>
                                  <td>{{@strtoupper($users->sales_person_category)}}</td>
                                  <td>{{$users->email}}</td>
                                  <td>{{@strtoupper($users->branch)}}</td>
                                  <td>
                                    <div class="actions">
                                        <a href="{{route('userSales', $users->id)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                            <i class="icon-eye1 text-info"></i>
                                        </a>
                                        
                                    </div>
                                  </td>
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->



<!-- for Branch Managers -->

@else
        <!-- Row start -->
        <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                <div class="card-title">{{@strtoupper(auth()->user()->branch)}} USERS REPORT</div>
                    <div class="table-responsive">
                    <table id="fixedHeader" class="table custom-table">
                            <thead>
                                <tr>
                                  <th>Name</th>
                                  <th>Category</th>
                                  <th>Email</th>
                                  <th>Branch</th>
                                  <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($branch_user as $users)
                                <tr>												  
                                  <td>{{@strtoupper($users->name)}}</td>
                                  <td>{{$users->sales_person_category}}</td>
                                  <td>{{$users->email}}</td>
                                  <td>{{@strtoupper($users->branch)}}</td>
                                  <td>
                                  <div class="actions">
                                        <a href="{{route('userSales', $users->id)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                            <i class="icon-eye1 text-info"></i>
                                        </a>
                                        
                                    </div>
                                  </td>
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

@endif


</div>
<!-- Content wrapper end -->


@endsection