@extends('layouts.app')

@section('content')
<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

<div>
    <h4><strong>{{$branch}}</strong> DAILY SALES REPORT</h4>
</div>

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert((float)$branch_total_general - (float)$deliveries)</h2>
                        <p><strong>Net Sales</strong></p>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($branch_total_house)</h2>
                        <p><a href="">No Charge</a></p>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-check-circle"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($branch_total_reject)</h2>
                        <p><a href="#">Rejected Order / Returned Item</a></p>
                    </div>
                </div>
            </div>
        </div>
    <!-- ROW END -->

<!-- Row start -->
<div class="row">
    <div class="col-sm-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Summary</h5>
                <p class="mb-3 text-light">view summary report on product, by item or product category</p>
                <a href="{{route('departmentSummaryBranch', $branch)}}" class="btn btn-primary">Category</a>
                <a href="{{route('itemSummaryBranch', $branch)}}" class="btn btn-primary">Item</a>
            </div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="card">
            <div class="card-body">
                <div class="list-group m-0">
                    <a href="#" class="list-group-item list-group-item-action" aria-current="true">
                        Confirmed Amount <strong>{{empty($app->currency) ? "GHS" : $app->currency}} @convert($branch_total_general)</strong>
                    </a>

                    <a href="#" class="list-group-item list-group-item-action" aria-current="true">
                        Unconfirmed Amount: <strong>{{empty($app->currency) ? "GHS" : $app->currency}} @convert((float)$orders - (float)$branch_total_general)</strong>
                    </a>
                    <a href="#" class="list-group-item list-group-item-action" aria-current="true">
                        Expected Amount: <strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($orders)</strong>
                    </a>
                    <a href="#" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModalFullScreen">
                    Discounts of {{empty($app->currency) ? "GHS" : $app->currency}}@convert($discounts)
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="card text-end">
            <div class="card-body">
                <h5 class="card-title">Accumulated Delivery Amount</h5>
                <p>Delivery Income</p>
                @if(auth()->user()->sales_person_category == "Delivery")
                <p class="mb-3 text-light">Delivery Amount: {{empty($app->currency) ? "GHS" : $app->currency}}@convert($deliveries)</p>
                @endif

                <p>
                Delivery[Branch]: {{empty($app->currency) ? "GHS" : $app->currency}}@convert($deliveries)
                </p>
                <a href="#" class="btn btn-primary">Transactions</a>
            </div>
        </div>
    </div>
</div>
<!-- Row end -->




    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                                <thead>
                                    <tr>
                                        <th>Order No.</th>
                                        <th>Ordered Date</th>
                                        <th>Product</th>
                                        <th>Quantity</th>												
                                        <th> Unit Price</th>
                                        <th>Department</th>
                                        <th>Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($sales_today_branch as $list)
                                    <tr>
                                        <td>#{{$list->invoice_number}}</td>
                                        <td>{{$list->created_at}}</td>
                                        <td>
                                        {{@strtoupper($list->invoice_product_name)}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_unit_price)</td>
                                        <td>{{@strtoupper($list->invoice_category)}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_total_price)</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->




    <!-- on the house sales and rejected orders -->

        <!-- Row start -->
        <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">No Charge</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12"> 
                        <div class="table-responsive">       
                        <table id="apiCallbacks" class="table custom-table">

                                <thead>
                                    <tr>
                                        <th>Invoice No.</th>	
                                        <th>Product</th>
                                        <th>Quantity</th>												
                                        <th> Unit Price</th>
                                        <th>Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($branch_total_house_list as $list)
                                    <tr>
                                        <td>
                                        {{$list->invoice_number}}
                                        </td>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_unit_price)</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_total_price)</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
`                           </div>
                        </div>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Rejected Items</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="table-responsive">
                        <table class="table table-bordered table-striped m-0">
                                <thead>
                                    <tr>
                                        <th>Order No.</th>
                                        <th>Product</th>
                                        <th>Quantity</th>												
                                        <th> Unit Price</th>
                                        <th>Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($branch_total_reject_list as $list)
                                    <tr>
                                        <td>#55589</td>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                           
                        </div>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->


     <!-- Row start -->
     <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Invoice List</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">        
                        <table id="scrollVertical" class="table custom-table">

                                <thead>
                                    <tr>
                                        <th>Invoice No.</th>
                                        <th>Sales Category</th>		
                                        <th>Total Cost</th>											
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($ordersfromBranch as $list)
                                    <tr>
                                        <td>
                                        <a href="{{route('orderTransaction',$list->order_id)}}">#{{$list->order_id}}</a>
                                        </td>
                                        <td>
                                            {{$list->category}}
                                        </td>
                                        <td>
                                        GH¢{{$list->total_cost_order}}
                                        </td>
                                        <td><a href="{{route('orderTransaction',$list->order_id)}}" class="text-primary">
                                            <i class="icon-eye1" aria-hidden="true"></i>
                                        </a>
                                    </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Sales Type Report</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="table-responsive">
                        <table class="table table-bordered table-striped m-0">
                            <thead>
                                <tr>
                                  <th>Sales Type</th>
                                  <th>Description</th>
                                  <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                               
                                <tr>												  
                                  <td>Counter [Walk in Customer] Transactions</td>
                                  <td> Walk in customers transactions and sales report</td>
                                  <td>
                                  <form action="{{route('getDeliveryReportRoute')}}" method="get">
                                        @csrf
                                        <input type="text" name="branch" hidden value="{{request()->branch}}">
                                        <input type="text" name="category" hidden value="Counter">
                                        <input type="text" readonly hidden name="date" value="<?= date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close));?>">
                                        <button type="submit" class="btn btn-outline-primary btn-sm"> 
                                        <i class="icon-eye1"></i> View report
                                        </button>
                                    </form>
                                  </td>
                                </tr>
                                @if(request()->branch == "DAKODWOM BRANCH")
                                <tr>												  
                                  <td>Drive Thru</td>
                                  <td> Drive Thru Sales and Transaction Report</td>
                                  <td>
                                  <form action="{{route('getDeliveryReportRoute')}}" method="get">
                                        @csrf
                                        <input type="text" name="branch" hidden value="{{request()->branch}}">
                                        <input type="text" name="category" hidden value="Drive Thru">
                                        <input type="text" readonly hidden name="date" value="<?= date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close));?>">
                                        <button type="submit" class="btn btn-outline-primary btn-sm"> 
                                        <i class="icon-eye1"></i> view Report
                                        </button>
                                    </form>
                                  </td>
                                </tr>
                                @else
                                <tr>												  
                                  <td>Delivery</td>
                                  <td>Call Center & delivery sales report and Transactions</td>
                                  <td>
                                  <form action="{{route('getDeliveryReportRoute')}}" method="get">
                                        @csrf
                                        <input type="text" name="branch" hidden value="{{request()->branch}}">
                                        <input type="text" name="category" hidden value="Delivery">
                                        <input type="text" readonly hidden name="date" value="<?= date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close));?>">
                                        <button type="submit" class="btn btn-outline-primary btn-sm"> 
                                        <i class="icon-eye1"></i> view Report
                                        </button>
                                    </form>
                                  </td>
                                </tr>
                                @endif
                            </tbody>
                    </table>
                        </div>
                    </div>  
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
</div>

<!-- Modal for Discount Orders -->
@include('inc.discount-items')

</div>
<!-- Content wrapper end -->




@endsection