@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Task section start -->
            <div class="tasks-section">

                <!-- Labels container start -->
                <div class="labels-container">
                    <div class="lablesContainerScroll">
                        <div class="filters-block">
                            <h5>Filters</h5>
                            <div class="filters">
                                <a href="{{route('tableManagement')}}">
                                    <i class="icon-receipt"></i> unsettled
                                </a>
                                <a href="#" class="active">
                                    <i class="icon-error"></i> Paid
                                </a>
                            </div>
                        </div>											
                    </div>
                </div>
                <!-- Labels container end -->

                <!-- Tasks container start -->
                <div class="tasks-container">
                    <div class="tasks-header">
                        <h3>Tables Management - Settled <span>{{$getDayClose->day_close}}</span></h3>
                        @if(auth()->user()->role == "Sales Person")
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral"> <i class="icon-shopping-cart1"></i> New Sale</button>
                        @endif
                    </div>
                    <div class="tasksContainerScroll">
                         <!-- Card start -->
                                <div class="table-responsive">
                                    <table id="scrollVertical" class="table custom-table">
                                        <thead>
                                            <tr>
                                                <th>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="checkbox" id="select-all">
                                                </div>
                                                </th>
                                            <th>Trans. No.</th>
                                            @if(auth()->user()->role == "Administrator")
                                            <th>Outlet</th>
                                            @endif
                                            <th>Table Name</th>
                                            <th>Served by</th>
                                            <th>Added At</th>
                                            <th>Settled At</th>
                                            <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($tables_transactions as $transaction)
                                            <tr>
                                            <td>
                                            <div class="form-check form-check-inline">
                                                <input type="checkbox" class="form-check-input" name="tables[]" value="{{$transaction->id}}">
                                            </div>
                                            </td>
                                            <td><a href="{{route('orderTransaction',$transaction->invoice_number)}}"><strong>{{ $transaction->invoice_number}}</strong></td>
                                            @if(auth()->user()->role == "Administrator")
                                            <td>{{$transaction->branch}}</td>
                                            @endif
                                            <td>{{ $transaction->table_name }}</td>
                                            <td>{{ $transaction -> table_served_by }}</td>
                                            <td>{{ $transaction -> created_at }}</td>
                                            <td>{{ $transaction -> 	settled_at }}</td>
                                            <td><span class="badge bg-primary">Paid</span></td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                        </div>
                        <!-- Card end -->

                    </div>
                </div>
                <!-- Tasks container end -->

            </div>
            <!-- Task section end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->

<script>
    function confirmPayment(id) {
            Swal.fire({
                title: 'Confirm Payment, Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Confirm!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "/ceqa-dashboard/confirm-payment/"+id;
                }
                })
        }
</script>


<script type="text/javascript">  
    document.getElementById('select-all').onclick = function(){
        var ele=document.getElementsByName('tables[]');  
        for (var checkbox of ele) {
                checkbox.checked = this.checked;
            }
    
    }              
</script> 


@endsection