@extends('layouts.app')
@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Task section start -->
            <div class="tasks-section">

                <!-- Labels container start -->
                <div class="labels-container">
                    <div class="lablesContainerScroll">
                        <div class="filters-block">
                            <h5>Filters</h5>
                            <div class="filters">
                                <a href="#" class="active">
                                    <i class="icon-receipt"></i> unsettled
                                </a>
                                <a href="{{route('settledTable')}}">
                                    <i class="icon-error"></i> Paid
                                </a>
                                <a href="{{route('tableLinks')}}">
                                    <i class="icon-error"></i> Generate Links
                                </a>
                            </div>
                        </div>											
                    </div>
                </div>
                <!-- Labels container end -->

                <!-- Tasks container start -->
                <div class="tasks-container">
                    <div class="tasks-header">
                        <h3>Generate Table Links <span>{{$getDayClose->day_close}}</span></h3>
                        @if(auth()->user()->role == "Sales Person")
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral"> <i class="icon-shopping-cart1"></i> New Sale</button>
                        @endif
                    </div>
                    <div class="tasksContainerScroll">
                         <!-- Card start -->
                                <div class="table-responsive">
                                <table id="copy-print-csv" class="table custom-table">
                    <thead>
                        <tr>
                        <th>Table Name</th>
                        <th>Description</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($tables as $table)
                        <tr>
                        <td>{{@strtoupper($table->table_name)}}
                            <p><a href="http://ceqalimited/tables/{{$table->table_name}}">Copy Link</a></p>
                        </td>
                        <td>{{$table->table_description}}</td>
                        <td>
                            <div class="actions">
                                <a href="#" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit" data-bs-toggle="modal" data-bs-target="#category<?=$table->id?>">
                                    <i class="icon-edit1 text-info"></i>
                                </a>
                            </div>
                        </td>
                        </tr>
                        @endforeach
                    </tbody>
            </table>
                                </div>
                        </div>
                        <!-- Card end -->

                    </div>
                </div>
                <!-- Tasks container end -->

            </div>
            <!-- Task section end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->

<script>
    function confirmPayment(id) {
            Swal.fire({
                title: 'Confirm Payment, Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Confirm!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "/ceqa-dashboard/confirm-payment/"+id;
                }
                })
        }

        
        function AddItemInvoice(id) {
            Swal.fire({
                title: 'Add to Exiting Reciept, Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Confirm!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "/ceqa-dashboard/add-to-invoice/"+id;
                }
                })
        }
</script>
 


@endsection