@extends('layouts.auth-login')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters" style="height:50%">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            @include('inc.errorfile')
            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                <img src="/img/logo.png" alt="logo" style="max-width:120px;">
                </div>
                <form action="{{route('websiteReview')}}" method="post">
                    @csrf
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" type="text" name="customer_name" required>
                                <div class="field-placeholder">Name <span class="text-danger">*</span></div>
                                <div class="form-text">
                                    Please enter your full name.
                                </div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" type="number" name="phone">
                                <div class="field-placeholder">Contact <span class="text-danger"></span></div>
                                <div class="form-text">
                                    We'll never share your contact with anyone.
                                </div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                            <select class="select-single js-states" name="branch" title="Select Term" data-live-search="true" required>
                                        <option disable selected>Select Outlet</option>
									    @foreach($all_branch as $branch)
										<option value="{{$branch}}">{{$branch}}</option>
										@endforeach
                                    </select>
                                <div class="field-placeholder">Branch</div>
                                <div class="form-text">
                                    Which branch did you buy from?
                                </div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-8 col-lg-8 col-md-8 col-sm-8 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                            <select class="select-single js-states" name="product_bought" title="Select Term" data-live-search="true">
                                        <option disabled selected>Select option</option>
                                        <option>PIZZAMAN</option>
                                        <option>CHICKENMAN</option>
                                        <option>DRINK</option>
                                        <option>SPECIAL PACKAGE</option>
                                    </select>
                                <div class="field-placeholder">What did you buy from us?</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                            <select class="select-single js-states" name="rate_product" title="Select Term" data-live-search="true">
                            <option disabled selected>Select option</option>
                                @foreach($rate as $rate)
                                <option>{{$rate}}</option>
                                @endforeach
                            </select>
                                <div class="field-placeholder">scale of 1-10</div>
                                <div class="form-text">
                                    How would you rate our product
                                </div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                            <select class="select-single js-states" name="rate_service" title="Select Term" data-live-search="true">
                                    <option disabled selected>Select option</option>
                                    @foreach($rate1 as $rate)
                                    <option>{{$rate}}</option>
                                    @endforeach
                                </select>
                                <div class="field-placeholder">scale of 1-10</div>
                                <div class="form-text">
                                    How would you rate our services
                                </div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                            <select class="select-single js-states" name="recommendation" title="Select Term" data-live-search="true">
                                    <option disabled selected>Select option</option>
                                    @foreach($rate1 as $rate)
                                    <option>{{$rate}}</option>
                                    @endforeach
                                </select>
                                <div class="field-placeholder">scale of 1-10</div>
                                <div class="form-text">
                                    How likely are you to recommend us to a friend or colleeague?
                                </div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <textarea class="form-control" rows="2" name="comment"></textarea>
                                <div class="field-placeholder">Message <span class="text-danger">*</span></div>
                                <div class="form-text">
                                    Any Suggestion for Improvement/Remarks/Complaint
                                </div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <button class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                    <!-- Row end -->

                </div>
                </form>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->

@endsection




