@extends('layouts.fullscreen')

@section('content')

					<!-- Content wrapper start -->
<div class="content-wrapper">


    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('home')}}">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Dine In Reviews</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('reviewByDate')}}" method="get">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                    </div>
                </div>
                <!-- Field wrapper end -->
                <button class="btn btn-info"><i class="icon-search"></i> search</button>
            </div>
        </form>
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12">
            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Reviews -  [Customer Reviews]</div>
                </div>
                
                <div style="margin-left:20px; margin-top:12px">
                    Report for <em>{{request()->date == null ? $dayClose->day_close : request()->date }}</em>, Outlet: ALL OUTLET
                </div>
                
                <div class="card-body">
                <div class="table-responsive">
                        <table id="copy-print-csv" class="table custom-table">
                            <thead>
                                <tr>
                                    <th>Customer Name</th>
                                    <th>Phone</th>
                                    <th>Outlet</th>
                                    <th>Product</th>
                                    <th>Product Rating</th>
                                    <th>Service Rating</th>
                                    <th>Recommedation</th>
                                    <th>comment</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($reviews_today as $review)
                                <tr>
                                    <td>{{$review->customer_name}}</td>
                                    <td>{{$review->contact}}</td>
                                    <td>{{$review->branch}}</td>
                                    <td>{{$review->product_bought}}</td>
                                    <td>{{$review->rate_product}}</td>
                                    <td>{{$review->rate_service}}</td>
                                    <td>{{$review->recommendation}}</td>
                                    <td>{{$review->comment}}</td>
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                    </div>
                </div>
            </div>
            <!-- Card end -->
        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection