<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Carbon\carbon;
use App\Models\WebsiteReview;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Support\Facades\Validator;
use App\Models\Invoice;

Route::get('/', function () {

    return view('welcome');
    
});



Route::get('/orders-from-drive-through', function () {
       $collection = \DB::table('invoices')
        ->where('invoice_sales_person_category', "Drive Thru")
        ->where('drive_thru_status', 0)
        ->whereDate('created_at', carbon::today())
        ->orderBy('created_at', 'ASC')
        ->paginate(30);

        $grouped = $collection->groupBy('invoice_number');
        return view('inc.drive-thru-order', [
            'order' => $grouped
        ]);
});



Route::get('/online-orders-pending', function () {
    
    $getDayClose = \DB::table('close_days')->first();
    if (auth()->user()->role == "Administrator") {
         $pending_orders = \DB::table('online_customers')
        ->where('order_state', 2)
        ->where('orders','!=', null)
        ->whereDate('date', $getDayClose->day_close)
        ->get();
    }else {
        $pending_orders = \DB::table('online_customers')
        ->where('order_state', 2)
        ->whereDate('date', $getDayClose->day_close)
        ->where('orders','!=', null)
        ->where('order_branch', auth()->user()->branch)
        ->get();
    }


    return view('online-template.display-online-orders', [
        'pending_orders'=> $pending_orders
    ]);
})->name('OnlinePNP')->middleware('auth');


Route::get('/ceqa-dashboard/agency-orders-pending', function () {


    if (auth()->user()->role == "Cashier") {
        return redirect()->route('index.cashier');
    }
    
    $getDayClose = \DB::table('close_days')->first();
    if (auth()->user()->role == "Administrator") {
         $pending_orders_agency = \DB::table('online_customers')
        ->where('order_state', 2)
        ->where('agency_orders','!=', null)
        ->where('agency','!=', null)
        ->whereDate('date', $getDayClose->day_close)
        ->get();

    }else {
        $pending_orders_agency = \DB::table('online_customers')
        ->where('order_state', 2)
        ->whereDate('date', $getDayClose->day_close)
        ->where('agency_orders','!=', null)
        ->where('agency','!=', null)
        ->where('order_branch', auth()->user()->branch)
        ->get();
    }

    return view('online-template.display-online-agency-orders', [
        'pending_orders'=> $pending_orders_agency
    ]);
})->name('OnlineAgency')->middleware('auth');


Route::get('/orders-from-drive-through/check-to-complete', function () {
    $collection = \DB::table('invoices')
     ->where('invoice_sales_person_category', "Drive Thru")
     ->where('drive_thru_status', 0)
     ->whereDate('created_at', carbon::today())
     ->orderBy('created_at', 'ASC')
     ->paginate(30);

     $grouped = $collection->groupBy('invoice_number');
     return view('inc.drive-thru-packager', [
         'order' => $grouped
     ]);


});


// KITCHEN ORDER DISPLAY FOR ALL OUTLET BASED
Route::get('/ceqa-dashboard/delivery-orders-display', function () {

    $getDayClose = \DB::table('close_days')->first();

    $collection = \DB::table('invoices')
     ->where('invoice_sales_person_category', "Delivery")
     ->where('branch', auth()->user()->branch)
     ->where('agency', Null)
     ->where('drive_thru_status', 0)
     ->where('role_status', 1)
     ->whereDate('created_at', $getDayClose->day_close)
     ->orderBy('created_at', 'ASC')
     ->paginate(1000);

     $grouped = $collection->groupBy('invoice_number');
     return view('delivery-orders-display', [
         'order' => $grouped
     ]);

})->middleware('auth')->name('dispatch-display');

Route::get('/complete/complete-transaction', function () {
    $getDayClose = \DB::table('close_days')->first();
    Invoice::where('branch', auth()->user()->branch)
    ->where('drive_thru_status', 0)
    ->where('invoice_sales_person_category', 'Delivery')
    ->whereDate('created_at',$getDayClose->day_close)
    ->update([
        'drive_thru_status' => 1
    ]);
    return back();
});

Route::get('/print-lite-version/{inv}/{user}', [App\Http\Controllers\PrinterController::class,'PrintLite'])->name('PrintLite');


Route::get('/orders-from-drive-through/complete-transaction/{number}', function ($number) {
   
    Invoice::where('invoice_number', $number)->update([
        'drive_thru_status' => 1
    ]);
    return back();
})->name('completeDriveThru');



Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/ceqa-dashboard/all-transaction', [App\Http\Controllers\HomeController::class, 'showTransactions'])->name('showTransactions');
Route::get('/get-started', function(){
    return view('get-started');
})->name('get-started');


Route::prefix('ceqa-dashboard')->group(function () {
    Route::get('/order-infomation/{id}',[App\Http\Controllers\OrderController::class,'orderInformation'])->name('orderInformation');
    Route::get('/invoice/mark-ready/{order}',[App\Http\Controllers\OrderController::class,'markReady'])->name('markReady');
    Route::get('/composition-details-product-list/{name}', [App\Http\Controllers\InvoiceController::class, 'FromComposition'])->name('FromComposition');
    Route::get('/orders',[App\Http\Controllers\OrderController::class,'AllOrders'])->name('AllOrders');

    Route::post('/order/make-transfer',[App\Http\Controllers\OrderController::class,'TransferOrder'])->name('TransferOrderOutlet');
    Route::get('/order/pending-transfer',[App\Http\Controllers\OrderController::class,'TransferOrderPending'])->name('TransferOrderPending');
    
    Route::get('/order/approved-transfers',[App\Http\Controllers\OrderController::class,'TransferOrderAccepted'])->name('TransferOrderAccepted');


    Route::get('/order/accept-transfer',[App\Http\Controllers\OrderController::class,'acceptTransfer'])->name('acceptTransfer');
    Route::get('/accept-order-transfer/{id}',[App\Http\Controllers\OrderController::class,'acceptedTransfer'])->name('acceptedTransfer');

    Route::get('/invoice',[App\Http\Controllers\OrderController::class,'index'])->name('index.order');
    Route::get('/invoice/pending',[App\Http\Controllers\OrderController::class,'pending'])->name('pendingOrders');
    Route::get('/create-invoice', [App\Http\Controllers\InvoiceController::class, 'index'])->name('index.invoice');
    Route::get('/create-invoice/call-center', [App\Http\Controllers\InvoiceController::class, 'callcenterInvoice'])->name('callcenterInvoice');
    Route::get('/create-invoice/delivery-agency-service/{agency}', [App\Http\Controllers\InvoiceController::class, 'DeliveryAgency'])->name('DeliveryAgency');

    Route::get('/sales-today', [App\Http\Controllers\InvoiceController::class, 'salesToday'])->name('sales.today');
    Route::post('/change-password/{id}',[App\Http\Controllers\UserController::class,'changePassword'])->name('changePassword');
    Route::get('/users',[App\Http\Controllers\UserController::class,'allUSers'])->name('allUSers');
    Route::get('/users/delete-user/{user}',[App\Http\Controllers\UserController::class,'destroy'])->name('DeleteUser');

    Route::post('/add-discount',[App\Http\Controllers\DiscountController::class,'store'])->name('OrderDiscount');

    
});


Route::prefix('ceqa-dashboard')->group(function () {
    Route::get('/branches/edit-branch/{branch}',[App\Http\Controllers\BranchController::class,'edit'])->name('EditBranch');
    
    Route::get('/outlets/add-new',[App\Http\Controllers\BranchController::class,'index'])->name('index.branch');
    Route::post('/branches/save-update/{branch}',[App\Http\Controllers\BranchController::class,'update'])->name('SaveBranchChange');
    Route::post('/branches/save-new',[App\Http\Controllers\BranchController::class,'store'])->name('store.branch');
    Route::get('/delete-branch/{branch}',[App\Http\Controllers\BranchController::class,'destroy'])->name('destroy.branch');
    Route::get('/branches/view-branch-sales',[App\Http\Controllers\BranchController::class,'branchSale'])->name('branchSales');
    Route::get('/sales/view-user-sales/{user}',[App\Http\Controllers\InvoiceController::class,'userSales'])->name('userSales');
    Route::get('/report/branch-report/user',[App\Http\Controllers\InvoiceController::class,'getBranchUserData'])->name('getBranchUserData');
    Route::get('/sales-report',[App\Http\Controllers\InvoiceController::class,'salesReport'])->name('salesReport');
    Route::get('/report/branch',[App\Http\Controllers\ReportController::class,'branchSalesReport'])->name('branchSalesReport');
    Route::get('/order/transaction-details/{order}',[App\Http\Controllers\OrderController::class,'show'])->name('orderTransaction');
    
    Route::get('/product-list',[App\Http\Controllers\GeneralController::class,'index'])->name('productList');
    Route::get('/product-list/bar-items',[App\Http\Controllers\GeneralController::class,'indexBarItems'])->name('indexBarItems');


    Route::get('/report/sales-person/category-with-date',[App\Http\Controllers\ReportController::class,'getDeliveryReportDating'])->name('getDeliveryReportRouteDate');

    
    Route::get('/report/sales-person/category',[App\Http\Controllers\ReportController::class,'getDeliveryReport'])->name('getDeliveryReportRoute');
    Route::get('/report/sales-person/category-view-by-date',[App\Http\Controllers\ReportController::class,'getDeliveryReportDate'])->name('getDeliveryReportDate');
    Route::get('/print-invoice/{inv}',[App\Http\Controllers\InvoiceController::class,'showPrintDesign'])->name('showPrintDesign');
    Route::get('/print-invoice/delivery/{inv}/{id}',[App\Http\Controllers\InvoiceController::class,'showPrintDesignDelivery'])->name('showPrintDesignDelivery');
    Route::get('/report-on-sales',[App\Http\Controllers\ReportController::class,'salesTodayBySalesPerson'])->name('salesTodayBySalesPerson');
    Route::post('/change-status',[App\Http\Controllers\InvoiceController::class,'changeInvoiceStatus'])->name('changeInvoiceStatus');
  
    Route::get('/department-summary-by-date',[App\Http\Controllers\GeneralController::class,'departmentSummaryDate'])->name('departmentSummaryDate');
    Route::get('/item-summary-by-date',[App\Http\Controllers\GeneralController::class,'itemSummaryDate'])->name('itemSummaryDate');
    
    Route::get('/department-summary/date-view',[App\Http\Controllers\GeneralController::class,'showDepartmentItemDate'])->name('showDepartmentItemDate');

    Route::get('/department-summary/{branch}/{category}',[App\Http\Controllers\GeneralController::class,'itemSummarySalesType'])->name('itemSummarySalesType');
    Route::get('/department-summary-product/{branch}/{category}',[App\Http\Controllers\GeneralController::class,'itemSummarySalesTypeProduct'])->name('itemSummarySalesTypeProduct');
    Route::get('/department-view-all',[App\Http\Controllers\GeneralController::class,'allDepartmentSummary'])->name('allDepartmentSummary');
    Route::get('/department-view-all/branch',[App\Http\Controllers\GeneralController::class,'allDepartmentSummaryBranch'])->name('allDepartmentSummaryBranch');
    Route::get('/item-view-all/branch',[App\Http\Controllers\GeneralController::class,'allItemSummaryBranches'])->name('allItemSummaryBranches');

    Route::get('/item-view-all',[App\Http\Controllers\GeneralController::class,'allItemSummary'])->name('allItemSummary');
    Route::get('/item-view-all-by-branch',[App\Http\Controllers\GeneralController::class,'allItemSummaryBranch'])->name('allItemSummaryBranch');


    Route::post('/accept-payment/tingg',[App\Http\Controllers\GeneralController::class,'AcceptPayment'])->name('AcceptPayment');
    
    Route::get('/accept-payment/check-status',[App\Http\Controllers\GeneralController::class,'checkPaymentStatus'])->name('checkPaymentStatus');


    
    Route::get('/display-items-summary-for-the-day',[App\Http\Controllers\GeneralController::class,'itemSummaryAdmin'])->name('ItemSummaryAdmin');
    Route::get('/display-department-summary-for-the-day',[App\Http\Controllers\GeneralController::class,'departmentSummaryAdmin'])->name('departmentSummaryAdmin');
   
    Route::get('/display-department-summary/{id}',[App\Http\Controllers\GeneralController::class,'departmentSummary'])->name('departmentSummary');
    Route::get('/display-department-summary-by-date',[App\Http\Controllers\GeneralController::class,'departmentSummarybyDate'])->name('departmentSummarybyDate');
    Route::get('/display-item-summary-by-date',[App\Http\Controllers\GeneralController::class,'itemSummarybyDate'])->name('ItemSummarybyDate');
    
    Route::get('/display-item-summary-from-department/{department}',[App\Http\Controllers\GeneralController::class,'showDepartmentItem'])->name('showDepartmentItem');
    Route::get('/display-item-summary/with',[App\Http\Controllers\GeneralController::class,'showDepartmentItemWithDate'])->name('showDepartmentItemWithDate');

    Route::get('/display-items-summary/{id}',[App\Http\Controllers\GeneralController::class,'itemSummary'])->name('ItemSummary');
    Route::get('/display-department-summary-2/{branch}',[App\Http\Controllers\GeneralController::class,'departmentSummaryBranch'])->name('departmentSummaryBranch');
    Route::get('/display-items-branch/{branch}',[App\Http\Controllers\GeneralController::class,'itemSummaryBranch'])->name('itemSummaryBranch');
    
    Route::post('/product-service/load-bom',[App\Http\Controllers\ProductController::class,'loadBillofMaterial'])->name('loadBillofMaterial');

    Route::post('/product-service/save-barcode',[App\Http\Controllers\ProductController::class,'ProductBarcodesSave'])->name('ProductBarcodesSave');
    Route::get('/product-service/set-barcode',[App\Http\Controllers\ProductController::class,'barCodeSetting'])->name('barCodeSetting');
    
    Route::get('/change-activated-state/{outlet}/{product_id}',[App\Http\Controllers\ProductController::class,'ChangeStatusOfItem'])->name('ChangeStatusOfItem');
    Route::post('/activate-product/branches',[App\Http\Controllers\ProductController::class,'activateProduct'])->name('activateProduct');

    Route::get('/display-summary-product/{id}',[App\Http\Controllers\GeneralController::class,'productSummary'])->name('productSummary');
    Route::get('/remove-product-from-list/{id}',[App\Http\Controllers\ProductController::class,'removeItem'])->name('removeItem');
    Route::get('/export-products',[App\Http\Controllers\ProductController::class,'export'])->name('export');
    
    Route::post('/action-on-product',[App\Http\Controllers\ProductController::class,'ProductAction'])->name('ProductAction');

    Route::post('/edit-product-here/{id}',[App\Http\Controllers\ProductController::class,'productEdit'])->name('EditProduct');

    Route::get('/display-on-th-house',[App\Http\Controllers\OnHouseController::class,'show'])->name('OnTheHouse');
    Route::get('/checkprint/{id}',[App\Http\Controllers\PrintCountController::class,'store'])->name('printCount');
    
    Route::post('/delivery-location-to-dump',[App\Http\Controllers\InvoiceDumpController::class,'locationPrice'])->name('locationPrice');
    Route::get('/delete-rider/{rider}',[App\Http\Controllers\DispatchController::class,'RemoveRider'])->name('RemoveRider');
    Route::get('/transfer-order',[App\Http\Controllers\InvoiceController::class,'TransferOrder'])->name('TransferOrder');

    Route::get('/place-order/call-center',[App\Http\Controllers\InvoiceDumpController::class,'PlaceOrderCallCenter'])->name('PlaceOrderCallCenter');

    Route::get('/tables/table-management',[App\Http\Controllers\BarTableController::class,'index'])->name('tableManagement');
    Route::get('/confirm-payment/{bar}',[App\Http\Controllers\BarTableController::class,'confirmPayment'])->name('confirmPayment');
    Route::get('/settled-orders',[App\Http\Controllers\BarTableController::class,'settledTable'])->name('settledTable');
    Route::get('/add-to-invoice/{bar}',[App\Http\Controllers\BarTableController::class,'AddToReceipt'])->name('AddToReceipt');
    Route::get('/table/generate-links',[App\Http\Controllers\BarTableController::class,'tableLinks'])->name('tableLinks');

    
});

Route::get('/increase-cart/{id}/{quantity}', [App\Http\Controllers\InvoiceDumpController::class,'IncreaseCart'])->name('cartQuantity');
Route::get('/decrease-cart/{id}/{quantity}', [App\Http\Controllers\InvoiceDumpController::class,'DecreaseCart'])->name('DecreasecartQuantity');

Route::get('/barcode-search/{barcode}', [App\Http\Controllers\InvoiceDumpController::class,'barcodeAddCart'])->name('barcodeAddCart');
Route::get('/get-product-price/{id}',[App\Http\Controllers\GeneralController::class,'getPrice']);
Route::get('/get-delivery-price/{id}',[App\Http\Controllers\GeneralController::class,'getPriceLocation']);
Route::get('/ceqa-dashboard/rejected-bom',[App\Http\Controllers\GeneralController::class,'RejectItem']);

Route::get('/get-user-details/{id}',[App\Http\Controllers\GeneralController::class,'getUserName']);

Route::post('/create/invoice-dump-call',[App\Http\Controllers\InvoiceDumpController::class,'storeCall'])->name('InvoiceDumpCall');

Route::post('/create/invoice-dump',[App\Http\Controllers\InvoiceDumpController::class,'store'])->name('InvoiceDump');
Route::get('/ceqafoods/delete-item/{id}',[App\Http\Controllers\InvoiceDumpController::class,'InvoiceDumpDestroy'])->name('InvoiceDumpDestroy');
Route::get('/generate-invoice',[App\Http\Controllers\InvoiceController::class,'generateInvoice'])->name('generateInvoice');
Route::get('/generate-invoice/delivery/{id}',[App\Http\Controllers\InvoiceController::class,'generateInvoiceDelivery'])->name('generateInvoiceDelivery');
Route::post('/generate-invoice/bar-invoice',[App\Http\Controllers\InvoiceController::class,'generateInvoiceBar'])->name('generateInvoiceBar');

Route::get('/create/invoice-dump/new-transaction',[App\Http\Controllers\InvoiceDumpController::class,'destroy'])->name('deleteDump');




// Report

Route::prefix('ceqa-dashboard')->group(function () {
Route::post('/onhouse-users',[App\Http\Controllers\HousePersonController::class,'store'])->name('store.HousePerson');
Route::get('/summary/on-the-house/{id}',[App\Http\Controllers\HousePersonController::class,'summary'])->name('HouseSummary');


Route::get('/report',[App\Http\Controllers\ReportController::class,'reportByDate'])->name('dateReport');

Route::get('/report-by-user',[App\Http\Controllers\ReportController::class,'dateReportByUser'])->name('dateReportByUser');
});





Route::prefix('ceqa-dashboard')->group(function () {
    Route::post('/load-products',[App\Http\Controllers\ProductController::class,'load'])->name('loadProduct');
    Route::get('/products-settings',[App\Http\Controllers\ProductController::class,'productSettings'])->name('productSettings');
    Route::post('/products-settings/remove',[App\Http\Controllers\ProductController::class,'SetBomData'])->name('SetBomData');

    
    Route::post('/add-product-items',[App\Http\Controllers\ProductController::class,'store'])->name('addProduct');
    Route::get('/compostions-product/{id}', [App\Http\Controllers\MaterialProductCompositonController::class, 'composition'])->name('composition');

    Route::post('/update-customer',[App\Http\Controllers\CustomerController::class,'update'])->name('updateCustomer');
    Route::get('/customer/transaction/view-customer/{id}',[App\Http\Controllers\CustomerController::class,'transactionsDetails'])->name('orders.customer');
    Route::post('/save-customer',[App\Http\Controllers\CustomerController::class,'store'])->name('customer');
    Route::post('/save-customer-drive-thru',[App\Http\Controllers\CustomerController::class,'storeDrive'])->name('customerDrive');
    Route::post('/save-customer/agency',[App\Http\Controllers\CustomerController::class,'storeAgency'])->name('storeAgency');

    Route::get('/update-note/{customer_id}/{note}',[App\Http\Controllers\CustomerController::class,'updateNote'])->name('updateNote');


    Route::get('/customer-note/{note}',[App\Http\Controllers\CustomerController::class,'CustomerNote'])->name('CustomerNote');
    Route::get('/customer-name/{name}',[App\Http\Controllers\CustomerController::class,'CustomerName'])->name('CustomerName');
    Route::get('/customer-address/{address}',[App\Http\Controllers\CustomerController::class,'CustomerAddress'])->name('CustomerAddress');
    Route::get('/customer-contact/{contact}',[App\Http\Controllers\CustomerController::class,'CustomerContact'])->name('CustomerContact');


    Route::get('/delete-customer/{customer}',[App\Http\Controllers\CustomerController::class,'destroy'])->name('destroy.customer');
  
    Route::get('/create-invoice-delivery/{customer_id}/{agency}',[App\Http\Controllers\CustomerController::class,'indexAgency'])->name('indexAgency');

    Route::get('/create-invoice-delivery/{customer_id}',[App\Http\Controllers\CustomerController::class,'index'])->name('index.customer');
    Route::get('/customer-list',[App\Http\Controllers\CustomerController::class,'show'])->name('show.customer');
    Route::get('/customer-list/transactions-today',[App\Http\Controllers\CustomerController::class,'showNewAndTransactions'])->name('showNewAndTransactions');
    Route::get('/customer-list/transactions-by-all',[App\Http\Controllers\CustomerController::class,'customerReportDate'])->name('customerReportDate');

    Route::get('/customer-list/transactions-by',[App\Http\Controllers\CustomerController::class,'customerReportDateBranch'])->name('customerReportDateBranch');

    Route::post('/update-remark/{remark}',[App\Http\Controllers\RemarkController::class,'update'])->name('updateRemark');
    Route::post('/save-reviews',[App\Http\Controllers\RemarkController::class,'store'])->name('saveRemark');
    Route::get('/reviews-summary',[App\Http\Controllers\RemarkController::class,'index'])->name('review.index');
    Route::get('/reviews-summary/show-by-category/{category}',[App\Http\Controllers\RemarkController::class,'category'])->name('reviewCategory');
    Route::get('/preview-review/{id}',[App\Http\Controllers\RemarkController::class,'preview'])->name('preview');
    Route::get('/reviews-summary/show-by-category-department/pizzaman-{category}',[App\Http\Controllers\RemarkController::class,'categoryDepartmentPizzaman'])->name('reviewCategoryDepartment');
    Route::get('/reviews-summary/show-by-category-department/chickenman-{category}',[App\Http\Controllers\RemarkController::class,'categoryDepartmentChickenman'])->name('reviewCategoryDepartmentChicken');

    Route::get('/tables',[App\Http\Controllers\RegisterTableController::class,'index'])->name('table.index');
    Route::post('/tables/create',[App\Http\Controllers\RegisterTableController::class,'create'])->name('table.create');
    Route::get('/tables/delete/{table}',[App\Http\Controllers\RegisterTableController::class,'destory'])->name('DeleteTable');
    Route::post('/tables/update/{table}',[App\Http\Controllers\RegisterTableController::class,'update'])->name('table.update');



});




Route::prefix('ceqa-dashboard')->group(function () {
    Route::post('/save-on-the-house',[App\Http\Controllers\OnHouseController::class,'store'])->name('onHouse');

    Route::get('/account-settings/profile',[App\Http\Controllers\AccountSettingController::class,'index'])->name('index.account');

    Route::get('/users/view-profile/{user}',[App\Http\Controllers\UserController::class,'edit'])->name('editUser');
    
    Route::post('/update-user/{user}',[App\Http\Controllers\UserController::class,'update'])->name('updateuser');

    Route::post('/account/new-user',[App\Http\Controllers\UserController::class,'create'])->name('registerUser');

    Route::post('/change-account/{user}',[App\Http\Controllers\UserController::class,'changePasswordUser'])->name('changePasswordUser');

    Route::post('/update-profile/{user}',[App\Http\Controllers\UserController::class,'updateUserProfile'])->name('updateUserProfile');
    
    Route::post('/update-profile-assigned-to-inventory/{user}',[App\Http\Controllers\UserController::class,'AssignStore'])->name('AssignStore');
    Route::get('/inventory',[App\Http\Controllers\UserController::class,'inventory'])->name('inventory');
});


Route::prefix('ceqa-dashboard')->group(function () {
// CASHIER

    Route::get('/cashier/report',[App\Http\Controllers\DispatchController::class,'CashierReport'])->name('CashierReport');
    Route::get('/report-by-cashier/transaction',[App\Http\Controllers\ReportController::class,'dateReportByCashier'])->name('dateReportByCashier');
    Route::get('/make-sales/cashier',[App\Http\Controllers\DispatchController::class,'indexcashier'])->name('index.cashier');

    Route::get('/make-sales/dispatch-notification',[App\Http\Controllers\DispatchController::class,'notification'])->name('notification.dispatch');
    Route::get('/make-sales/dispatch',[App\Http\Controllers\DispatchController::class,'index'])->name('index.dispatch');
    Route::get('/dispatch',[App\Http\Controllers\DispatchItemController::class,'index'])->name('index.dispatchItem');
    Route::get('/dispatch-item/{dispatchitem}',[App\Http\Controllers\DispatchItemController::class,'destroy'])->name('destroy.dispatchItem');
    Route::post('/dispatch/save-data',[App\Http\Controllers\DispatchItemController::class,'store'])->name('store.dispatchItem');
    Route::get('/dispatch/report',[App\Http\Controllers\DispatchController::class,'DispatchReport'])->name('DispatchReport');
    Route::post('/save-dispatch-location',[App\Http\Controllers\DispatchItemController::class,'loadLocations'])->name('loadLocations');
    Route::post('/save-dispatch-location/update-price/{dispatachtem}',[App\Http\Controllers\DispatchItemController::class,'updateDispatch'])->name('updateDispatch');
    Route::post('/dispatch-items/delete-all',[App\Http\Controllers\DispatchItemController::class,'DeleteDispatchItem'])->name('DeleteDispatchItem');

    
    Route::get('/customer-info/{id}',[App\Http\Controllers\DispatchController::class,'customerInfo'])->name('customerInfo');
    Route::get('/dispatch/{order_number}',[App\Http\Controllers\DispatchController::class,'markAsCompleted'])->name('markAsCompleted');

    Route::post('/save-rider',[App\Http\Controllers\DispatchController::class,'rider'])->name('store.rider');
    Route::get('/riders',[App\Http\Controllers\DispatchController::class,'riderIndex'])->name('index.rider');
    Route::get('/transactions-by-rider',[App\Http\Controllers\DispatchController::class,'riderTransactions'])->name('riderTransactions');
    

    Route::get('/generate-draft-invoice',[App\Http\Controllers\DraftInvoiceController::class,'store'])->name('draftInvoice');
    Route::get('/draft-invoice/show',[App\Http\Controllers\DraftOrderController::class,'index'])->name('viewDraft');
    
    Route::get('/new-invoice-from-draft/{id}',[App\Http\Controllers\DraftOrderController::class,'saveToDump'])->name('saveToDump');
    Route::get('/view-orders',[App\Http\Controllers\GeneralController::class,'search'])->name('searchOrder');
    Route::get('/view-orders/processing-by-rider',[App\Http\Controllers\GeneralController::class,'ProcessingTransactions'])->name('ProcessingTransactions');
    Route::post('/materials-create',[App\Http\Controllers\RawMaterialController::class,'store'])->name('store.rawmaterial');
    Route::get('/raw-materials-list',[App\Http\Controllers\RawMaterialController::class,'show'])->name('productListMaterials');
    Route::get('/raw-materials-list/delete-from-list/{raw}',[App\Http\Controllers\RawMaterialController::class,'destroy'])->name('DeleteMaterial');

    Route::get('/remove-bom-from-list/{id}',[App\Http\Controllers\CompositionRecordController::class,'DeleteBOMSingle'])->name('DeleteBOMSingle');

    Route::get('/product-composition-report-by-date',[App\Http\Controllers\CompositionRecordController::class,'compReportDate'])->name('compReportDate');
    Route::get('/product-add-composing/{id}',[App\Http\Controllers\CompositionRecordController::class,'addCompositionToProduct'])->name('addCompositionToProduct');
    Route::get('/save-unit/{id}/{unit}/{bom_id}',[App\Http\Controllers\CompositionRecordController::class,'updateBOMmaterial'])->name('updateBOMmaterial');

    Route::get('/riders/dispatch/report-bydate',[App\Http\Controllers\DispatchController::class,'RiderReportDate'])->name('RiderReportDate');

    Route::get('/riders/dispatch/report',[App\Http\Controllers\DispatchController::class,'riderReport'])->name('riderReport');
    Route::get('/product-composing-report',[App\Http\Controllers\CompositionRecordController::class,'show'])->name('RawReport');
    Route::get('/reverse-composition',[App\Http\Controllers\MaterialProductCompositonController::class,'ReverseProductComposition'])->name('ReverseProductComposition');

    
    Route::post('/product-composing-save',[App\Http\Controllers\MaterialProductCompositonController::class,'create'])->name('MaterialProductCompositon');
    Route::get('/product-composing-report-for-branch',[App\Http\Controllers\CompositionRecordController::class,'RawMaterialBranchReport'])->name('RawMaterialBranchReport');
    Route::get('/product-composing/delete-composition-item/{materialProductCompositon}',[App\Http\Controllers\MaterialProductCompositonController::class,'destroy'])->name('removeProductComposition');
    Route::get('/product-composing-report-for-user',[App\Http\Controllers\CompositionRecordController::class,'RawMaterialUserReport'])->name('RawMaterialUserReport');

    Route::get('/discounts/gift-card-and-coupons',[App\Http\Controllers\CelebrityDiscountController::class,'index'])->name('celebrity.index');
    Route::post('/discounts/celebrity/store-discount',[App\Http\Controllers\CelebrityDiscountController::class,'store'])->name('store.celebdiscount');
    Route::get('/celeb-discount/delete/{celebrityDiscount}',[App\Http\Controllers\CelebrityDiscountController::class,'destroy'])->name('destroy.celebrity');
    
    Route::get('/discounts/celebrity-records/{discount_code}',[App\Http\Controllers\CelebrityDiscountRecordController::class,'show'])->name('celebRecords');

    Route::get('/item-category',[App\Http\Controllers\ItemCategoryController::class,'index'])->name('categoryItem.index');
    Route::post('/item-category/create',[App\Http\Controllers\ItemCategoryController::class,'store'])->name('category.store');
    Route::get('/item-category/destroy/{itemCategory}',[App\Http\Controllers\ItemCategoryController::class,'destroy'])->name('DeleteCategory');
    Route::post('/item-category/update/{itemCategory}',[App\Http\Controllers\ItemCategoryController::class,'update'])->name('category.update');

    Route::get('/delete-target/{$monthTarget}',[App\Http\Controllers\MonthTargetController::class,'delete'])->name('targets.delete');
    Route::get('/target/show',[App\Http\Controllers\MonthTargetController::class,'index'])->name('targets.index');
    Route::post('/target/save',[App\Http\Controllers\MonthTargetController::class,'store'])->name('store.target');
    Route::get('/activate-target',[App\Http\Controllers\MonthTargetController::class,'ActivateTarget'])->name('ActivateTarget');

    Route::post('/store/agency',[App\Http\Controllers\AgencyController::class,'store'])->name('store.agency');
    Route::post('/update/agency/{agency}',[App\Http\Controllers\AgencyController::class,'update'])->name('updateAgency');
    Route::get('/delete/agency/{agency}',[App\Http\Controllers\AgencyController::class,'destroy'])->name('deleteAgency');


    Route::get('/agency/new-agency',[App\Http\Controllers\AgencyController::class,'index'])->name('index.agency');
    Route::get('/agency/report',[App\Http\Controllers\AgencyController::class,'GetAgencyReport'])->name('GetAgencyReport');



    Route::get('/delivery-prices',[App\Http\Controllers\DispatchItemController::class,'deliveryPricing'])->name('deliveryPricing');


    Route::get('/target/view-analysis',[App\Http\Controllers\TargetAnalysisController::class,'show'])->name('TargetAnalysis');
    Route::get('/customer-reviews/sort',[App\Http\Controllers\WebsiteReviewController::class,'ReviewByDate'])->name('reviewByDate');
    Route::get('/customer-reviews',[App\Http\Controllers\WebsiteReviewController::class,'index'])->name('websitereview.index');
    
});

Route::post('/switch-branch', function(Request $request){
    $user = User::findOrfail(auth()->user()->id);
    $user -> branch = $request->branch;
    $user->save();
    return back()->with('status', 'BRANCH SWITCHED TO ' . $request->branch);
})->name('switch')->middleware('auth');


Route::get('/generate-draft/delivery/{id}',[App\Http\Controllers\DraftInvoiceController::class,'DraftInvoiceDelivery'])->name('DraftInvoiceDelivery');


Route::post('/make-sales/dispatch/process-order',[App\Http\Controllers\DispatchController::class,'store'])->name('processOrder');


Route::get('groupby', function (){
    $invoice = \DB::table('invoices')->get();
    $inv = $invoice->groupBy('invoice_number');
    return view('invoice.all-invoice', [
        'invoices_all' => $inv->all()
    ]);
});



Route::get('/delivery-page', [App\Http\Controllers\GeneralController::class,'DirectDelivery'])->name('DirectDelivery');

Route::get('/ceqa-dashboard/search-results-orders', [App\Http\Controllers\DispatchController::class, 'searchResults'])->name('searchInvoice');

Route::get('/agencies', function (Request $request){
   return \DB::table('invoices')->where('agency', "JUMIA")->get();
})->name('agenciesQuery');



Route::get('/website/reviews', function (Request $request){
        return view('website-review-forms');
 })->name('webReviews');
 

 Route::post('/website/save-review', function (Request $request){
    
    $rules = array(
        'customer_name' => 'required|max:300',
        'branch' => 'required|max:300',
        'rate_product' => 'required|max:12',
        'rate_service' => 'required|max:20',
        'recommendation' => 'required|max:20',
    );
    
    $validator = Validator::make($request->all(), $rules);
    if ($validator->fails()) {
        return back()->with('statuspass', $validator->errors());
    }

    $data = new WebsiteReview;
    $data -> customer_name = $request -> customer_name;
    $data -> contact = $request -> phone;
    $data -> branch = $request -> branch;
    $data -> product_bought = $request -> product_bought;
    $data -> rate_product = $request -> rate_product;
    $data -> rate_service = $request -> rate_service;
    $data -> recommendation= $request -> recommendation;
    $data -> comment= $request -> comment;
    $data -> save();
    return back()->with('status', "Thank you, Review Submitted Successfully");
})->name('websiteReview');




Route::prefix('ceqa-dashboard-online-orders')->group(function () {
    Route::get('/home', function(){

        $approved = \DB::table('online_orders')->where('state', 1)->get();
        return view('online-template.dashboard-online', [
            'approved_orders' => $approved
        ]);
    })->middleware('auth')->name('onlineOrders');



    Route::get('/approved-orders', function(){
        $getDayClose = \DB::table('close_days')->first();
        if (auth()->user()->role == "Administrator") {
             $pending_orders = \DB::table('online_customers')
            ->where('order_state', 1)
            ->whereDate('date', $getDayClose->day_close)
            ->get();

        }else {
            $pending_orders = \DB::table('online_customers')
            ->where('order_state', 1)
            ->whereDate('date', $getDayClose->day_close)
            ->where('order_branch', auth()->user()->branch)
            ->get();
        }
        return view('online-template.approved-orders', [
            'pending_orders' => $pending_orders,
        ]);

    })->middleware('auth')->name('ApprovedOrders');



    Route::get('/orders', function(){
        $getDayClose = \DB::table('close_days')->first();
        if (auth()->user()->role == "Administrator") {
             $pending_orders = \DB::table('online_customers')
            ->where('order_state', 2)
            ->whereDate('date', $getDayClose->day_close)
            ->get();

        }else {
            $pending_orders = \DB::table('online_customers')
            ->where('order_state', 2)
            ->whereDate('date', $getDayClose->day_close)
            ->where('order_branch', auth()->user()->branch)
            ->get();
        }
        return view('online-template.pending-orders', [
            'pending_orders' => $pending_orders,
        ]);

    })->middleware('auth')->name('pendingOrders');



    Route::get('/rejected-orders', function(){
        $getDayClose = \DB::table('close_days')->first();
        if (auth()->user()->role == "Administrator") {
             $pending_orders = \DB::table('online_customers')
            ->where('order_state', 0)
            ->whereDate('date', $getDayClose->day_close)
            ->get();

        }else {
            $pending_orders = \DB::table('online_customers')
            ->where('order_state', 0)
            ->whereDate('date', $getDayClose->day_close)
            ->where('order_branch', auth()->user()->branch)
            ->get();
        }
        return view('online-template.rejected-orders', [
            'pending_orders' => $pending_orders,
        ]);

    })->middleware('auth')->name('rejectedOrders');





    Route::get('preview-order', function(Request $request){

        $validateType = \DB::table('online_customers')->where('invoice_number', $request->invoice_number)->first();
        if (empty($validateType->agency)) {
            $customer_orders = \DB::table('online_customers')->select('orders')->where('invoice_number', $request->invoice_number)->get();
        }else {
            $customer_orders = \DB::table('online_customers')->where('invoice_number', $request->invoice_number)->get();
            print_r(json_decode($customer_orders->agency_orders)) ;

            $result =[];
            foreach (json_decode($customer_orders) as $key => $orders) {
                $result[] = $key;
            }
            return $result;
        }
        return view('inc.preview-customer-order',  [
           'customer_info' =>  \DB::table('online_customers')->where('invoice_number', $request->invoice_number)->first(),
           'customer_orders' =>  $customer_orders,
           'totaling' => \DB::table('online_orders')->where('invoice_number', $request->invoice_number)->sum('item_total')
        ]);
    })->name('PreviewOrder')->middleware('auth');


    Route::get('preview-order/cancel/{id}', function($id){

        \DB::table('online_customers')->where('invoice_number', $id)->update(
            [
                'order_state' => 0,
        ]);
        return back();
    })->name('cancelOrder')->middleware('auth');


    Route::get('/preview-order/accept-order/{id}',[App\Http\Controllers\CustomerController::class,'OnlineCustomerInvoice'])->name('AcceptPrint');
    Route::get('/transactions/report',[App\Http\Controllers\OnlineTransactionController::class,'OnlineTransaction'])->name('OnlineReport');
    Route::get('/preview-order/agency-order/{id}',[App\Http\Controllers\CustomerController::class,'OnlineCustomerAgency'])->name('OnlineCustomerAgency');

    Route::get('/orders/all-orders', function(){
    return view('online-template.dashboard-online-orders');
    })->name('AllOnlineOrders');

});


Route::get('/cart', function(){
    \Artisan::call('cache:clear');
});

Route::post('/settings/app-settings/save', [App\Http\Controllers\AccountSettingController::class, 'store'])->name('saveSettings');




Route::get('/ceqa-dashboard/brands', [App\Http\Controllers\BrandController::class,'index'])->name('brand.index');
Route::get('/ceqa-dashboard/brands/destroy/{brand_name:id}', [App\Http\Controllers\BrandController::class,'destroy'])->name('brand.destroy');

Route::post('/ceqa-dashboard/brands/save', [App\Http\Controllers\BrandController::class,'create'])->name('brand.create');
Route::post('/ceqa-dashboard/brands/update/{brand}', [App\Http\Controllers\BrandController::class,'update'])->name('brand.update');

Route::get('/ceqa-dashboard/503/maintainance-mode', function(){
    abort(503, 'Service Unavailable');
})->middleware('auth');








