<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title><?php echo e($app->app_name); ?> - Sales Transactions</title>
        <link rel="icon" type="image/x-icon" href="/img/<?php echo e($app->app_logo); ?>">

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/daterange/daterange.css')); ?>">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/dropzone/dropzone.min.css')); ?>" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="<?php echo e(asset('css/bootstrap.min.css')); ?>">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="<?php echo e(asset('fonts/style.css')); ?>">

        <!-- Main css -->
        <link rel="stylesheet" href="<?php echo e(asset('css/main.css')); ?>">

        <!-- fontAwesome -->
        <link href="<?php echo e(asset('fontawesome/css/all.css')); ?>" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/datatables/dataTables.bs4.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(asset('vendor/datatables/dataTables.bs4-custom.css')); ?>" />
        <link href="<?php echo e(asset('vendor/datatables/buttons.bs.css')); ?>" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="<?php echo e(asset('libs/sweetalert2/sweetalert2.min.css')); ?> " rel="stylesheet" type="text/css" />


        <script src="<?php echo e(asset('js/ajax.min.js')); ?>"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/bs-select/bs-select.css')); ?>" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/megamenu/css/megamenu.css')); ?>">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/search-filter/search-filter.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('vendor/search-filter/custom-search-filter.css')); ?>">


		
	</head>

<body onload="window.print();">

<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <a href="<?php echo e(route('home')); ?>" class="logo">
                    <img src="/img/<?php echo e($app->app_logo); ?>" alt="Logo" style="max-width:120px;">
                </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: <?php echo e(auth()->user()->name); ?> <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="invoice-details">
                <address class="m-0">
                    <strong><?php echo e($app->app_name); ?></strong>,<br>
                    <?= @strtoupper("SALES TRANSACTION - [ORDER SUMMARY]") ?><br>
                    REPORT ON SALES FROM: 
                    <?php if(Auth()->user()->role == "Administrator"): ?>
                    ALL BRANCHES
                    <?php elseif(Auth()->user()->role == "Branch Officer"): ?>
                    <?php echo e(@strtoupper(auth()->user()->branch)); ?>

                    <?php else: ?>
                    <?php echo e(@strtoupper(auth()->user()->name)); ?>

                    <?php endif; ?>
                </address>

                <div class="invoice-num">
                    <div>Report Date</div>
                    <div> <?php echo e(request()->date == null ? $dayClose->day_close : request()->date); ?></div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->

    <div class="table-responsive">
	<table class="table table-bordered table-striped m-0">
    <thead>
        <tr>
            <th>#Tran. ID</th>
            <th>Date</th>
            <th>Category</th>
            <th>Quantity</th>												
            <th>Discount</th>
            <th>Amount Recieved</th>
            <th>Total Cost</th>
            
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $all_sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><strong> <a href="<?php echo e(route('orderTransaction',$list->order_id)); ?>">#<?php echo e($list->order_id); ?></a></strong></td>
            <td><?php echo e($list->created_at); ?></td>
            <td><?php echo e(@strtoupper($list->category)); ?></td>
            <td><?php echo e($list->branch); ?></td>
            <td><?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?><?php echo number_format($list->discount, 2); ?></td>
            <td><?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?><?php echo number_format($list->total_cost_order-$list->discount, 2); ?></td>
            <td><?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?><?php echo number_format($list->total_cost_order, 2); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><strong>ORDERS: <?php echo number_format($all_sales->count(), 2); ?></strong></td>
            <td></td>
            <td></td>
            <td></td>
            <td><strong>DISCOUNT: <?php echo number_format($all_sales->sum('discount'), 2); ?></strong></td>
            <td><strong>TOTAL AMOUNT RECIEVED: <?php echo number_format($all_sales->sum('total_cost_order') - $all_sales->sum('discount'), 2); ?></strong></td>
            <td><strong>TOTAL COST: <?php echo number_format($all_sales->sum('total_cost_order'), 2); ?></td>
        </tr>
    </tbody>
	</table>
</div>

</div>
</div>
</div>



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
		<script src="<?php echo e(asset('js/bootstrap.bundle.min.js')); ?>"></script>
		<script src="<?php echo e(asset('js/modernizr.js')); ?>"></script>
		<script src="<?php echo e(asset('js/moment.js')); ?>"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="<?php echo e(asset('libs/sweetalert2/sweetalert2.min.js')); ?>"></script>
		
		<!-- Megamenu JS -->
		<script src="<?php echo e(asset('vendor/megamenu/js/megamenu.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/megamenu/js/custom.js')); ?>"></script>

		<!-- Slimscroll JS -->
		<script src="<?php echo e(asset('vendor/slimscroll/slimscroll.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/slimscroll/custom-scrollbar.js')); ?>"></script>

		<!-- Search Filter JS -->
		<script src="<?php echo e(asset('vendor/search-filter/search-filter.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/search-filter/custom-search-filter.js')); ?>"></script>

		<!-- Apex Charts -->
		<script src="<?php echo e(asset('vendor/apex/apexcharts.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/salesGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/ordersGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/earningsGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/visitorsGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/customersGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/sparkline.js')); ?>"></script>

		<!-- Circleful Charts -->
		<script src="<?php echo e(asset('vendor/circliful/circliful.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/circliful/circliful.custom.js')); ?>"></script>


		<!-- Bootstrap Select JS -->
		<script src="<?php echo e(asset('vendor/bs-select/bs-select.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/bs-select/bs-select-custom.js')); ?>"></script>


		<!-- Data Tables -->
		<script src="<?php echo e(asset('vendor/datatables/dataTables.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/dataTables.bootstrap.min.js')); ?>"></script>
		
		<!-- Custom Data tables -->
		<script src="<?php echo e(asset('vendor/datatables/custom/custom-datatables.js')); ?>"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="<?php echo e(asset('vendor/datatables/buttons.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/jszip.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/pdfmake.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/vfs_fonts.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/html5.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/buttons.print.min.js')); ?>"></script>

		<!-- Dropzone JS -->
		<script src="<?php echo e(asset('vendor/dropzone/dropzone.min.js')); ?>"></script>

		<!-- Date Range JS -->
		<script src="<?php echo e(asset('vendor/daterange/daterange.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/daterange/custom-daterange.js')); ?>"></script>

		<!-- Main Js Required -->
		<script src="<?php echo e(asset('js/main.js')); ?>"></script>

	</body>

</html>
<?php /**PATH /home/morttsons/public_html/morttsonsposfiles/resources/views/all-orders.blade.php ENDPATH**/ ?>