
<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Title -->
		<?php if(Route::currentRouteName() == "showDepartmentItem"): ?>
		<title>
		<?php echo e($app->app_name); ?>, SALE REPORT FOR <?php echo date("d/m/Y");?>
		</title>
		<?php else: ?>
		<title>Welcome ~ <?php echo e($app->app_name); ?> | POINT OF SALES SYSTEM</title>
		<?php endif; ?>

		<!-- Sweet Alert-->
		<link href="<?php echo e(asset('vendor/libs/sweetalert2/sweetalert2.min.css')); ?> " rel="stylesheet" type="text/css" />
		<!-- Ajax Call -->
		<script src="<?php echo e(asset('js/ajax.min.js')); ?>"></script>

		<link rel="icon" type="image/x-icon" href="/img/<?php echo e($app->app_logo); ?>">

		<?php echo $__env->make('inc.assets', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	
	</head>
	<body>
	<?php if($getDayClose->app_state == 0): ?>
		<script>
			window.location.href = "/ceqa-dashboard/503/maintainance-mode"
		</script>
	<?php endif; ?>

		<!-- Loading wrapper start -->
		<!-- <div id="loading-wrapper">
			<div class="spinner-border"></div>
			Loading...
		</div> -->
		<!-- Loading wrapper end -->

		<!-- Page wrapper start -->
		<div class="page-wrapper">
			
			<!-- Sidebar wrapper start -->
			<nav class="sidebar-wrapper">

				<!-- Sidebar content start -->
				<div class="sidebar-tabs">

					<!-- Tabs nav start -->
					<div class="nav" role="tablist" aria-orientation="vertical">
						<a href="#" class="logo">
							<img src="/img/logofav.png" alt="Logo">
						</a>
						<a class="nav-link active" id="home-tab" data-bs-toggle="tab" href="#tab-home" role="tab" aria-controls="tab-home" aria-selected="true">
							<i class="icon-home2"></i>
							<span class="nav-link-text">Dashboards</span>
						</a>
						<a class="nav-link" id="product-tab" data-bs-toggle="tab" href="#tab-product" role="tab" aria-controls="tab-product" aria-selected="false">
							<i class="icon-layers2"></i>
							<span class="nav-link-text">Items</span>
						</a>
						<a class="nav-link" id="pages-tab" data-bs-toggle="tab" href="#tab-pages" role="tab" aria-controls="tab-pages" aria-selected="false">
							<i class="icon-book-open"></i>
							<span class="nav-link-text">Make Sales</span>
						</a>
						<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
						<a class="nav-link" id="authentication-tab" data-bs-toggle="tab" href="#tab-authentication" role="tab" aria-controls="tab-authentication" aria-selected="false">
							<i class="icon-unlock"></i>
							<span class="nav-link-text">Authentication</span>
						</a>
						<?php endif; ?>
						<a class="nav-link settings" id="settings-tab" data-bs-toggle="tab" href="#tab-settings" role="tab" aria-controls="tab-authentication" aria-selected="false">
							<i class="icon-settings1"></i>
							<span class="nav-link-text">Settings</span>
						</a>
					</div>
					<!-- Tabs nav end -->

					<!-- Tabs content start -->
					<div class="tab-content">
								
						<!-- Chat tab -->
						<div class="tab-pane fade show active" id="tab-home" role="tabpanel" aria-labelledby="home-tab">

							<!-- Tab content header start -->
							<div class="tab-pane-header">
								Dashboards
							</div>
							<!-- Tab content header end -->

							<!-- Sidebar menu starts -->
							<div class="sidebarMenuScroll">
								<div class="sidebar-menu">
									<ul>
										<li>
											<a href="<?php echo e(route('home')); ?>" class="<?php echo e(Route::currentRouteName() == "home" ? 'current-page' : ""); ?>">
												Dashboard
											</a>
										</li>
										<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
										<li>
											<a href="<?php echo e(route('salesReport')); ?>" class="<?php echo e(Route::currentRouteName() == "salesReport" ? 'current-page' : ""); ?>">Sales Report</a>
										</li>

										<li>
											<a href="<?php echo e(route('riderReport')); ?>" class="<?php echo e(Route::currentRouteName() == "riderReport" ? 'current-page' : ""); ?>">Rider Report</a>
										</li>

										<li>
											<a href="<?php echo e(route('OnTheHouse')); ?>" class="<?php echo e(Route::currentRouteName() == "OnTheHouse" ? 'current-page' : ""); ?>">No Charge Report</a>
										</li>

										<li>
											<a href="<?php echo e(route('review.index')); ?>" class="<?php echo e(Route::currentRouteName() == "review.index" ? 'current-page' : ""); ?>"">Cust. Reviews Summary</a>
										</li>
										<?php endif; ?>
										<li>
											<a href="#" data-bs-toggle="modal" data-bs-target="#agency">Agency Report</a>
										</li>
										<?php if($bar == 0): ?>
										<?php if(auth()->user()->role == "Administrator"): ?>
										<li>
											<a href="<?php echo e(route('tableManagement')); ?>">Table Management</a>
										</li>
										<?php endif; ?>
										<?php else: ?>
										<li>
											<a href="<?php echo e(route('tableManagement')); ?>">Table Management</a>
										</li>
										<?php endif; ?>
									
										<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
										<?php if($app->sales_target == 1): ?>
										<li>
                                            <a href="#"  data-bs-toggle="modal" data-bs-target="#exampleModalCenteredTarget">Target & Sales Progress</a>
						
										</li>
										<?php endif; ?>
										<?php endif; ?>
									</ul>
								
								</div>
							</div> 
							
							<!-- Sidebar menu ends -->

							
						</div>

						<!-- Pages tab -->
						<div class="tab-pane fade" id="tab-product" role="tabpanel" aria-labelledby="product-tab">
							
							<!-- Tab content header start -->
							<div class="tab-pane-header">
								Items
							</div>
							<!-- Tab content header end -->

							<!-- Sidebar menu starts -->
							<div class="sidebarMenuScroll">
								<div class="sidebar-menu">
									<ul>
										<?php if(auth()->user()->role == "Administrator"): ?>
										<li>
											<a href="<?php echo e(route('index.agency')); ?>" class="<?php echo e(Route::currentRouteName() == "index.agency" ? 'current-page' : ""); ?>">Agency</a>
										</li>
										<?php endif; ?>
										<li>
											<a href="<?php echo e(route('productList')); ?>" class="<?php echo e(Route::currentRouteName() == "productList" ? 'current-page' : ""); ?>">Product & Service</a>
										</li>
										<?php if(auth()->user()->role != "Administrator"): ?>
										<li>
											<a href="<?php echo e(route('deliveryPricing')); ?>" class="<?php echo e(Route::currentRouteName() == "deliveryPricing" ? 'current-page' : ""); ?>">Delivery Prices</a>
										</li>
										<?php endif; ?>
										
										<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
										<li>
											<a href="<?php echo e(route('categoryItem.index')); ?>" class="<?php echo e(Route::currentRouteName() == "categoryItem.index" ? 'current-page' : ""); ?>">Item Category</a>
										</li>
										<li>
											<a href="<?php echo e(route('brand.index')); ?>" class="<?php echo e(Route::currentRouteName() == "brand.index" ? 'current-page' : ""); ?>">Item Brands</a>
										</li>
										<?php endif; ?>
										<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
										<li>
											<a href="<?php echo e(route('index.dispatchItem')); ?>" class="<?php echo e(Route::currentRouteName() == "index.dispatchItem" ? 'current-page' : ""); ?>">Delivery Prices</a>
										</li>
										<li>
											<a href="<?php echo e(route('celebrity.index')); ?>" class="<?php echo e(Route::currentRouteName() == "celebrity.index" ? 'current-page' : ""); ?>">Coupons</a>
										</li>
										<?php endif; ?>
										<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Branch::class)): ?>
										<li>
											<a href="<?php echo e(route('index.branch')); ?>" class="<?php echo e(Route::currentRouteName() == "index.branch" ? 'current-page' : ""); ?>">Outlet</a>
										</li>
										<?php endif; ?>
										<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
										<li>
											<a href="<?php echo e(route('targets.index')); ?>" class="<?php echo e(Route::currentRouteName() == "targets.index" ? 'current-page' : ""); ?>">New Target</a>
										</li>
										<?php endif; ?>
										<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Dispatch::class)): ?>
										<li>
											<a href="<?php echo e(route('index.rider')); ?>" class="<?php echo e(Route::currentRouteName() == "index.rider" ? 'current-page' : ""); ?>">Dispatch Rider</a>
										</li>
										<?php endif; ?>
										<li>
											<a href="<?php echo e(route('show.customer')); ?>" class="<?php echo e(Route::currentRouteName() == "show.customer" ? 'current-page' : ""); ?>">Customers</a>
										</li>
										<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
										<li>
											<a href="<?php echo e(route('table.index')); ?>">New Bar-Table</a>
										</li>
										<?php endif; ?>
									</ul>
								</div>
							</div>
							<!-- Sidebar menu ends -->
						</div>

						<!-- Pages tab -->
						<div class="tab-pane fade" id="tab-pages" role="tabpanel" aria-labelledby="pages-tab">
							
							<!-- Tab content header start -->
							<div class="tab-pane-header">
								Make Sales
							</div>
							<!-- Tab content header end -->

							<!-- Sidebar menu starts -->
							<div class="sidebarMenuScroll">
								<div class="sidebar-menu">
									<ul>
										<li>
											<a href="<?php echo e(route('pendingOrders')); ?>">Sales Channel</a>
										</li>
									
										<?php if(auth()->user()->role == "Dispatch Manager"): ?>
										<li>
											<a href="<?php echo e(route('OnlineAgency')); ?>">Order Display</a>
										</li>
										<?php else: ?>
										<li>
											<a href="<?php echo e(route('OnlineAgency')); ?>">Order Display</a>
										</li>
										<?php endif; ?>
										<?php if(auth()->user()->role != "Sales Person"): ?>
										<?php if(auth()->user()->role == "Call Center"): ?>
										<li>
											<a href="#" data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral">New Sale</a>
										</li>
										<?php endif; ?>
										<?php else: ?>
										
										<li>
											<a href="#" data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral">New Sale</a>
										</li>
									
										<li>
											<a href="<?php echo e(route('viewDraft')); ?>">Draft Orders</a>
										</li>
										<?php endif; ?>
										<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
										<li>
											<a href="<?php echo e(route('index.order')); ?>">View Invoices</a>
										</li>
										<?php endif; ?>
										<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Dispatch::class)): ?>
										<?php if(auth()->user()->role == "Dispatch Manager"): ?>
										<li>
											<a href="<?php echo e(route('index.dispatch')); ?>">Dispatch</a>
										</li>
										<?php endif; ?>
										<?php endif; ?>

										
									</ul>
								</div>
							</div>
							<!-- Sidebar menu ends -->
						</div>

						<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
						<!-- Authentication tab -->
						<div class="tab-pane fade" id="tab-authentication" role="tabpanel" aria-labelledby="authentication-tab">
							
							<!-- Tab content header start -->
							<div class="tab-pane-header">
								Authentication
							</div>
							<!-- Tab content header end -->
							
							<!-- Sidebar menu starts -->
							<div class="sidebarMenuScroll">
								<div class="sidebar-menu">
									<ul>
										<?php if(auth()->user()->role == "Administrator"): ?>
										<li>
											<a href="<?php echo e(route('allUSers')); ?>">Users</a>
										</li>
										<li>
											<a href="#" data-bs-toggle="modal" data-bs-target="#staticBackdropRegister">Add User</a>
										</li>
										<?php endif; ?>
										<li>
											<a href="<?php echo e(route('index.account')); ?>">Settings</a>
										</li>
										<?php if(auth()->user()->role == "Administrator" || auth()->user()->role == "Branch Officer" || auth()->user()->sales_person_category == "Delivery"): ?>
										<li>
											<a href="#" data-bs-toggle="modal" data-bs-target="#switchModal">Switch Outlet</a>
										</li>
										<?php endif; ?>
									</ul>
								</div>
							</div>
							<!-- Sidebar menu ends -->

							<?php if(auth()->user()->role == "Administrator"): ?>
							<!-- Sidebar actions starts -->
							<div class="sidebar-actions">
								<div class="support-tile blue">
									<a href="<?php echo e(route('inventory')); ?>" class="btn btn-light m-auto">Inventory</a>
								</div>
							</div>
							<!-- Sidebar actions ends -->
							<?php endif; ?>

						</div>
						<?php endif; ?>
						
						<!-- Settings tab -->
						<div class="tab-pane fade" id="tab-settings" role="tabpanel" aria-labelledby="settings-tab">
							
							<!-- Tab content header start -->
							<div class="tab-pane-header">
								Settings
							</div>
							<!-- Tab content header end -->

							<!-- Settings start -->
							<div class="sidebarMenuScroll">
								<div class="sidebar-settings">
									<div class="accordion" id="settingsAccordion">
										<div class="accordion-item">
											<h2 class="accordion-header" id="genInfo">
												<button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#genCollapse" aria-expanded="true" aria-controls="genCollapse">
													General Info
												</button>
											</h2>
											<div id="genCollapse" class="accordion-collapse collapse show" aria-labelledby="genInfo" data-bs-parent="#settingsAccordion">
											<form method="post" action="<?php echo e(route('updateuser', auth()->user()->id)); ?>">
												<?php echo csrf_field(); ?>
											<div class="accordion-body">
													<div class="field-wrapper">
														<input type="text" readonly name="username" value="<?php echo e(auth()->user()->name); ?>" />
														<div class="field-placeholder">Full Name</div>
													</div>

													<div class="field-wrapper">
														<input type="email" name="useremail" value="<?php echo e(auth()->user()->email); ?>" />
														<div class="field-placeholder">Email</div>
													</div>

													<div class="field-wrapper">
														<input type="text" name="userrole" readonly value="<?php echo e(auth()->user()->role); ?>" />
														<div class="field-placeholder">Role</div>
													</div>
													<div class="field-wrapper m-0">
														<button type="submit" class="btn btn-primary stripes-btn">Save</button>
													</div>
												</div>
											</div>
											</form>
										</div>
										<div class="accordion-item">
											<h2 class="accordion-header" id="chngPwd">
												<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#chngPwdCollapse" aria-expanded="false" aria-controls="chngPwdCollapse">
													Change Password
												</button>
											</h2>
										<form action="<?php echo e(route('changePassword', auth()->user()->id)); ?>" method="post">
                								<?php echo csrf_field(); ?>
											<div id="chngPwdCollapse" class="accordion-collapse collapse" aria-labelledby="chngPwd" data-bs-parent="#settingsAccordion">
												<div class="accordion-body">
													<div class="field-wrapper">
														<input type="text" name="old_password" required>
														<div class="field-placeholder">Current Password</div>
													</div>
													<div class="field-wrapper">
														<input type="password" name="password" required>
														<div class="field-placeholder">New Password</div>
													</div>
													<div class="field-wrapper">
														<input type="password" name="password_confirmation" required>
														<div class="field-placeholder">Confirm Password</div>
													</div>
													<div class="field-wrapper m-0">
														<button class="btn btn-primary stripes-btn">Save</button>
													</div>

												</div>
											</div>
										</form>
										</div>
										<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
										<div class="accordion-item">
											<h2 class="accordion-header" id="sidebarNotifications">
												<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#notiCollapse" aria-expanded="false" aria-controls="notiCollapse">
													Simple Settings
												</button>
											</h2>
											<div id="notiCollapse" class="accordion-collapse collapse" aria-labelledby="sidebarNotifications" data-bs-parent="#settingsAccordion">
												<div class="accordion-body">
													<div class="list-group m-0">
														<div class="noti-container">
															<div class="noti-block">
																<div>Clear Cache</div>
																<div class="form-switch">
																	<input class="form-check-input" type="checkbox" id="showAlertss" onChange="clearCache()">
																	<label class="form-check-label" for="showAlertss"></label>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<?php endif; ?>
									</div>
								</div>
							</div>
							<!-- Settings end -->

							<!-- Sidebar actions starts -->
							<div class="sidebar-actions">
								<div class="support-tile blue">
									<a href="<?php echo e(route('onlineOrders')); ?>" class="btn btn-light m-auto">Online Orders</a>
								</div>
							</div>
							<!-- Sidebar actions ends -->
						</div>

					</div>
					<!-- Tabs content end -->

				</div>
				<!-- Sidebar content end -->
				
			</nav>
			<!-- Sidebar wrapper end -->

			<!-- *************
				************ Main container start *************
			************* -->
			<div class="main-container">

				<!-- Page header starts -->
				<div class="page-header">
					
					<!-- Row start -->
					<div class="row gutters">
						<div class="col-xl-8 col-lg-8 col-md-8 col-sm-6 col-9">

							<!-- Search container start -->
							<div class="search-container">

								<!-- Toggle sidebar start -->
								<div class="toggle-sidebar" id="toggle-sidebar">
									<i class="icon-menu"></i>
								</div>
								<!-- Toggle sidebar end -->


								<!-- Search input group start -->
								<div class="ui fluid category search">
									<form action="<?php echo e(route('searchOrder')); ?>">
										<?php echo csrf_field(); ?>
									<!-- Field wrapper start -->
									<div class="field-wrapper">
										<div class="input-group">
											<input class="form-control" required placeholder="Search Receipt Number....." type="text" name="search">
											<span class="input-group-text">
											<button class="btn btn-default btn-sm"><i class="fa fa-search" aria-hidden="true"></i></button>
											</span>
										</div>
									</div>
									<!-- Field wrapper end -->
									</form>
								</div>
								<!-- Search input group end -->
								

							</div>
							<!-- Search container end -->

						</div>
						<div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-3">

							<!-- Header actions start -->
							<ul class="header-actions">
								<li class="dropdown">
									<a href="#" id="notifications" data-toggle="dropdown" aria-haspopup="true">
										<i class="icon-check-square"></i> 
									</a>
								</li>
								<li class="dropdown">
									<a href="#" id="userSettings" class="user-settings" data-toggle="dropdown" aria-haspopup="true">
										<span class="avatar">
											<img src="/img/user.svg" alt="User Avatar">
											<span class="status busy"></span>
										</span>
									</a>
									<div class="dropdown-menu dropdown-menu-end md" aria-labelledby="userSettings">
										<div class="header-profile-actions">
											<a href="<?php echo e(route('index.account')); ?>"><i class="icon-user1"></i>Profile</a>
											<a href="#"><i class="icon-settings1"></i>Settings</a>
											<a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                      		 onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
													<i class="icon-log-out1"></i> Logout
													</a>
											<form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
												<?php echo csrf_field(); ?>
											</form>
										</div>
									</div>
								</li>
							</ul>
							<!-- Header actions end -->

						</div>
					</div>
					<!-- Row end -->					
					<?php echo $__env->make('inc.errorfile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				</div>
				<!-- Page header ends -->
				<?php echo $__env->make('modal.target-report', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				<?php echo $__env->make('modal.agency-report', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				<?php echo $__env->make('modal.delivery-modal-pop', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				<?php echo $__env->make('modal.delivery-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				
				<!-- Content wrapper scroll start -->
				<div class="content-wrapper-scroll">
               
				<?php echo $__env->yieldContent('content'); ?>


                    <!-- App footer start -->
                    <?php echo $__env->make('inc.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					<?php echo $__env->make('modal.switch-branch', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					
					<!-- App footer end -->

				</div>
				<!-- Content wrapper scroll end -->

			</div>
			<!-- *************
				************ Main container end *************
			************* -->

		</div>
		<!-- Page wrapper end -->

		<?php echo $__env->make('inc.new-user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<style>
			::placeholder{
				font-size:10px;
			}
		</style>

		<!-- <script>

			function clearCache(){
				window.location.assign("/clear-cache");
			}
			function clearConfig(){
				window.location.assign("/clear-config");
			}
			function clearView(){
				window.location.assign("/clear-view");
			}

		</script> -->


		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
		<script src="<?php echo e(asset('js/bootstrap.bundle.min.js')); ?>"></script>
		<script src="<?php echo e(asset('js/modernizr.js')); ?>"></script>
		<script src="<?php echo e(asset('js/moment.js')); ?>"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->


		<!-- Sweet Alerts js -->
		<script src="<?php echo e(asset('vendor/libs/sweetalert2/sweetalert2.min.js')); ?>"></script>
		
		<!-- Megamenu JS -->
		<script src="<?php echo e(asset('vendor/megamenu/js/megamenu.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/megamenu/js/custom.js')); ?>"></script>
		<!-- Slimscroll JS -->
		<script src="<?php echo e(asset('vendor/slimscroll/slimscroll.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/slimscroll/custom-scrollbar.js')); ?>"></script>
		<!-- Search Filter JS -->
		<script src="<?php echo e(asset('vendor/search-filter/search-filter.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/search-filter/custom-search-filter.js')); ?>"></script>
		<!-- Apex Charts -->
		<script src="<?php echo e(asset('vendor/apex/apexcharts.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/salesGraph.js')); ?>"></script>
		<!-- Circleful Charts -->
		<script src="<?php echo e(asset('vendor/circliful/circliful.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/circliful/circliful.custom.js')); ?>"></script>
		<!-- Bootstrap Select JS -->
		<script src="<?php echo e(asset('vendor/bs-select/bs-select.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/bs-select/bs-select-custom.js')); ?>"></script>
		<!-- Data Tables -->
		<script src="<?php echo e(asset('vendor/datatables/dataTables.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/dataTables.bootstrap.min.js')); ?>"></script>
		<!-- Custom Data tables -->
		<script src="<?php echo e(asset('vendor/datatables/custom/custom-datatables.js')); ?>"></script>
		<!-- Download / CSV / Copy / Print -->
		<script src="<?php echo e(asset('vendor/datatables/buttons.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/jszip.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/pdfmake.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/vfs_fonts.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/html5.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/buttons.print.min.js')); ?>"></script>
		<!-- Dropzone JS -->
		<script src="<?php echo e(asset('vendor/dropzone/dropzone.min.js')); ?>"></script>
		<!-- Date Range JS -->
		<script src="<?php echo e(asset('vendor/daterange/daterange.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/daterange/custom-daterange.js')); ?>"></script>
		<!-- Main Js Required -->
		<script src="<?php echo e(asset('js/main.js')); ?>"></script>

	</body>

</html><?php /**PATH /home/morttsons/public_html/morttsonsposfiles/resources/views/layouts/app.blade.php ENDPATH**/ ?>