<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Title -->
		<title>Welcome ~ CeqaFoods and Beverages Limited</title>

		<!-- Date Range CSS -->
		<link rel="stylesheet" href="<?php echo e(asset('vendor/daterange/daterange.css')); ?>">

		
		<!-- Uploader CSS -->
		<link rel="stylesheet" href="<?php echo e(asset('vendor/dropzone/dropzone.min.css')); ?>" />

		<!-- *************
			************ Common Css Files *************
		************ -->
		<!-- Bootstrap css -->
		<link rel="stylesheet" href="<?php echo e(asset('css/bootstrap.min.css')); ?>">
		
		<!-- Icomoon Font Icons css -->
		<link rel="stylesheet" href="<?php echo e(asset('fonts/style.css')); ?>">

		<!-- Main css -->
		<link rel="stylesheet" href="<?php echo e(asset('css/main.css')); ?>">

		<!-- fontAwesome -->
		<link href="<?php echo e(asset('fontawesome/css/all.css')); ?>" rel="stylesheet">
        <!-- <meta http-equiv="refresh" content="5"> -->


		<!-- Data Tables -->
		<link rel="stylesheet" href="<?php echo e(asset('vendor/datatables/dataTables.bs4.css')); ?>" />
		<link rel="stylesheet" href="<?php echo e(asset('vendor/datatables/dataTables.bs4-custom.css')); ?>" />
		<link href="<?php echo e(asset('vendor/datatables/buttons.bs.css')); ?>" rel="stylesheet" />

		
		<script src="<?php echo e(asset('js/ajax.min.js')); ?>"></script>

		<!-- *************
			************ Vendor Css Files *************
		************ -->
		<!-- Bootstrap Select CSS -->
		<link rel="stylesheet" href="<?php echo e(asset('vendor/bs-select/bs-select.css')); ?>" />
		<!-- Mega Menu -->
		<link rel="stylesheet" href="<?php echo e(asset('vendor/megamenu/css/megamenu.css')); ?>">
		<!-- Search Filter JS -->
		<link rel="stylesheet" href="<?php echo e(asset('vendor/search-filter/search-filter.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('vendor/search-filter/custom-search-filter.css')); ?>">
        		<!-- Sweet Alert-->
		<link href="<?php echo e(asset('vendor/libs/sweetalert2/sweetalert2.min.css')); ?> " rel="stylesheet" type="text/css" />

	</head>
	<body>

    <style>
        body{
            background-color: #cbd4fe;
        }

    </style>



<!-- Row start -->
<div tyle="width:100%" id="main">

 <!-- Breadcrumb container start -->
 <div class="breadcrumb-container" style="background-color:#ffffff;">
 <img src="/img/<?php echo e($app->app_logo); ?>" alt="Logo" style="max-height:45px">
<span>
<a href="<?php echo e(route('dispatch-display')); ?>" class="btn btn-outline-primary"><i class="icon-shopping-cart1"></i> Delivery Orders (<?php echo e($deliveryOrders); ?>)</a>
<a href="<?php echo e(route('OnlineAgency')); ?>" class="btn btn-outline-primary"><i class="icon-shopping-cart1"></i> Agency Orders (<?php echo e($agencycount); ?>)</a>
<a href="/" class="btn btn-outline-primary"><i class="icon-arrow_back"></i> Back</a>
</span>

<span style="float:right; padding:10px" class="text-primary">
    ECOMMERCE ORDERS | <?php echo e(auth()->user()->branch); ?> [<?php echo e(auth()->user()->name); ?>]
</span>

</div>
<!-- Breadcrumb container end -->

        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <!-- Card start -->
            <div>
                <div class="card-body">

                <!-- Row start -->
                <div class="row gutters">
                    <?php $__currentLoopData = $pending_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12">
                        <figure class="user-card"  style="box-shadow: 2px 2px 2px 1px rgba(0, 0, 0, 0.2);">
                            <?php echo e(Str::of($item->customer_fname . " " . $item->customer_lname)->upper()); ?><br>
                            <?php echo e($item->delivery_location); ?><br>
                            <?php echo e($item->customer_phone); ?><br>
                            <br>
                            <figcaption>
                            <div style="width:100%; background-color:#cbd4fe; padding:12px">
                            <span>#<?php echo e($item->invoice_number); ?></span>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped m-0">
                                <thead class="thead-light">
                                    <tr>
                                    <th scope="col" style="font-size:12px; border-top:1px solid #000; border-bottom:1px solid #000 ; padding:5px">Item</th>
                                    <th scope="col" style="font-size:12px; border-top:1px solid #000; border-bottom:1px solid #000 ; padding:5px">Qty</th>
                                    <th scope="col" style="font-size:12px; border-top:1px solid #000; border-bottom:1px solid #000 ; padding:5px">Total Price</th>
                                    </tr>
                                </thead>
                                    <tbody>
                                    <?php $__currentLoopData = json_decode($item->orders); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orders): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                        <td><?php echo $orders->Name; ?></td>
                                        <td><?php echo e($orders->quantity); ?> PCS</td>
                                        <td><?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?><?php echo number_format((float)$orders->quantity*(float)$orders->price, 2); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                </div>
                            </figcaption>
                            <div style="margin-top:10px">
                            <a href="#" id="<?php echo e($item ->invoice_number); ?>" onclick="AcceptOrder(this.id)" class="btn btn-outline-primary btn-sm"><i class="icon-check2"></i> Accept Order</a>
                            <a href="#" class="btn btn-outline-info btn-sm"><i class="icon-time-slot"></i>
                            <?=  \Carbon\Carbon::parse($item->created_at)->diffForHumans() ?>
                            </a><br><br>
                                <a href="#" id="<?php echo e($item ->invoice_number); ?>" onclick="invoiceNumber(this.id)" class="btn btn-primary btn-sm"> <i class="icon-cancel"></i>Cancel</a>
                            </div>


                            <?php echo e($item->comment); ?>

                        </figure>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
        </div>
    </div>
    <!-- Row end -->




<!-- Sweet Alerts js -->
<script src="<?php echo e(asset('vendor/libs/sweetalert2/sweetalert2.min.js')); ?>"></script>
    <script>
        function invoiceNumber(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "Do you want to cancel this order",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Complete Order!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "/ceqa-dashboard-online-orders/preview-order/cancel/" + id
                    Swal.fire(
                    'Order Cancelled Successfully',
                    'The Order will clear from the Screen',
                    'success'
                    )
                }
                })
        }




        function AcceptOrder(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "Do you want to cancel this order",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Complete Order!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "/ceqa-dashboard-online-orders/preview-order/accept-order/" + id
                    Swal.fire(
                    'Order Cancelled Successfully',
                    'The Order will clear from the Screen',
                    'success'
                    )
                }
                })
        }
    </script>

<?php echo $__env->make('inc.check-internet', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>




    		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
		<script src="<?php echo e(asset('js/bootstrap.bundle.min.js')); ?>"></script>
		<script src="<?php echo e(asset('js/modernizr.js')); ?>"></script>
		<script src="<?php echo e(asset('js/moment.js')); ?>"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->
		
		<!-- Main Js Required -->
		<script src="<?php echo e(asset('js/main.js')); ?>"></script>

	</body>

</html><?php /**PATH /home/morttsons/public_html/morttsonsposfiles/resources/views/online-template/display-online-orders.blade.php ENDPATH**/ ?>