

<?php $__env->startSection('content'); ?>


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="container">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                <div class="card-title">Search results for Order: #<?php echo e(request()->search); ?></div>
                    <?php if($customer_id == null): ?>
                    <a href="<?php echo e(route('showPrintDesign', request()->search)); ?>" class="btn btn-outline-primary btn sm">
                    <i class="icon-print" aria-hidden="true"></i>
                    Print Receipt</a>
                    <?php else: ?>
                    <a href="/ceqa-dashboard/print-invoice/delivery/<?= request()->search ?>/<?= $customer_id ?>" class="btn btn-outline-primary btn sm">
                    <i class="icon-print" aria-hidden="true"></i>
                    Print Receipt</a>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <!-- Row start -->
                    <div class="row gutters">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                                <th>Product ID.</th>
                                <th>Ordered Date</th>
                                <th>Product</th>
                                <th>Quantity</th>												
                                <th> Unit Price</th>
                                <th>Total Price</th>
                                <?php if(auth()->user()->sales_person_category == "Delivery"): ?><?php else: ?>
                                <th>Action</th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>#<?php echo e($list->invoice_number); ?></td>
                                <td><?php echo e($list->created_at); ?></td>
                                <td>
                                <?php echo e($list->invoice_product_name); ?>

                                </td>
                                <td>
                                <?php echo e($list->invoice_quantity); ?>

                                </td>
                                <td>GH₵<?php echo e($list->invoice_unit_price); ?></td>
                                <td>GH₵<?php echo e($list->invoice_total_price); ?></td>
                                <?php if(auth()->user()->sales_person_category == "Delivery"): ?><?php else: ?>
                                <td>
                                    <button onclick="getOrderId(this.id)" id="<?php echo e($list->id); ?>" class="btn btn-default text-danger" data-bs-toggle="modal" data-bs-target="#exampleModalchangestatus">
                                    <i class="fa fa-edit"></i>
                                    </button>
                                </td>
                                <?php endif; ?>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>


        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->




<!-- Modal start -->
<div class="modal fade" id="exampleModalchangestatus" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">Change Status</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
               <form id="change">
               <input type="text" name="invoice_id" id="id" readonly hidden>
                 <!-- Field wrapper start -->
                <?php echo csrf_field(); ?>
                <div class="field-wrapper">
                    <div class="input-group">
                        <select name="status" class="select-single js-states">
                            <option value="General">General</option>
                            <?php if(auth()->user()->role == "Administrator"): ?>
                            <option value="On The House">On The House</option>
                            <option value="Rejected">Rejected</option>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="field-placeholder">Status</div>
                </div>
                <!-- Field wrapper end -->

                <div class="field-wrapper">
                    <div class="input-group">
                        <textarea name="comment" id="" cols="30" rows="10"></textarea>
                    </div>
                    <div class="field-placeholder">Comment</div>
                </div>
                <!-- Field wrapper end -->

                <button class="btn btn-primary btn-sm">Save Changes</button>
               </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->



<script>
    function getOrderId(id) {
        document.getElementById('id').value = id
    }


    $("#change").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "<?php echo e(route('changeInvoiceStatus')); ?>",
                dataType: "json",
                data: $('#change').serialize(),
                success: function(data){
                    if (data == 0) {
                        window.location.href = "/ceqa-dashboard/rejected-bom";
                    }else{
                    $("#highlightRowColumn").load(" #highlightRowColumn");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Item Status Changed Successfully'
                    })
                }
                    
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });
</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/morttsons/public_html/morttsonsposfiles/resources/views/inc/search-results.blade.php ENDPATH**/ ?>