

<?php $__env->startSection('content'); ?>

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
            <div class="card-header-lg">
            <div class="card-title">
            <h5> Products & Services</h5>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
            <p><a href="<?php echo e(route('barCodeSetting')); ?>">Barcode Settings</a> | <a href="<?php echo e(route('productSettings')); ?>">Advance Settings</a></p> 
            <?php endif; ?>
            </div>
                <?php if(auth()->user()->role == "Administrator"): ?>
                <button class="btn btn-outline-primary rounded-pill" data-bs-toggle="modal" data-bs-target="#addNewDocument">Create Product</button>
                <?php endif; ?>
                <div class="modal fade" id="addNewDocument" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="addNewDocumentLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="addNewDocumentLabel">Add New Product</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true"></span>
                                </button>
                            </div>
                            <div class="modal-body">

                            <form class="row gutters" method="post" action="<?php echo e(route('loadProduct')); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                
                                    <!-- Field wrapper start -->
                                    <div class="field-wrapper">
                                        <div class="input-group">														
                                            <input type="file" name="file" class="form-control" id="inputGroupFile01">
                                            <button class="btn btn-outline-primary" type="submit" required>Upload</button>
                                        </div>
                                        <div class="field-placeholder">Upload Products</div>
                                        <small class="text-primary"> <a href="/uploads/products.csv">Download Sample csv</a></small>
                                    </div>
                                    <!-- Field wrapper end -->
                                    

                                </div>
                            </form>
                            
                            <hr>
                            <div class="card-title">
                                Enter Item
                            </div>
                                <form class="row gutters" action="<?php echo e(route('addProduct')); ?>" method="post" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>

                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="file" class="form-control" name="image">
                                            <div class="field-placeholder">Product Image</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" class="form-control" name="p_name">
                                            <div class="field-placeholder">Product Name</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <select  name="p_category" class="select-single js-states" title="Select Product Category" data-live-search="true">
                                            <option selected disable>Select Category</option>
                                            <?php $__currentLoopData = $item_category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option><?php echo e($category->category_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div class="field-placeholder">Category</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <select  name="p_brand" class="select-single js-states" title="Select Product Category" data-live-search="true">
                                            <option selected disable>Select Brand</option>
                                            <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option><?php echo e($brand->brand_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div class="field-placeholder">Brand</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="p_unit_price">
                                                <span class="input-group-text">
                                                <?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?>

                                                </span>
                                            </div>
                                            <div class="field-placeholder">Product Price</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <div class="input-group">
                                                <input type="text" class="form-control" onKeydown="return event.key != 'Enter';" name="barcode" placeholder="Select Field and Scan">
                                                <span class="input-group-text">
                                                 <i class="icon-code2"></i>
                                                </span>
                                            </div>
                                            <div class="field-placeholder">Barcode</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper m-0">
                                            <textarea class="form-control" name="p_description" rows="3"></textarea>
                                            <div class="field-placeholder">Description</div>
                                        </div>
                                        <!-- Field wrapper end -->


                                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <span class="form-check form-check-inline">
                                                <input class="form-check-input" type="checkbox" id="checkSms3" value="1" name="store_category">
                                                <label class="form-check-label" for="checkSms3">Bar Menu Item</label>
                                            </span>

                                            <span class="form-check form-check-inline">
                                                <input class="form-check-input" type="checkbox" id="checkSms2" value="1" name="store_active">
                                                <label class="form-check-label" for="checkSms2">Active Online</label>
                                            </span>

                                        </div>


                                        </div>


                                        <div>
                                        <input type="text" class="form-control" name="product_code" hidden
                                                value="<?php echo "PD-".substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 6) . date("hi"); ?>"
                                                >
                                        </div>
                                    </div>

                                   
                                 <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-outline-primary"> Continue</button>
                                    </div>
                                </form>
                                    </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>  
            
                <div class="card-body">
                <div style="margin-bottom:10px">
                <?php if(Route::currentRouteName() == "indexBarItems"): ?>
                    <a href="<?php echo e(route('productList')); ?>" class="btn btn-outline-primary btn-sm rounded-pill">Product & Service</a> 
                <?php else: ?>
                    <a href="<?php echo e(route('indexBarItems')); ?>" class="btn btn-outline-primary btn-sm rounded-pill"><i classs="icon-local_drink"></i> Bar Menu List</a> 
                <?php endif; ?>
                </div>
                <form action="<?php echo e(route('ProductAction')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="table-responsive">
                    <table id="highlightRowColumn" class="table custom-table">
                            <thead>
                                <tr>
                                <th><input type="checkbox" id="select-all"></th>
                                  <th>Products</th>		
                                  <th>Added Date</th>	
                                  <th>Product Category</th>
                                  <th>E-shop</th>												  
                                  <th>Unit Price</th>
                                  <?php if(auth()->user()->role == "Administrator"): ?>
                                  <th>Action</th>
                                  <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><input type="checkbox" name="product[]" value="<?php echo e($item->FinalProductionID); ?>"></td>
                                  <td>
                                  <div class="media-box">
                                  <div class="me-2">
                                        <img src="/uploads/<?php echo e(empty($item->product_image) ? 'no-product.png' : $item->product_image); ?>" class="img-36" alt="Product">
                                  </div>
                                        <div class="media-box-body">
                                            <a href="#" class="text-truncate"><?php echo @strtoupper($item->Name); ?></a>
                                            <p>ID: #<?php echo e(@strtoupper($item->product_code)); ?></p>
                                        </div>
                                    </div>
                                  </td>
                                  <td><?php echo e($item->created_at); ?></td>	
                                  <td><?php echo e(@strtoupper($item->production_category)); ?></td>		
                                  <td><?php echo $item->website_display == 1 ? '<span class="badge rounded-pill bg-info">'."Enabled". '</span>' : '<span class="badge rounded-pill bg-primary">' . "Disabled" . '</span>'; ?></td>												  
                                  <td> <?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?><?php echo number_format($item->UnitPrice, 2); ?></td>
                                  <td>
                                  <?php if(auth()->user()->role == "Administrator"): ?>
                                    <form action="/ceqa-dashboard/product-add-composing/<?=$item->FinalProductionID?>" method="get">
                                        <input type="text" name="item_name" hidden id="" value="<?= $item->Name ?>">
                                        <button class="btn btn-outline-primary btn-sm rounded-pill waves-effect waves-light"><i class="icon-eye1"></i></button>
                                    </form>
                                  <?php endif; ?>
                                  </td>
                            
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                               
                            </tbody>
                    </table>
                    </div>

                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
												
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">														
                                <button class="btn btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Action</button>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li><a class="dropdown-item" href="<?php echo e(route('export')); ?>">Export</a></li>
                                    <?php if(auth()->user()->role == "Administrator"): ?>
                                    <li> <input type="submit" class="dropdown-item" name="action" value="Enable Online"></li>
                                    <li><input type="submit" class="dropdown-item" name="action" value="Disable Online"></a></li>
                                    <li><input type="submit" class="dropdown-item" name="action" value="Bar Item"></a></li>
                                    <li><input type="submit" class="dropdown-item" name="action" value="Active"></a></li>
                                    <li><input type="submit" class="dropdown-item" name="action" value="Inactive"></a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item" href="#" onclick="document.getElementById('form-id').submit();">Delete Selected</a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <!-- Field wrapper end -->
                    
                    </div>
                    </form>
                </div>
                
                </div>
                
        </div>
        
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


<script type="text/javascript">  
    document.getElementById('select-all').onclick = function(){
        var ele=document.getElementsByName('product[]');  
        for (var checkbox of ele) {
                checkbox.checked = this.checked;
            }
    
    }              
</script> 



<!--  Small modal example -->
<div class="modal fade bs-example-modal-sm" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="mySmallModalLabel"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h5>Composition</h5>
                    <hr>
                    <div id="demoB"></div>

                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->



<!--     
<script>
    function getComposition(data) {
        const id = data.split(" - ")
        console.log(data.split(" - "))
        document.getElementById('mySmallModalLabel').innerHTML = id[1]

        const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                data = JSON.parse(this.responseText);
                var list = "<ul>";
                    for (let i of data) {
                    list += `<li>${i}</li>`;
                    }
                    list += "</ul>";

                document.getElementById("demoB").innerHTML = list;

            }
            xhttp.open("GET", "/ceqa-dashboard/compostions-product/"+ id[0]);
            xhttp.send();

    }
</script> -->



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/morttsons/public_html/morttsonsposfiles/resources/views/product/product-list.blade.php ENDPATH**/ ?>