<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Agency Anaylsis">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>REVENUE SUMMARY - <?php echo e(request()->date == null ? $dayClose->day_close : request()->date); ?></title>

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/daterange/daterange.css')); ?>">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/dropzone/dropzone.min.css')); ?>" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="<?php echo e(asset('css/bootstrap.min.css')); ?>">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="<?php echo e(asset('fonts/style.css')); ?>">

        <!-- Main css -->
        <link rel="stylesheet" href="<?php echo e(asset('css/main.css')); ?>">

        <!-- fontAwesome -->
        <link href="<?php echo e(asset('fontawesome/css/all.css')); ?>" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/datatables/dataTables.bs4.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(asset('vendor/datatables/dataTables.bs4-custom.css')); ?>" />
        <link href="<?php echo e(asset('vendor/datatables/buttons.bs.css')); ?>" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="<?php echo e(asset('libs/sweetalert2/sweetalert2.min.css')); ?> " rel="stylesheet" type="text/css" />


        <script src="<?php echo e(asset('js/ajax.min.js')); ?>"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/bs-select/bs-select.css')); ?>" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/megamenu/css/megamenu.css')); ?>">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/search-filter/search-filter.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('vendor/search-filter/custom-search-filter.css')); ?>">


		
	</head>

<body onload="window.print();">






<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <a href="#" class="logo">
                    <img src="/img/ceqalogo.png" alt="logo" style="max-width:120px;">
                </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: <?php echo e(auth()->user()->name); ?> <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="invoice-details">
                <address class="m-0">
                    <strong>CEQA FOODS & BEVERAGES LTD</strong>,<br>
                    REVENUE SUMMARY FOR AGENCY <strong>[<?=@strtoupper(request()->type == null ? "All AGENCIES" : request()->type );?>]</strong><br>
                    REPORT FOR: <?=@strtoupper( auth()->user()->branch);?>
                </address>

                <div class="invoice-num">
                    <div>Report Date</div>
                    <div> <?php echo e(request()->date); ?></div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->

    <div class="table-responsive">
	<table class="table table-bordered table-striped m-0">
        <thead>
        <tr>
            <th>Name</th>
            <th>Quantity</th>
            <th>Total</th>
        </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $itemAgent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e(@strtoupper($report->name)); ?></td>
                <td><?php echo e($report->quantity); ?></td>
                <td><?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?><?php echo number_format($report->total, 2); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <tr>
                    <td><strong>GRAND TOTAL</strong></td>
                    <td><strong><?php echo e($itemAgent->sum('quantity')); ?></strong></td>
                    <td><strong><?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?><?php echo number_format($itemAgent->sum('total'), 2); ?></strong></td>
                </tr>
        </tbody>
	</table>
</div>
</div>
</div>
</div>



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
		<script src="<?php echo e(asset('js/bootstrap.bundle.min.js')); ?>"></script>
		<script src="<?php echo e(asset('js/modernizr.js')); ?>"></script>
		<script src="<?php echo e(asset('js/moment.js')); ?>"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="<?php echo e(asset('libs/sweetalert2/sweetalert2.min.js')); ?>"></script>
		
		<!-- Megamenu JS -->
		<script src="<?php echo e(asset('vendor/megamenu/js/megamenu.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/megamenu/js/custom.js')); ?>"></script>

		<!-- Slimscroll JS -->
		<script src="<?php echo e(asset('vendor/slimscroll/slimscroll.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/slimscroll/custom-scrollbar.js')); ?>"></script>

		<!-- Search Filter JS -->
		<script src="<?php echo e(asset('vendor/search-filter/search-filter.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/search-filter/custom-search-filter.js')); ?>"></script>

		<!-- Apex Charts -->
		<script src="<?php echo e(asset('vendor/apex/apexcharts.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/salesGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/ordersGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/earningsGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/visitorsGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/customersGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/sparkline.js')); ?>"></script>

		<!-- Circleful Charts -->
		<script src="<?php echo e(asset('vendor/circliful/circliful.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/circliful/circliful.custom.js')); ?>"></script>


		<!-- Bootstrap Select JS -->
		<script src="<?php echo e(asset('vendor/bs-select/bs-select.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/bs-select/bs-select-custom.js')); ?>"></script>


		<!-- Data Tables -->
		<script src="<?php echo e(asset('vendor/datatables/dataTables.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/dataTables.bootstrap.min.js')); ?>"></script>
		
		<!-- Custom Data tables -->
		<script src="<?php echo e(asset('vendor/datatables/custom/custom-datatables.js')); ?>"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="<?php echo e(asset('vendor/datatables/buttons.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/jszip.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/pdfmake.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/vfs_fonts.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/html5.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/buttons.print.min.js')); ?>"></script>

		<!-- Dropzone JS -->
		<script src="<?php echo e(asset('vendor/dropzone/dropzone.min.js')); ?>"></script>

		<!-- Date Range JS -->
		<script src="<?php echo e(asset('vendor/daterange/daterange.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/daterange/custom-daterange.js')); ?>"></script>

		<!-- Main Js Required -->
		<script src="<?php echo e(asset('js/main.js')); ?>"></script>

	</body>

</html>
<?php /**PATH /home/morttsons/public_html/morttsonsposfiles/resources/views/print-agency-analysis.blade.php ENDPATH**/ ?>