

<?php $__env->startSection('content'); ?>

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<div class="content-wrapper">
    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Cashier</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <?php echo e(empty(request('date')) ? "Today's Transactions" : "Transactions from ". request('date')); ?>

                        </li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
             <!-- Top Actions - DateRange and Buttons -->
            <form action="<?php echo e(route('CashierReport')); ?>" method="get">
                <div class="d-flex justify-content-end">
                    <!-- Field wrapper start -->
                    <div class="field-wrapper m-0">
                        <div class="input-group">
                        <input type="text" class="form-control custom-daterange2" name="date">
                            <span class="input-group-text">
                            <i class="icon-calendar1"></i>
                            </span>
                            <button class="btn btn-info"><i class="icon-download1"></i> Report</button>
                        </div>
                    </div>
                    <!-- Field wrapper end -->
                </div>
            </form>
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


    
    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-5 col-lg-5 col-md-6 col-sm-12 col-12">
            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="card h-475">
                        <div class="card-body pt-0">

                            <div class="earnings-detail">
                                <div class="earnings-info">
                                    <p class="text-lighter" style="margin-top:12px">PHARMACISTS</p>
                                </div>
                            </div>

                            <!-- Row start -->
                            <div class="table-responsive">
                                <table id="hideSearchExample" class="table custom-table">
                                    <thead>
                                        <tr>
                                        <th>Name </th>
                                        <th>Branch</th>
                                        <th>Category</th>
                                        <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $sales_p; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $person): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                        <td><?php echo e(@strtoupper($person->name)); ?></td>
                                        <td><?php echo e($person->branch); ?></td>
                                        <td><?php echo e(@strtoupper($person->sales_person_category)); ?></td>
                                        <td>
                                        <?php if(empty(request('date'))): ?>
                                            <a href="<?php echo e(route('userSales', $person->id)); ?>" class="btn btn-outline-primary btn-sm"><i class="icon-eye1"></i></a>
                                        <?php else: ?>
                                            <form action="<?php echo e(route('dateReportByUser')); ?>" method="GET">
                                                <input type="text" readonly hidden name="date" value="<?php echo e(request()->date); ?>">
                                                <input type="text" readonly hidden name="user_id" value="<?php echo e($person->id); ?>">
                                                <button class="btn btn-outline-primary btn-sm"><i class="icon-eye1"></i></button>
                                            </form>
                                        <?php endif; ?>
                                        </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                            </table>
                            </div>

                            </div>
                            <!-- Row end -->
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="stats-tile3">
                        <div class="sale-icon3">
                            <img src="/img/svg/customer.svg" alt="Customers">
                        </div>
                        <div class="sale-details3">
                            <h3><?php echo e($all_customers->count()); ?></h3>
                            <p>New Customers</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="stats-tile3">
                        <div class="sale-icon3">
                            <img src="/img/svg/box.svg" alt="Customers">
                        </div>
                        <div class="sale-details3">
                            <h3><?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?><?php echo number_format($with_delivery - $discount_money, 2); ?></h3>
                            <p>Total Transaction [Sales - (Deliveries+Discounts)]</p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Row end -->
        </div>
        <div class="col-xl-7 col-lg-7 col-md-6 col-sm-12 col-12">								

            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    
                    <div class="card h-475">
                   
                        <div style="padding:15px">
                       <h6> TRANSACTION FOR <?php echo e(empty(request()->date) ? "TODAY" : request()->date); ?></h6><hr>
                        <div class="table-responsive">
                       
                        <table id="copy-print-csv" class="table custom-table">
                                    <thead>
                                        <tr>
                                            <th>Order Number</th>
                                            <th>Payment Type</th>
                                            <th>Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $completed_deliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <div class="media-box">
                                                    <div class="media-box-body text-truncate">
                                                        <a href="<?php echo e(route('orderTransaction', $delivery -> invoice_number)); ?>">#<?php echo e($delivery->invoice_number); ?></a>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><?php echo e($delivery->invoice_product_name); ?></td>
                                            <td><?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?><?php echo number_format($delivery->invoice_total_price, 2); ?></td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                       
                        </div>
                        </div>
                        <hr>
                        
                        <div class="stats-tile3">
                            <div class="sale-details3">
                                <h3>
                                    <?php if(empty(request('date'))): ?>
                                            <?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?> 
                                        <?php echo number_format(\DB::table('invoices')
                                            ->where('branch', auth()->user()->branch)
                                            ->where('drive_thru_status', 0)
                                            ->where('payment_status', 0)
                                            ->whereDate('created_at', $getDayClose->day_close)
                                            ->sum('invoice_total_price'), 2); ?>
                                    <?php else: ?>
                                        <?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?> 
                                        <?php echo number_format(\DB::table('invoices')
                                            ->where('branch', auth()->user()->branch)
                                            ->where('drive_thru_status', 0)
                                            ->where('payment_status', 0)
                                            ->WhereDate('created_at','>=', $from)
                                            ->WhereDate('created_at','<=', $to)
                                            ->sum('invoice_total_price'), 2); ?>
                                    <?php endif; ?>
                                </h3>
                                <p> Unaccepted Payment[Transactions]</p>
                            </div>
                            <div id="sparklineLine1" class="stats-graph3"></div>
                        </div>

                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="stats-tile3">
                        <div class="sale-icon3">
                            <img src="/img/svg/income.svg" alt="Sales">
                        </div>
                        <div class="sale-details3">
                            <h3><?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?><?php echo number_format($total_no_delivery, 2); ?></h3>
                            <p> Total Amount Accepted</p>
                        </div>
                        <div id="sparklineLine1" class="stats-graph3"></div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="stats-tile3">
                        <div class="sale-icon3">
                            <img src="/img/svg/commisions.svg" alt="Commisions">
                        </div>
                        <div class="sale-details3">
                            <h3><?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?><?php echo number_format($discount_money, 2); ?></h3>
                            <p>Total Discounts</p>
                        </div>
                        <div id="sparklineLine2" class="stats-graph3"></div>
                    </div>
                </div>
            </div>
            <!-- Row end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/morttacy/morttsonsposfiles/resources/views/cashier/cashier-report.blade.php ENDPATH**/ ?>