<?php $__env->startSection('content'); ?>

<?php if(auth()->user()->role == "Sales Person"): ?>
<script>
    $(document).ready(function(){
        $('#staticBackdropdeliverypopup').modal('show')
        }) 
</script>
<?php endif; ?>

<!-- Notify Sales Person Modal -->

<div class="modal fade" id="Notifysale" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">Notification</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            Dear <?php echo e(auth()->user()->name); ?>, <br>
                <p><h5>You are currently signed in to the <strong><?php echo e(auth()->user()->branch); ?>.</strong></h5></p>
                <p>Need assistance switching current Branch? Contact Administrator : <strong>0501429671</strong> or <strong>0574660657</strong></p>
            </div>
            <div class="modal-footer">
                <a href="<?php echo e(route('index.invoice')); ?>" class="btn btn-secondary"><i class="icon-shopping-cart1" aria-hidden="true"></i> Proceed to Sales</a>
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">
    
    <!-- Content wrapper start -->
    <div class="content-wrapper">


    <!-- Row start -->
<div class="row gutters">
    <div class="col-xl-8 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <h5 class="m-0">Welcome Back, <?php echo e(auth()->user()->name); ?>! </h5> 
        <small>Logged In at: <b class="text-primary"><?php echo e(\Carbon\Carbon::parse(auth()->user()->last_seen)->diffForHumans()); ?></b>,
        Active Date: <?php echo e($dayClose->day_close); ?>,
        Outlet: <?php echo e(auth()->user()->branch); ?>


        </small>

        <!-- Consultants banner start -->
        <div class="consulting-banner">
            <div class="consulting-banner-bg"></div>
            <div class="consulting-body">
                <div class="consulting-content">
                    <h4><?php echo e($app->app_name); ?> POS!</h4>
                    <p>To make the experience hassle-free, <br /> Kindly read our user guide or watch our video tutorials</p>
                </div>
            </div>
        </div>
        <!-- Consultants banner end -->
        
    </div>
    <div class="col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <!-- Consultants card start -->
        <div class="consulting-card">
            <div class="consulting-card-bg"></div>
            <div class="consulting-card-body">
                <h4>Get Started</h4>
                Hey there! <br>
                <p>We have assembled some links to get you started</p>
                <?php if(auth()->user()->role != "Administrator"): ?>
                    <?php if(auth()->user()->role == "Call Center"): ?>
                    <button class="btn btn-primary stripes-btn" data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral">New Sale</button>  
                    <?php else: ?>
                    <button class="btn btn-primary stripes-btn" data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral">New Sale</button>                                       
                    <?php endif; ?>
                <?php else: ?>
                <a href="<?php echo e(route('index.branch')); ?>" class="btn btn-primary stripes-btn">New Outlet</a>
                <?php endif; ?>
            </div>
        </div>
        <!-- Consultants card end -->
        
    </div>
</div>
<!-- Row end -->

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    <div class="sale-details">
                        <h2><?php echo e($countproduct); ?></h2>
                        <p><a href="<?php echo e(route('productList')); ?>">Products</a></p>
                    </div>
                    <div class="sale-graph">
                        <div id="sparklineLine1"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                    <i class="icon-shopping-cart1"></i>
                    </div>
                    <div class="sale-details">
                        <h2><?php echo e($orders); ?></h2>
                        <p><a href="<?php echo e(route('AllOrders')); ?>">Orders</a></p>
                    </div>
                    <div class="sale-graph">
                        <div id="sparklineLine2"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                <div class="stats-tile">
                        <div class="sale-icon">
                            <i class="icon-credit-card"></i>
                        </div>
                        <div class="sale-details">
                        <!-- <h2><tt>GH₵<?php echo e($total_sales == 0 ? "0.00" : $total_sales); ?></tt></h2> -->
                        <?php if(auth()->user()->role == "Administrator"): ?>
                        <h2><?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?><?php echo number_format($total_sales, 2); ?></h2>
                        <p><a href="<?php echo e(route('sales.today')); ?>">END OF DAY</a></p>
                        <?php elseif(auth()->user()->role == "Branch Officer"): ?>
                        <h3><a href="<?php echo e(route('sales.today')); ?>" class="text-primary"><strong>END OF DAY</strong></a></h3>
                        <?php else: ?>
                        <h3><a href="<?php echo e(route('salesTodayBySalesPerson')); ?>" class="text-primary"><strong>END OF DAY</strong></a></h3>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- Row end -->

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 cool-12">

                <div class="card">
                <?php if(auth()->user()->role == "Administrator"): ?>
                <div class="card-header">
                    <a href="<?php echo e(route('departmentSummaryAdmin')); ?>" class="btn btn-outline-primary btn-sm rounded-pill"> Category Report</a>
                    <a href="<?php echo e(route('ItemSummaryAdmin')); ?>" class="btn btn-outline-primary btn-sm rounded-pill"> Product Report</a>
                </div>
                <hr>
                <?php endif; ?>
                    <div class="card-body">
                        <!-- Row start -->
                        <div class="row gutters">											
                            <div class="col-xl-3 col-lg-3 col-md-4 col-sm-4 col-12">
                                <div class="reports-summary">
                                    
                                    
                                    
                                    <form action="<?php echo e(route('branchSales')); ?>" method="get">
                                          <?php echo csrf_field(); ?>
                                    <div class="field-wrapper">
                                    <select class="form-control <?php $__errorArgs = ['branch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required name="branch">
									<option disabled selected>Select Outlet</option>
									    <?php $__currentLoopData = $all_branch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($branch); ?>"><?php echo e($branch); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                        <div class="field-placeholder">Report Type</div>
									</div>
                                        <button class="btn btn-primary stripes-btn">Generate Report</button>
                                    </form>
                                </div>
                            </div>
                            <div class="col-xl-9 col-lg-9 col-md-8 col-sm-8 col-12">
                                <div class="row gutters">
                                    <div class="col-12">
                                        <div class="graph-day-selection mt-2" role="group">
                                            <button type="button" class="btn active">Today</button>
                                            <button type="button" class="btn">Yesterday</button>
                                            <button type="button" class="btn">7 days</button>
                                            <button type="button" class="btn">15 days</button>
                                            <button type="button" class="btn">30 days</button>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div id="salesGraph" class="chart-height-xl"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Row end -->
                    </div>
                </div>

            </div>
        </div>
        <!-- Row end -->
        <?php endif; ?>

        <!-- Row start -->
        <div class="row gutters">

                <div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="stats-tile2">
                        <div class="sale-icon">
                            <i class="icon-question_answer"></i>
                        </div>
                        <div class="sale-details">
                            <p>Get Started FAQ</p>
                        </div>
                    </div>
                    <div class="stats-tile2">
                        <div class="sale-icon">
                            <i class="icon-local_library"></i>
                        </div>
                        <div class="sale-details">
                            <p>Knowledge Articles</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="stats-tile2">
                        <div class="sale-icon">
                            <i class="icon-video"></i>
                        </div>
                        <div class="sale-details">
                            <p>Video Tutorial</p>
                        </div>
                    </div>
                    <div class="stats-tile2">
                        <div class="sale-icon">
                            <i class="icon-headphones"></i>
                        </div>
                        <div class="sale-details">
                            <p>Customer Support</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-8 col-lg-6 col-md-12 col-sm-12 col-12">

                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">Active Users</div>
                        </div>
                        <div class="card-body">
                        <?php echo $__env->make('inc.online-status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>

                </div>
                <!-- Row end -->
        </div>
    </div>
    <!-- Content wrapper end -->

    
<script>
    function getComposition(data) {
        
        const id = data.split(" - ")
        document.getElementById('mySmallModalLabel').innerHTML = id[1]

        const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                data = JSON.parse(this.responseText);
                var list = "<ul>";
                    for (let i of data) {
                    list += `<li>${i.product_name} = ${i.unit_measure}, Total Used: ${i.unit_measure*id[2]}</li>`;
                    }
                    list += "</ul>";

                document.getElementById("demoB").innerHTML = list;

            }
            xhttp.open("GET", "/ceqa-dashboard/compostions-product/"+ id[0]);
            xhttp.send();
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/morttacy/morttsonsposfiles/resources/views/home.blade.php ENDPATH**/ ?>