<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title><?php echo e($app->app_name); ?> - Product List</title>
        <link rel="icon" type="image/x-icon" href="/img/<?php echo e($app->app_logo); ?>">

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/daterange/daterange.css')); ?>">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/dropzone/dropzone.min.css')); ?>" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="<?php echo e(asset('css/bootstrap.min.css')); ?>">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="<?php echo e(asset('fonts/style.css')); ?>">

        <!-- Main css -->
        <link rel="stylesheet" href="<?php echo e(asset('css/main.css')); ?>">

        <!-- fontAwesome -->
        <link href="<?php echo e(asset('fontawesome/css/all.css')); ?>" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/datatables/dataTables.bs4.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(asset('vendor/datatables/dataTables.bs4-custom.css')); ?>" />
        <link href="<?php echo e(asset('vendor/datatables/buttons.bs.css')); ?>" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="<?php echo e(asset('libs/sweetalert2/sweetalert2.min.css')); ?> " rel="stylesheet" type="text/css" />


        <script src="<?php echo e(asset('js/ajax.min.js')); ?>"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/bs-select/bs-select.css')); ?>" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/megamenu/css/megamenu.css')); ?>">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="<?php echo e(asset('vendor/search-filter/search-filter.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('vendor/search-filter/custom-search-filter.css')); ?>">
	</head>

<body>

<div class="card-body">
    

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <!-- Breadcrumb container start -->
            <div class="breadcrumb-container">

            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#l">Home</a></li>
                        <li class="breadcrumb-item"><a href="/">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Export Menu Items</li>
                        </ol>
                    </nav>
                </div>
                <?php if(auth()->user()->role == "Sales Person" || auth()->user()->role == "Call Center"): ?>
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                    <!-- Top Actions - DateRange and Buttons -->
                    <div class="d-flex justify-content-end">
                        <a href="#" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral"><i class="icon-shopping-cart1"></i> New Sale</a>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <!-- Row end -->

            </div>
        </div>
    </div>
    <!-- Row end -->

    <div class="table-responsive">
    <table id="copy-print-csv" class="table custom-table">
        <thead>
            <tr>
            <th>Products</th>	
            <th>Product Code</th>		
            <th>Product Category</th>											  
            <th>Unit Price</th>
            </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $items_product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>
                    <div class="media-box">
                        <div class="media-box-body">
                            <a href="#" class="text-truncate"><?php echo @strtoupper($item->Name); ?></a>
                        </div>
                    </div>
                </td>
                <td><?php echo e(@strtoupper($item->product_code)); ?></td>	
                <td><?php echo e(@strtoupper($item->production_category)); ?></td>													  
                <td> <?php echo e(empty($app->currency) ? "GHS" : $app->currency); ?><?php echo number_format($item->UnitPrice, 2); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    </div>

</div>




		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
		<script src="<?php echo e(asset('js/bootstrap.bundle.min.js')); ?>"></script>
		<script src="<?php echo e(asset('js/modernizr.js')); ?>"></script>
		<script src="<?php echo e(asset('js/moment.js')); ?>"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="<?php echo e(asset('libs/sweetalert2/sweetalert2.min.js')); ?>"></script>
		
		<!-- Megamenu JS -->
		<script src="<?php echo e(asset('vendor/megamenu/js/megamenu.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/megamenu/js/custom.js')); ?>"></script>

		<!-- Slimscroll JS -->
		<script src="<?php echo e(asset('vendor/slimscroll/slimscroll.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/slimscroll/custom-scrollbar.js')); ?>"></script>

		<!-- Search Filter JS -->
		<script src="<?php echo e(asset('vendor/search-filter/search-filter.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/search-filter/custom-search-filter.js')); ?>"></script>

		<!-- Apex Charts -->
		<script src="<?php echo e(asset('vendor/apex/apexcharts.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/salesGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/ordersGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/earningsGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/visitorsGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/customersGraph.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/apex/custom/home/sparkline.js')); ?>"></script>

		<!-- Circleful Charts -->
		<script src="<?php echo e(asset('vendor/circliful/circliful.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/circliful/circliful.custom.js')); ?>"></script>


		<!-- Bootstrap Select JS -->
		<script src="<?php echo e(asset('vendor/bs-select/bs-select.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/bs-select/bs-select-custom.js')); ?>"></script>


		<!-- Data Tables -->
		<script src="<?php echo e(asset('vendor/datatables/dataTables.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/dataTables.bootstrap.min.js')); ?>"></script>
		
		<!-- Custom Data tables -->
		<script src="<?php echo e(asset('vendor/datatables/custom/custom-datatables.js')); ?>"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="<?php echo e(asset('vendor/datatables/buttons.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/jszip.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/pdfmake.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/vfs_fonts.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/html5.min.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/datatables/buttons.print.min.js')); ?>"></script>

		<!-- Dropzone JS -->
		<script src="<?php echo e(asset('vendor/dropzone/dropzone.min.js')); ?>"></script>

		<!-- Date Range JS -->
		<script src="<?php echo e(asset('vendor/daterange/daterange.js')); ?>"></script>
		<script src="<?php echo e(asset('vendor/daterange/custom-daterange.js')); ?>"></script>

		<!-- Main Js Required -->
		<script src="<?php echo e(asset('js/main.js')); ?>"></script>

	</body>

</html>
<?php /**PATH /home2/morttacy/morttsonsposfiles/resources/views/inc/export-products.blade.php ENDPATH**/ ?>