<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\FinalProduction;
use App\Models\Branch;

class GeneralController extends Controller
{
    public function Products()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => API_URL,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{"query":"query GetProducts {\\n  getProducts {\\n    data {\\n      _id\\n      productCode\\n      productImage\\n      name\\n      unitPrice\\n      width\\n      height\\n      family\\n      dominantColor\\n      imagePublicId\\n      size\\n      productionCategory\\n      description\\n      generalDescription\\n      activatedBranches\\n      enabled\\n      ingredientsList\\n    }\\n    message\\n    success\\n    statusCode\\n  }\\n}","variables":{}}',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $data = json_decode($response, true);
        $getProductsData = $data['data']['getProducts']['data'];


        foreach ($getProductsData as $key => $product) {
            FinalProduction::updateOrcreate(
                ['product_id' => $product['_id']],
                [
                'product_name' => $product['name'],
                'product_category'=> $product['productionCategory'],
                'product_price'=> $product['unitPrice']/100,
                'product_description'=> $product['description']
                ]);
        }

        return redirect('/');
        

    }


    public function Branches() {

        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS =>'{"query":"query GetBranches {\\n  getBranches {\\n    data {\\n      _id\\n      name\\n      branchLocation\\n      region\\n      coordinates {\\n        latitude\\n        longitude\\n      }\\n      branchContact\\n      branchCode\\n      enabled\\n      pickupOnly\\n      deliveryOnly\\n      branchHasPinkBerry\\n      branchImage\\n      width\\n      height\\n      imagePublicId\\n      createdAt\\n      updatedAt\\n      operationTime {\\n        closingTime\\n        openingTime\\n      }\\n      deliveryOperationTime {\\n        closingTime\\n        openingTime\\n      }\\n    }\\n    message\\n    success\\n    statusCode\\n  }\\n}","variables":{}}',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);
            $data = json_decode($response, true);
            $banchData = $data['data']['getBranches']['data'];

            foreach ($banchData as $key => $branch) {
                Branch::updateOrcreate([
                    'branch_id'=> $branch['_id']
                ],
                    ['branch_name' => $branch['name'],
                    'branch_location' => $branch['branchLocation'],
                    'branch_contact' => $branch['branchContact']
                ]);
            }

            return redirect('/');

    }


    public function updateSystem()
    {   
        try {
            // Perform DB Transaction
            \DB::beginTransaction();
            $url = API_URL;
            $contents = file_get_contents($url);
            $name = substr($url, strrpos($url, '/') + 1);
            Storage::put($name, $contents);
        
            $appfile = 'callupdates.zip';
            $path = Storage::path($appfile);
            $zip = new \ZipArchive();
            $res = $zip->open($path);
            if ($res === TRUE) {

                $storageDestinationPath = base_path();
            
                    if (!\File::exists( $storageDestinationPath)) {
                        \File::makeDirectory($storageDestinationPath, 0755, true);
                    }
                    $zip->extractTo($storageDestinationPath);
                    $zip->close();

                    Artisan::call('view:clear');
                    Artisan::call('cache:clear');
                    Artisan::call('migrate');

                    \DB::commit();
                    return back()->with('status', 'Software Updated Successfully');

                }else {
                    return back()->with('status', 'System is up to date!');
                }

            } catch (\Throwable $th) {
                \DB::rollback();
                return back()->with('statuspass', 'Failed to extract the ZIP archive.');
            } 
    }

    public function GetCurrentJwt() {
        return MyHelper::jwToken();
    }

    public function myOrders(){
        return view('orders');
    }


    public function myOrdersFilter(){
        return view('orders');
    }
}
