<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\User;


class MyHelper extends Controller
{
    
    public static function nameSeparator($name){
        $enteredName = explode(" ", $name);
        return $enteredName[0];
    }   



    public static function Greetings(){
            date_default_timezone_set('Europe/London');
            $currentHour = date('G'); // Get the current hour in the 'Europe/London' timezone
            if ($currentHour >= 5 && $currentHour < 12) {
                $greeting = "Good Morning";
            } elseif ($currentHour >= 12 && $currentHour < 18) {
                $greeting = "Good Afternoon";
            } elseif ($currentHour >= 18 && $currentHour < 22) {
                $greeting = "Good Evening";
            } else {
                $greeting = "Good Night";
            }
            return $greeting;
    }


    public static function Products()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => API_URL,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{"query":"query GetProducts {\\n  getProducts {\\n    data {\\n      _id\\n      productCode\\n      productImage\\n      name\\n      unitPrice\\n      width\\n      height\\n      family\\n      dominantColor\\n      imagePublicId\\n      size\\n      productionCategory\\n      description\\n      generalDescription\\n      activatedBranches\\n      enabled\\n      ingredientsList\\n    }\\n    message\\n    success\\n    statusCode\\n  }\\n}","variables":{}}',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $data = json_decode($response, true);
        return $getProductsData = $data['data']['getProducts']['data'];

    }




    public static function jwToken() {
        $user_phone = auth()->user()->phone_number;
        $user_pass = auth()->user()->app_password;
            try {
                $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS =>'{"query":"mutation CallCenterAgentLogin($phoneNumber: phoneNumber_String_NotNull_minLength_9_maxLength_13!, $password: password_String_NotNull_minLength_6_maxLength_256!) {\\r\\n  callCenterAgentLogin(phoneNumber: $phoneNumber, password: $password) {\\r\\n    data {\\r\\n      jwt\\r\\n      phoneNumber\\r\\n    }\\r\\n    message\\r\\n    success\\r\\n    statusCode\\r\\n  }\\r\\n}\\r\\n\\r\\n\\r\\n","variables":{"phoneNumber":"'.$user_phone.'","password":"'.$user_pass.'"}}',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);
            $response = json_decode($response, true);
            return $response['data']['callCenterAgentLogin']['data']['jwt'];

            } catch (\Throwable $th) {
                return 'Error';
            }
            
    }




    public static function placeOrderApi($jwtToken, $outlet, $name, $contact, $address, $note, $orderType, $deliveryFee, $customerOrder) {
            logger(json_encode($customerOrder, true));
            $customerOrder = json_encode($customerOrder, true);
            $deliveryFee = $deliveryFee*100;
            // $orderType = ($orderType == 1 ? true : false);
            // dd((boolean)$type);
            // dd([$orderType, $deliveryFee]);
            $query = '{"query":"mutation CreateCallCenterAgentOrder($orderInput: CallCenterOrderInput!) {\\r\\n  createCallCenterAgentOrder(orderInput: $orderInput) {\\r\\n    data {\\r\\n      _id\\r\\n      orderCode\\r\\n      status\\r\\n      productTotalPrice\\r\\n      deliveryFee\\r\\n      branchId\\r\\n      address\\r\\n      location {\\r\\n        latitude\\r\\n        longitude\\r\\n      }\\r\\n      readyAt\\r\\n      completedAt\\r\\n      deliveredAt\\r\\n      cancelledAt\\r\\n      acceptedAt\\r\\n      deliveringAt\\r\\n      paymentOption\\r\\n      pickup\\r\\n      paid\\r\\n      discount\\r\\n      packages {\\r\\n        quantity\\r\\n        productId {\\r\\n          _id\\r\\n         \\r\\n        }\\r\\n        extras {\\r\\n          _id\\r\\n\\r\\n        }\\r\\n      }\\r\\n      otp\\r\\n      createdAt\\r\\n      updatedAt\\r\\n      callCenterAgentId {\\r\\n        _id\\r\\n      \\r\\n      }\\r\\n     \\r\\n      comment\\r\\n      couponCashWorth\\r\\n      phoneNumber\\r\\n      customerName\\r\\n    }\\r\\n    message\\r\\n    success\\r\\n    statusCode\\r\\n  }\\r\\n}","variables":{"orderInput":{"deliveryFee":'.$deliveryFee.',"address":"'.$address.'","branchId":"'.trim($outlet).'","comment":"'.$note.'","deliveryType":"PICKUP","location":{"longitude":0,"latitude":0},"packages":'.$customerOrder.',"pickup":'.($orderType == 1 ? "true" : "false").',"customerName":"'.$name.'","phoneNumber":"'.$contact.'","paymentOption":"CASH"}}}';
            $curl = curl_init();
            curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $query,
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $jwtToken,
                'Content-Type: application/json'
            ),
            ));


            $response = curl_exec($curl);


            curl_close($curl);
            return $response;

    }


    public static function OrderStatus($token, $orderId){

        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => API_URL,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{"query":"query GetCallCenterAgentOrderById($callCenterAgentOrderId: ID!) {\\r\\n  getCallCenterAgentOrderById(callCenterAgentOrderId: $callCenterAgentOrderId) {\\r\\n    data {\\r\\n      _id\\r\\n      orderCode\\r\\n      status\\r\\n      productTotalPrice\\r\\n      deliveryFee\\r\\n      branchId\\r\\n      address\\r\\n      location {\\r\\n        latitude\\r\\n        longitude\\r\\n      }\\r\\n      readyAt\\r\\n      completedAt\\r\\n      deliveredAt\\r\\n      cancelledAt\\r\\n      acceptedAt\\r\\n      deliveringAt\\r\\n      paymentOption\\r\\n      pickup\\r\\n      paid\\r\\n      discount\\r\\n      packages {\\r\\n        quantity\\r\\n        productId {\\r\\n          _id\\r\\n          productCode\\r\\n          productImage\\r\\n          name\\r\\n          familyName\\r\\n          unitPrice\\r\\n          width\\r\\n          height\\r\\n          family\\r\\n          dominantColor\\r\\n          imagePublicId\\r\\n          size\\r\\n          productionCategory\\r\\n          description\\r\\n          generalDescription\\r\\n          enabled\\r\\n          ingredientsList\\r\\n        }\\r\\n        extras {\\r\\n          _id\\r\\n          productCode\\r\\n          productImage\\r\\n          name\\r\\n          familyName\\r\\n          unitPrice\\r\\n          width\\r\\n          height\\r\\n          family\\r\\n          dominantColor\\r\\n          imagePublicId\\r\\n          size\\r\\n          productionCategory\\r\\n          description\\r\\n          generalDescription\\r\\n          enabled\\r\\n          ingredientsList\\r\\n        }\\r\\n      }\\r\\n      otp\\r\\n      createdAt\\r\\n      updatedAt\\r\\n      callCenterAgentId {\\r\\n        _id\\r\\n        username\\r\\n        phoneNumber\\r\\n        email\\r\\n        enabled\\r\\n      }\\r\\n      assignedSalesPerson {\\r\\n        _id\\r\\n        username\\r\\n        phoneNumber\\r\\n        email\\r\\n        branchId {\\r\\n          _id\\r\\n          branchCode\\r\\n          name\\r\\n        }\\r\\n        enabled\\r\\n      }\\r\\n      comment\\r\\n      couponCashWorth\\r\\n      phoneNumber\\r\\n      customerName\\r\\n    }\\r\\n    message\\r\\n    success\\r\\n    statusCode\\r\\n  }\\r\\n}","variables":{"callCenterAgentOrderId":"'.$orderId.'"}}',
          CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer ' . $token,
            'Content-Type: application/json'
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        return json_decode($response, true);

    }


    public static function loginApi($email) {
        $response = \DB::connection('db1')->table('users')->where('email', $email)->first();
        try {
            if (empty($response)) {
                return redirect()->route('logout');
                return back()->with('statuspass', 'unauthorised access');
            }
            $user = User::updateOrCreate(
                ['email' => $response->email],
                [
                'id' => $response->id,
                'name'=> $response->name,
                'phone_number' => $response->phone_number,
                'app_password' => $response->app_password,
                'password' => $response->password
                ]);
        } catch (\Throwable $th) {
            throw $th;
        }
        
    }
}
