<?php

namespace App\Livewire;

use Livewire\Component;
use App\Http\Controllers\MyHelper;
use App\Models\FinalProduction;
use App\Models\Branch;
use App\Models\Order;
use Illuminate\Support\Facades\Cache;

class MainDashboard extends Component
{   
    public $search;
    public $product;
    public $searchState ="none";
    public $checkout = 'visible';
    public $checkoutProceed = 'none';
    public $outlet = '';
    public $transactions_id;
    public $name;
    public $contact;
    public $address;
    public $note;
    public $deliveryFee = 0;
    public $orderType = 1;
    public $searchOrder;
   


    protected $rules = [
        'outlet' => 'required',
        'name' => 'required',
        'contact' => 'required|numeric|min:10',
        'deliveryFee' => 'required|numeric'
    ];

    public function AddCartItem($id)
    {
        $this->product = Cache::rememberForever('product_' . $id, function () use ($id) {
            return FinalProduction::where('product_id', $id)->first();
        });

        if (!$this->product) {
            return;
        }

        $id = $this->product->id;
        $product_id = $this->product->product_id;
        $myProduct = $this->product->product_name;
        $price = $this->product->product_price;

        $cart = session()->get('cart', []);
        if( isset($cart[$id]) ) {
            $cart[$id]['invoice_quantity']++;
            $cart[$id]['invoice_total_price'] = ($cart[$id]['invoice_quantity'])*$cart[$id]['invoice_unit_price'];
        } else {
            $cart[$id] = [
                'id' => $id,
                'product_id' => $product_id,
                'user_id' => auth()->user()->id,
                "invoice_product_name" => $myProduct,
                "invoice_quantity"=> 1,
                "invoice_unit_price" => $price,
                "invoice_total_price"=> 1*$price,
                "item_category"=>  $this->product->product_category,
                ];
        }
        session()->put('cart', $cart);
    }


    public function Productions()
    {
        $sell = FinalProduction::when($this->search, function ($query) {
            return $query->where(function ($subquery) {
                $subquery->where('product_name', 'like', '%' . $this->search . '%')
                    ->orWhere('product_category', 'like', '%' . $this->search . '%');
            });
        })
        ->take($this->search ? 10 : 17)
        ->get();
        
        $this->searchState = $sell->isEmpty() ? 'visible' : 'none';
        return $sell;
        
    }

    public function checkoutMain() {
        $this->validate();
        if (empty(session()->get('cart'))) abort('500', 'Empty Cart');
        
        try {
        
        $jwtToken = MyHelper::jwToken();
        if ( $jwtToken == "Error") {
            session()->flash('Orderstatus',"Oops! something Happend");
        }
        $customerOrder = [];
        foreach (session()->get('cart') as $key => $myOrders) {
            $customerOrder[] = [
                'productId' => $myOrders['product_id'],
                'quantity' => $myOrders['invoice_quantity'],
            ];
        }
        $response = MyHelper::placeOrderApi($jwtToken, $this->outlet, $this->name, $this->contact, $this->address, $this->note, $this->orderType, (int)$this->deliveryFee, $customerOrder);
        $responseData = json_decode($response, true);
        if ($responseData['data']['createCallCenterAgentOrder']['success'] == true) {
            $getMainResponseTarget = $responseData['data']['createCallCenterAgentOrder']['data'];
            Order::create([
                'user_id' => auth()->id(),
                'customer_name' => $getMainResponseTarget['customerName'],
                'customer_contact' => $getMainResponseTarget['phoneNumber'],
                'customer_address' => $getMainResponseTarget['address'],
                'customer_note' => $getMainResponseTarget['comment'],
                'customer_delivery_fee' => $getMainResponseTarget['deliveryFee']/100,
                'order_id' => $getMainResponseTarget['_id'],
                'order_type' => 1,
                'branch' => $getMainResponseTarget['branchId'],
                'order_code' => $getMainResponseTarget['orderCode'],
                'total_cost' => $getMainResponseTarget['productTotalPrice']/100,
                'order' => json_encode(session()->get('cart'))
            ]);

            $this->completeTransaction();
            session()->forget(['cart','transaction_number']);
            session()->flash('Orderstatus', $responseData['data']['createCallCenterAgentOrder']['message']);

        }else{session()->flash('Orderstatus', $responseData['data']['createCallCenterAgentOrder']['message']);}
        } catch (\Throwable $th) {
            session()->flash('Orderstatus',"Oops! something Happend, Kindly check Internet connection and try again");
        }
        
        // $this->redirect('/dashboard', navigate:true);
    }


    public function held(){

        $this->validate();
        if (empty(session()->get('cart'))) abort('500', 'Empty Cart');

        Order::create([
            'user_id' => auth()->id(),
            'customer_name' => $this->name,
            'customer_contact' => $this->contact,
            'customer_address' => $this->address,
            'customer_note' => $this->note,
            'customer_delivery_fee' => $this->deliveryFee,
            'order_type' => 2,
            'branch' => $this->outlet,
            'total_cost' => 0,
            'order' => json_encode(session()->get('cart'))
        ]);

        $this->completeTransaction();
        session()->forget(['cart','transaction_number']);
        session()->flash('Orderstatus', 'Transaction held successfully');
    }


    public function displayOut(){
        $branch = Branch::where('branch_id', $this->outlet)->first();
        $this->outlet = $branch->branch_name;
    }


    public function RemoveCart($id)
    {
        $cart = session()->get('cart', []);
        if (!isset($cart[$id])) {
            $message = response([
                'status' => 400,
                'Message' => "Item not found in cart"
            ]);
        }
        unset($cart[$id]);
        session()->put('cart', $cart);
        $message = response([
            'status' => 200,
            'Message' => "Successfully removed from cart"
        ]);

        logger($message);
    }

    public function IncreaseCart($id)
    {
        $cart = session()->get('cart', []);
        if(isset($cart[$id])) {
            $cart[$id]['invoice_quantity']++;
            $cart[$id]['invoice_total_price'] = $cart[$id]['invoice_quantity']*$cart[$id]['invoice_unit_price'];
        }
        session()->put('cart', $cart);
        $message = response([
            'status' => 200,
            'message' => "success"
            ]);

        logger($message);
    }


    public function DecreaseCart($id)
    {
        $cart = session()->get('cart', []);
        if(isset($cart[$id])) {
            if ($cart[$id]['invoice_quantity'] <= 1) {
                session()->flash('status', 'Cart item cannot be less than 1');
                return;
            }
            $cart[$id]['invoice_quantity']--;
            $cart[$id]['invoice_total_price'] = $cart[$id]['invoice_quantity']*$cart[$id]['invoice_unit_price'];
        }
        session()->put('cart', $cart);
        logger("Success");
    }


    public function ClearCart()
    {
        session()->forget('cart');
        $this->search = null;
        $this->deliveryFee = 0;
    }

    Public function transactionNumber()
    {   
        if (empty(session()->get('transaction_number'))) {
            session()->put('transaction_number', rand(1000,85600) . date('YmdHis') );
        }

        return session()->get('transaction_number');
    }


    public function SearchOrderMethod() {

        if (empty($this->searchOrder) || $this->searchOrder == "") {
            return $this->redirect('/d/orders', navigate: true);
        }

        $order = Order::where('customer_name', 'like', '%' . $this->searchOrder . '%')
            ->orWhere('customer_contact', 'like', '%' . $this->searchOrder . '%')
            ->orderByDesc('id')
            ->take(17)->get();

        
        Cache::put('searchOrder', $order);
        return $this->redirect('/d/orders/filter', navigate: true);
    }


    public function completeTransaction() {
        $this->search = '';
        $this->transactionNumber();
        $this->deliveryFee = 0;
        $this->reset();
    }
    

    public function render()
    {
        return view('livewire.main-dashboard', [
            'cart' => session()->get('cart'),
            'myProducts' => $this->Productions(),
            'transaction' =>  $this->transactionNumber(),
            'branches' => Branch::OrderBy('branch_name', 'ASC')->get()
        ]);
    }


   
}
