<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Order;
use App\Http\Controllers\MyHelper;
use Illuminate\Support\Facades\Http;

class OrderLivewire extends Component
{

    public $searchState = false;
    public $search = null;
    public $displaydetails = false;
    public $name;
    public $contact;
    public $address;
    public $note;
    public $created;
    public $items;
    public $deliveryFee;
    public $searchOrder;
    public $searchingState ="none";
    public $orderState;
    public $agent;

    public function MyOrders(){
        return Order::where('user_id', auth()->id())->orderByDesc('id')->paginate(50);
    }


    public function orderDetails($order){

        try {
            $orderId = $order;
            $jwtToken = MyHelper::jwToken();
            $data = MyHelper::OrderStatus($jwtToken, $orderId);
            // dd($data['data']['getCallCenterAgentOrderById']['data']);
            $state = ($data['data']['getCallCenterAgentOrderById']['data']['status']);
            // dd(json_encode($data['data']['getCallCenterAgentOrderById']['data']['packages'], true));

            $timestamp = $data['data']['getCallCenterAgentOrderById']['data']['createdAt'] / 1000; // Convert milliseconds to seconds
            $dateTime = \Carbon\Carbon::createFromTimestamp($timestamp);

            $this->displaydetails = true;
            $this->name = $data['data']['getCallCenterAgentOrderById']['data']['customerName'];
            $this->contact = $data['data']['getCallCenterAgentOrderById']['data']['phoneNumber'];
            $this->address = $data['data']['getCallCenterAgentOrderById']['data']['address'];
            $this->note = $data['data']['getCallCenterAgentOrderById']['data']['comment'];
            $this->created = $dateTime;
            $this->orderState = $state;
            $this->items = $data['data']['getCallCenterAgentOrderById']['data']['packages'];
            $this->deliveryFee = $data['data']['getCallCenterAgentOrderById']['data']['deliveryFee'];
            $this->agent = Order::where('order_id', $order)->first();
        } catch (\Throwable $th) {
            return redirect()->route('dashboard')->with('statuspass', 'Ooops! somrthing went wrong, Kindly check Internet connection');
        }
        

    }


    public function Orders()
    {
        if( $this->searchOrder == '' ) {
            $order = Order::whereDate('created_at', \carbon\carbon::today())->orderByDesc('id')->take(17)->get();
        }else {

            $order = Order::where('customer_name', 'like', '%' . $this->searchOrder . '%')
            ->orWhere('customer_contact', 'like', '%' . $this->searchOrder . '%')
            ->whereDate('created_at', \carbon\carbon::today())
            ->orderByDesc('id')
            ->take(17)->get();
        }
        
        
        $this->searchingState = $order->isEmpty() ? 'visible' : 'none';
        return $order;
    }


    public function render()
    {
        return view('livewire.order-livewire', [
            'orders' => $this->Orders()
        ]);
    }
}
