<div>
<div class="main-wrappers">

<div class="header">

<div class="header-left active">
<a href="{{route('dashboard')}}" wire:navigate class="logo logo-normal">
<img src="/assets/img/logo-pizzaman.png" alt>
</a>
<a href="{{route('dashboard')}}" wire:navigate class="logo logo-white">
<img src="/assets/img/logo-pizzaman.png" alt>
</a>
<a href="{{route('dashboard')}}" wire:navigate class="logo-small">
<img src="/assets/img/logo-pizzaman.png" alt>
</a>
</div>

<a id="mobile_btn" class="mobile_btn" href="#sidebar">
<span class="bar-icon">
<span></span>
<span></span>
<span></span>
</span>
</a>

<ul class="nav user-menu">

<li class="nav-item nav-searchinputs">
<div class="top-nav-search">
<a href="javascript:void(0);" class="responsive-search">
<i class="fa fa-search"></i>
</a>

<div class="searchinputs">
<input type="text" placeholder="Search by name or contact..." wire:model="searchOrder">
<div class="search-addon">
<span wire:click="SearchOrderMethod"><i class="icon-search"></i></span>
</div>
</div>

</div>
</li>

<li class="nav-item nav-item-box">
<a href="javascript:void(0);" id="btnFullscreen">
<i class="icon-fullscreen"></i>
</a>
</li>
<li class="nav-item nav-item-box">
<a href="{{route('branch')}}" wire:navigate title="Load Branches">
<i class="icon-airplay"></i>
</a>
</li>

<li class="nav-item nav-item-box">
<a href="{{route('product')}}" wire:navigate title="Load Products">
<i class="icon-layers2"></i>
</a>
</li>

<li class="nav-item nav-item-box">
<a href="{{route('updateSystem')}}" wire:navigate title="Update System"><i class="icon-cloud"></i></a>
</li>

<li class="nav-item dropdown has-arrow main-drop">
<a href="javascript:void(0);" class="dropdown-toggle nav-link userset" data-bs-toggle="dropdown">
<span class="user-info">
<span class="user-letter">
<img src="/assets/img/user-286.jpg" alt class="img-fluid">
</span>
<span class="user-detail">
<span class="user-name">{{auth()->user()->name}}</span>
<span class="user-role">Call Center</span>
</span>
</span>
</a>
<div class="dropdown-menu menu-drop-user">
<div class="profilename">
<div class="profileset">
<span class="user-img"><img src="/assets/img/user-286.jpg" alt>
<span class="status online"></span></span>
<div class="profilesets">
<h6>{{auth()->user()->name}}</h6>
<h5>{{auth()->user()->email}}</h5>
</div>
</div>
<hr class="m-0">
<a href="{{ route('logout') }}" class="dropdown-item logout pb-0"
                                onclick="event.preventDefault();
                                            document.getElementById('logout-form').submit();">
                                            <img src="/assets/img/log-out.svg" class="me-2" alt="img">Logout
                                        </a>
                                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                    @csrf
                                </form>
</div>
</div>
</li>
</ul>


<div class="dropdown mobile-user-menu">
<a href="javascript:void(0);" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-ellipsis-v"></i></a>
<div class="dropdown-menu dropdown-menu-right">
<a class="dropdown-item" href="#">My Profile</a>
<a class="dropdown-item" href="#">Settings</a>
<a class="dropdown-item" href="#">Logout</a>
</div>
</div>

</div>

<div class="page-wrapper ms-0">
<div class="content">
<div class="row">
<div class="col-lg-8 col-sm-12 tabs_wrapper">
<div class="page-header ">
<div class="page-title">
<h4>{{ App\Http\Controllers\MyHelper::Greetings()}}, {{ App\Http\Controllers\MyHelper::nameSeparator(auth()->user()->name) }}!</h4>
<h6>Create a new sale</h6>
</div>
</div>

@include('inc.errorfile')

<div class="tabs_container">
<div class="tab_content active" data-tab="fruits">
<div class="row ">

<div class="card">
<div class="card-body">

<div class="form-group">
    <label>Product Name</label>
    <div class="input-groupicon">
        <input type="text" placeholder="Please type product code and select..." wire:model.live="search">
        <div class="addonset">
            <img src="assets/img/scanners.svg" alt="img">
        </div>
    </div>
</div>


<div class="table-responsive mb-3">
<table class="table">
<thead>
<tr>
<th>#</th>
<th>Product Name</th>
<th>Category</th>
<th>Price <br> GH¢</th>
<th>Tax</th>
</tr>
</thead>
<tbody>
@foreach($myProducts as $product)
<tr  wire:click="AddCartItem('{{$product->product_id}}')" style="cursor: pointer">
<td>{{$loop->iteration}}</td>
<td class="productimgname">
<a href="javascript:void(0);">{{@ucwords(@strtolower($product->product_name))}}</a>
</td>
<td>{{$product->product_category}}</td>
<td>@convert($product->product_price)</td>
<td>0.00</td>
</tr>
@endforeach
</tbody>
</table>

<div class="noresult" style="display: {{$searchState}}">
    <div class="text-center">
        <h5 class="mt-2">Sorry! No Result Found for {{$search}}</h5>
        <p class="text-muted">We've searched more than 100+ Products We did not find any Product for your search. </p>
    </div>
</div>
                                            
</div>


</div>
</div>

</div>
</div>



</div>
</div>


<div class="col-lg-4 col-sm-12 ">
<div class="order-list">
    <div class="orderid">
        <h4>Order Details</h4>
        <h5>Input customer information, review shopping cart, and confirm your order.</h5>
    </div>
</div>
<form wire:submit.prevent="checkoutMain">
<div class="card card-order">
<div class="card-body">
<div class="row">

<!-- CUSTOMER DATA -->
<div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
												
    <!-- Field wrapper start -->
    <div class="field-wrapper">
    
    <div class="field-placeholder">Customer Name <span class="text-danger">*</span></div>
        <div class="input-group">
            <input class="form-control" type="text" wire:model="name" required>
        </div>
        @error('name') <small class="error text-danger">{{ $message }}</small> @enderror
    </div>
    <!-- Field wrapper end -->

</div>
<div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
    
    <!-- Field wrapper start -->
    <div class="field-wrapper">
    
        <div class="field-placeholder">Phone No# <span class="text-danger">*</span></div>
        <div class="input-group">
            <input class="form-control" type="tel" wire:model="contact" pattern="[0-9]{4}[0-9]{4}[0-9]{2}" required>
        </div>
        @error('contact') <small class="error text-danger">{{ $message }}</small> @enderror
    </div>
    <!-- Field wrapper end -->

</div>
<div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
    
    <!-- Field wrapper start -->
    <div class="field-wrapper">
    
    <div class="field-placeholder">Location <small>(optional)</small></div>
        <div class="input-group">
            <input class="form-control" type="text" wire:model="address">
        </div>
        @error('address') <small class="error text-danger">{{ $message }}</small> @enderror
    </div>
    <!-- Field wrapper end -->
</div>

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-1">
    @error('outlet') <small class="error text-danger">{{ $message }}</small> @enderror
     <div class="searchable-select" style="margin-bottom:20px">
        <select id="selectBox" wire:model="outlet" class="form-control">
            <option value="" disabled selected>- select outlet -</option>
            @foreach($branches as $branch)
            <option value="{{$branch->branch_id}}">{{@ucwords(@strtolower($branch->branch_name))}}</option>
            @endforeach
        </select>
    </div>
    
</div>


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
    <!-- Field wrapper start -->
    <div class="field-wrapper">
    @error('note') <small class="error text-danger">{{ $message }}</small> @enderror
        <div class="field-placeholder">Note</div>
        <textarea class="form-control" rows="2" wire:model="note"></textarea>
    </div>
    <!-- Field wrapper end -->

</div>


</div>
</div>

<div class="card-body pt-0">

@if (session('status'))
       <small class="text-info" style="margin:10px"> {{ session('status') }}</small>
@endif

<div class="totalitem">
<h4>Total items : <?= empty($cart) ? 0 : count($cart)?> </h4>
<a href="javascript:void(0);" wire:click="ClearCart"  wire:confirm="Are you sure you want to clear this transaction?">Clear all</a>
</div>


<div class="product-table">
<p class="alert alert-warning" wire:offline>
    Whoops, your device has lost connection. The web page you are viewing is offline.
</p>
@if(empty($cart))
<p style="text-align:center">Cart is empty</p>
@else
@foreach($cart as $cart)
<ul class="product-lists">
<li>
<div class="productimg">
<div class="productimgs">
<img src="/assets/img/friedrice-5-dc20b101.jpg" alt="img" style="border-radius:5px">
</div>
<div class="productcontet">
<h4>{{$cart['invoice_product_name']}}</h4> 
<div class="productlinkset">
<h5>{{$cart['item_category']}}</h5>
</div>
<div class="increment-decrement">
<div class="input-groups">
<input type="button" value="-"  wire:click="DecreaseCart({{$cart['id']}})" class="button-minus button">
<input type="text" min="0" readonly value="{{$cart['invoice_quantity']}}" max="20" class="quantity-field">
<input type="button" value="+" class="button-plus button" wire:click="IncreaseCart({{$cart['id']}})">
</div>
</div>
</div>
</div>
</li>
<li>@convert($cart['invoice_unit_price'])</li>
<li><a href="javascript:void(0)" wire:click="RemoveCart({{$cart['id']}})"><img src="/assets/img/delete-2.svg" alt="img"></a></li>
</ul>
@endforeach
@endif

</div>
</div>
<div class="split-card">
</div>
<div class="card-body pt-0 pb-0">
<div class="setvalue">
<ul>
<li>
<h5>Subtotal </h5>
<h6>@convert($total = empty($totalCart) ? 0 : $totalCart)GH¢</h6>
</li>
<!-- <li>
<h5>Tax </h5>
<h6>@convert(0)GH¢</h6>
</li> -->
<li>
<h5>Delivery fee </h5>
<h6>@convert($dfee = empty($deliveryFee) ? 0 : $deliveryFee)GH¢</h6>
</li>
<li class="total-value">
<h5>Total </h5>
<h6>@convert($total + $dfee)</h6>
</li>
</ul>
</div>

<div class="setvalue">

<ul>
<li>
<h5>Order Type </h5>
<select style="width:50%;" class="form-control" wire:model="orderType" onChange="selectType()" id="dtype">
    <option value="1" selected>Pickup</option>
    <option value="0">Delivery</option>
</select>
</li>
<li id="divToToggle" style="display: none;" wire:ignore>
<h5>Delivery Fee</h5>
<input type="number" wire:model.live="deliveryFee"  style="width:50%;" class="form-control" required>
</li>
</ul>
</div>



@if (session('Orderstatus'))
<p class="alert alert-warning alert-dismissible fade show">
{{ session('Orderstatus') }}
</p>
@endif

    <button type="submit" onclick="return confirm('Are you sure you want to checkout, Kindly Confirm outlet? you will not be able to revert')" class="btn-totallabel" style="width:100%; border:none">
            <div wire:loading>
                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
												Loading...
            </div>
        <h5>Checkout</h5>
        <h6>@convert($total + $dfee)GH¢</h6>
    </button>

    </form>
<div class="btn-pos">
<ul>
<li>
<a class="btn" wire:click="held" wire:confirm="Are you sure you want to hold this transaction?"><img src="/assets/img/pause1.svg" alt="img" class="me-1">Hold</a>
</li>
<li>
<a class="btn" wire:click="ClearCart"  wire:confirm="Are you sure you want to clear this transaction?"><img src="/assets/img/trash12.svg" alt="img" class="me-1">Void</a>
</li>
<li>
<a class="btn" href="{{route('myOrders')}}" wire:navigate><img src="/assets/img/transcation.svg" alt="img" class="me-1"> Transaction</a>
</li>
</ul>
</div>
</div>
</div>
</div>
</div>
</div>



</div>
</div>
</div>


