<div>
<div class="main-wrappers">

<div class="header">

<div class="header-left active">
<a href="{{route('dashboard')}}" wire:navigate class="logo logo-normal">
<img src="/assets/img/logo-pizzaman.png" alt>
</a>
<a href="{{route('dashboard')}}" wire:navigate class="logo logo-white">
<img src="/assets/img/logo-pizzaman.png" alt>
</a>
<a href="{{route('dashboard')}}" wire:navigate class="logo-small">
<img src="/assets/img/logo-pizzaman.png" alt>
</a>
</div>

<a id="mobile_btn" class="mobile_btn" href="#sidebar">
<span class="bar-icon">
<span></span>
<span></span>
<span></span>
</span>
</a>

<ul class="nav user-menu">

<li class="nav-item nav-searchinputs">
<a href="https://menu.ceqalimited.com" target="_blank">
Digital Menu
</a>
</li>

<li class="nav-item nav-item-box">
<a href="javascript:void(0);" id="btnFullscreen">
<i class="icon-fullscreen"></i>
</a>
</li>
<li class="nav-item nav-item-box">
<a href="{{route('product')}}" wire:navigate title="Load Branches">
<i class="icon-airplay"></i>
</a>
</li>

<li class="nav-item nav-item-box">
<a href="{{route('branch')}}" wire:navigate title="Load Products">
<i class="icon-layers2"></i>
</a>
</li>

<li class="nav-item nav-item-box">
<a href="{{route('updateSystem')}}" wire:navigate title="Update System"><i class="icon-cloud"></i></a>
</li>

<li class="nav-item nav-item-box">
<a href="#"><i class="icon-settings1"></i></a>
</li>
<li class="nav-item dropdown has-arrow main-drop">
<a href="javascript:void(0);" class="dropdown-toggle nav-link userset" data-bs-toggle="dropdown">
<span class="user-info">
<span class="user-letter">
<img src="/assets/img/user-286.jpg" alt class="img-fluid">
</span>
<span class="user-detail">
<span class="user-name">{{auth()->user()->name}}</span>
<span class="user-role">Call Center Agent</span>
</span>
</span>
</a>
<div class="dropdown-menu menu-drop-user">
<div class="profilename">
<div class="profileset">
<span class="user-img"><img src="/assets/img/user-286.jpg" alt>
<span class="status online"></span></span>
<div class="profilesets">
<h6>{{auth()->user()->name}}</h6>
<h5>{{auth()->user()->email}}</h5>
</div>
</div>
<hr class="m-0">
<a class="dropdown-item" href="{{route('profile.show')}}" wire:navigate> <i class="me-2" data-feather="user"></i> My Profile</a>
<a class="dropdown-item" href="#"><i class="me-2" data-feather="settings"></i>Settings</a>
<hr class="m-0">
<a href="{{ route('logout') }}" class="dropdown-item logout pb-0"
                                onclick="event.preventDefault();
                                            document.getElementById('logout-form').submit();">
                                            <img src="/assets/img/log-out.svg" class="me-2" alt="img">Logout
                                        </a>
                                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                    @csrf
                                </form>
</div>
</div>
</li>
</ul>


<div class="dropdown mobile-user-menu">
<a href="javascript:void(0);" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-ellipsis-v"></i></a>
<div class="dropdown-menu dropdown-menu-right">
<a class="dropdown-item" href="#">My Profile</a>
<a class="dropdown-item" href="#">Settings</a>
<a class="dropdown-item" href="#">Logout</a>
</div>
</div>

</div>

<div class="page-wrapper ms-0">
<div class="content">
<div class="row">
<div class="col-lg-8 col-sm-12 tabs_wrapper">
<div class="page-header ">
<div class="page-title">
<h4>Transactions</h4>
<h6>Review and verify order status</h6>
</div>
</div>

<div class="tabs_container">
<div class="tab_content active" data-tab="fruits">
<div class="row ">

<div class="card">
<div class="card-body">

<div class="form-group">
    <label>Order Search</label>
    <div class="input-groupicon">
        <input type="text" placeholder="Search order by name or contact or Order number...." wire:model.live="searchOrder">
        <div class="addonset">
            <img src="/assets/img/scanners.svg" alt="img">
        </div>
    </div>
</div>


<div class="table-responsive mb-3">
<table class="table">
<thead>
<tr>
<th>#</th>
<th>Customer Name</th>
<th>Entered By</th>
<th>Phone Number</th>
<th>OrderedAt</th>
<th>Action</th>
</tr>
</thead>
<tbody>
@if(Route::currentRouteName() == "myOrdersFilter")

@foreach(Cache::get('searchOrder') as $order)

<?php $date = \Carbon\Carbon::parse($order->created_at, 'UTC');?>

<tr>
<td>{{$loop->iteration}}</td>
<td>{{$order->customer_name}}</td>
<td>{{$order->user->name}}</td>
<td class="productimgname">
<a href="tel:{{$order->customer_contact}}">{{$order->customer_contact}}</a>
</td>
<td>{{$date->isoFormat('MMMM Do YYYY, h:mm:ss a')}}</td>
<td>
    <a wire:click="orderDetails('{{$order->order_id}}')"><i class="icon-eye1"></i></a>
</td>
</tr>
@endforeach

@else
@foreach($orders as $order)

<?php $date = \Carbon\Carbon::parse($order->created_at, 'UTC');?>

<tr>
<td>{{$loop->iteration}}</td>
<td>{{$order->customer_name}}</td>
<td>{{$order->user->name}}</td>
<td class="productimgname">
<a href="tel:{{$order->customer_contact}}">{{$order->customer_contact}}</a>
</td>
<td>{{$date->isoFormat('MMMM Do YYYY, h:mm:ss a')}}</td>
<td>
    <a wire:click="orderDetails('{{$order->order_id}}')"><i class="icon-eye1"></i></a>
</td>
</tr>
@endforeach
@endif
</tbody>
</table>

<div class="noresult" style="display: {{$searchingState}}">
    <div class="text-center">
        <h5 class="mt-2">Sorry! No Result Found for {{$searchOrder}}</h5>
        <p class="text-muted">We've searched more than 100+ orders We did not find any order for your search. </p>
    </div>
</div>
                                            
</div>


</div>
</div>

</div>
</div>



</div>
</div>


<div class="col-lg-4 col-sm-12 ">
<div class="order-list">
    <div class="orderid">
        <h4>Order Details</h4>
        <h5>Details of the order can be found below.</h5>
    </div>
</div>

<div class="card card-order">
<div class="card-body">
<div class="row">
<div style="margin:12px">
<div wire:loading>
                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                Retrieving order information, kindly hold on for a moment...
            </div>
</div>
@if ($displaydetails)
<ul style="margin-bottom:15px">
    <li><strong id="receiver_name">{{@ucwords(@strtoupper($name))}}</strong></li>
    <li>Phone Number: {{$contact}}</li>
    <li>Address: {{empty($address) ? 'No Address' : $address}}</li>
    <li>Note: {{empty($note) ? 'Order note not attached' : $note }}</li>
    <li><strong>Created At:</strong> <em>{{$created->diffForHumans()}}</em></li>
    <li><strong>Agent: </strong> {{empty($agent) ? "No Assigned Agent" : $agent->user->name}}</li>
</ul>

<hr>

<?php $sumTotalCart = 0 ?>
@foreach($items as $item)
<?php $sumTotalCart += $item['quantity']*$item['productId']['unitPrice'] ?>
<ul class="product-lists">
<li>
<div class="productimg">
<div class="productimgs">
<img src="{{$item['productId']['productImage']}}" alt="img" style="border-radius:5px">
</div>
<div class="productcontet">
<h4>{{$item['productId']['name']}}</h4> 
<div class="productlinkset">
<h5>{{$item['productId']['productionCategory']}}</h5>
</div>
<div class="increment-decrement">
<div class="input-groups">
<input type="button" value="-" class="button-minus button">
<input type="text" min="0" readonly value="{{$item['quantity']}}" max="20" class="quantity-field">
<input type="button" value="+" class="button-plus button">
</div>
</div>
</div>
</div>
</li>
<li>@convert(($item['productId']['unitPrice'])/100)</li>
</ul>
@endforeach
<div class="card-body pt-0 pb-0">
<div class="setvalue">
<ul>
<li>
<h5>Status</h5>
<h6><strong>{{$orderState}}</strong></h6>
</li>
<li>
<h5>Sub Total</h5>
<h6>@convert($sumTotalCart/100)GH¢</h6>
</li>
<li>
<h5>Delivery Fee</h5>
<h6>@convert($dfee = ($deliveryFee/100))GH¢</h6>
</li>
<li class="total-value">
<h5>Total </h5>
<h6>@convert(($sumTotalCart/100) + $dfee)GH¢</h6>
</li>
</ul>
</div>
</div>
@else
<img src="/assets/img/emptyCart.jpg" alt="">
@endif
</div>
</div>
</div>


<div class="btn-pos">
<ul>
<li>
<a class="btn" href="{{route('dashboard')}}" wire:navigate><img src="/assets/img/transcation.svg" alt="img" class="me-1"> New Transaction</a>
</li>
<li>
<a class="btn" href="{{route('dashboard')}}" wire:navigate> <i class="icon-print me-1"></i> Print Order</a>
</li>
</ul>
</div>
</div>
</div>
</div>
</div>
</div>



</div>
</div>
</div>


