<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::get('/v1/users/{email}', function(Request $request, $email){
    return $users = \DB::table('users')->where('email', $email)->first();
});

Route::get('/v1/orders', function(Request $request){
    return \DB::table('orders')->get();
});


Route::post('/v1/api-token', function(Request $request){
     
     $rules = 
     [
        'phone_number' => 'required',
        'password' => 'required'
    ];
    
    $validator = Validator::make($request->all(), $rules);
    if ($validator->fails()) {
        return $validator->errors();
    }
    
    $response = response([
            'status' => 419,
            'message' => "incorrect phone number or password"
            ]);
            
    $user = User::where('phone_number', request('phone_number'))->first();
    if(!$user)  return $response;
    
    
    $inputPassword = request('password');
    $hashedPassword = $user->password;
    
    if (\Hash::check($inputPassword, $hashedPassword)) {
         $token = $user->createToken('auth_token')->plainTextToken;
         return $token;
    } else {
        return $response;
    }
    
});


Route::middleware('auth:sanctum')->post('/v1/add-user', function(Request $request){
    
    $rules = 
    [
        'email' => 'email|required|max:300',
        'phone_number' => 'required',
        'password' => 'required|min:8',
    ];
    
    $validator = Validator::make($request->all(), $rules);
    if ($validator->fails()) return $validator->errors();
    
    User::updateOrcreate([
        'email' => request('email'),
        'phone_number' => request('phone_number')
    ], [
        'name' => request('name'),
        'password' =>  Hash::make(request('password')),
        'app_password' => request('password')
    ]);

    return response([
        'status' => 200,
        'message' => "Success"
    ]);
});



