<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/general' , [App\Http\Controllers\GeneralController::class, 'Products'])->name('product');
Route::get('/branches' , [App\Http\Controllers\GeneralController::class, 'branches'])->name('branch');
Route::get('/jwt' , [App\Http\Controllers\GeneralController::class, 'GetCurrentJwt']);
Route::get('/update-system' , [App\Http\Controllers\GeneralController::class, 'updateSystem'])->name('updateSystem');


Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');
    Route::get('/d/orders' , [App\Http\Controllers\GeneralController::class, 'myOrders'])->name('myOrders');
    Route::get('/d/orders/filter' , [App\Http\Controllers\GeneralController::class, 'myOrdersFilter'])->name('myOrdersFilter');
});
