<?php

namespace App\Http\Controllers;

use App\Models\FinalProduction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Artisan;


class FinalProductionController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function SyncProduct()
    {
        $response = Http::retry(5, 50000)->get('https://egalite.erpandas.com/api/product-list');
    
        if ($response->failed()) {
            return back()->with('status', 'Product synchronization failed. Please check your connection and retry.');
        }
    
        $products = collect(json_decode($response->body()));
    
        FinalProduction::truncate();
    
        $products->each(function ($product) {
            FinalProduction::create([
                'FinalProductionID' => $product->FinalProductionID,
                'barcode' => $product->barcode,
                'product_code' => $product->product_code,
                'Name' => $product->Name,
                'brand' => $product->brand,
                'UnitPrice' => $product->UnitPrice,
                'production_category' => $product->production_category,
                'activated_branches' => $product->activated_branches,
            ]);
        });
    
        Artisan::call('cache:clear');
        Artisan::call('route:clear');
        Artisan::call('view:clear');
    
        return back()->with('status', 'Products updated successfully');
    }
}
