<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\Branch;
use App\Models\DispatchItem;
use App\Models\Beneficiary;
use Illuminate\Support\Facades\Artisan;
use Storage;

class GeneralController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function AcceptPayment(Request $request)
    {   

        $this->validate($request, [
            'amount' => 'required',
            'phone' => 'required|numeric',
            'network' => 'required'
        ]);

        try {
            
        $branch = empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch');

        $response_ = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/v1/user-branch/" . $branch);
        $branch = json_decode($response_);
        
        if (auth()->user()->sales_person_category == "Delivery" || auth()->user()->sales_person_category == "Drive Thru") {
            if ($branch->tingg_delivery == null) {
                return back()->with('status', "No Counter Code Assigned to Branch");
            }
            $tingg_code = $branch->tingg_delivery;
        }elseif (auth()->user()->sales_person_category == "Counter") {
            if ($branch->tingg_counter == null) {
                return back()->with('status', "No Counter Code Assigned to Branch");
            }
            $tingg_code = $branch->tingg_counter;
        }
        
        $response = Http::post('https://accounts.tingg.africa/api/v1/oauth/token?scope=*&grant_type=password&client_id=instore&username=pizzaman_api_user&password=_f.6e8%3BBt%269kZ%5B%3EwpJ%2AIVW%29J64%2CJuAoS');
        $token = $response->collect();
        $access = $token->toArray();

        $number = "233" . substr($request->phone, 1);

        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => "https://payments.instore.tingg.africa/initiateMerchantPayment",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => "{\n\t\"payerClientCode\": \"$request->network\",\n\t\"amount\": \"$request->amount\",\n\t\"msisdn\": \"$number\",\n\t\"counterCode\": \"$tingg_code\"\n}",
            CURLOPT_HTTPHEADER => array(
                "Authorization: Bearer " . $access['access_token'],
                "cache-control: no-cache",
                "content-type: application/json",
                "currency-code: GHS",
                "postman-token: 291165e9-ca00-23fd-d7f3-905737d28b51",
                "request-origin: TINGG_INSTORE_usSD",
                "x-country-code: GHA"
            ),
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) {
            echo "cURL Error #:" . $err;
            } else {
            $decoded = json_decode($response);
            }
                $curl = curl_init();

                curl_setopt_array($curl, array(
                CURLOPT_URL => "https://payments.instore.tingg.africa/payment/?merchantTransactionID=" . $decoded->data->merchantTransactionID,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    "Authorization: Bearer " . $access['access_token'],
                    "cache-control: no-cache",
                    "postman-token: decc9e11-4688-f388-ec4e-7a5b00f3b238"
                ),
                ));

                $response = curl_exec($curl);
                $err = curl_error($curl);

                curl_close($curl);

                if ($err) {
                echo "cURL Error #:" . $err;
                } else {
                $response . '</br>' . $decoded->data->merchantTransactionID;
                
                }


            return back()->with('status', '<center>'.'Payment Initiated Successfully, Waiting Approval From Customer'.'</center>');
            //code...
        } catch (\Throwable $th) {
            return back()->with('status', 'sorry..Transaction failed, please Try again');
        }

        
    }


    public function getWatiter()
    {

        try {
            // Perform DB Transaction
        \DB::beginTransaction();
        $response_ = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/v1/get-waiter-transaction");
        \DB::commit();
        return view('waiter', [
            'waiter_transactions' => $response_
        ]);

            } catch (\Throwable $th) {
                \DB::rollback();
                $res = response([
                    'status' => 501,
                    "message" => $th
                ]);

                return back()->with('statuspass', "Connection failed, Check your Internet connection");
                
            } 
    }


    public function getWatiterConfirm()
    {

        try {
            // Perform DB Transaction
        \DB::beginTransaction();
        $response_ = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/v1/get-waiter-transaction-confirm");
        \DB::commit();
        return view('waiter', [
            'waiter_transactions' => $response_
        ]);

            } catch (\Throwable $th) {
                \DB::rollback();
                $res = response([
                    'status' => 501,
                    "message" => $th
                ]);

                return back()->with('statuspass', "Connection failed, Check your Internet connection");
                
            } 
    }


    public function ConfrimWaiter($id)
    {
        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        $response_ = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/v1/confirm-payment/" . auth()->id() . "/" . $id);

        \DB::commit();
        return back()->with('status', 'Payment confirmed successfully');

        } catch (\Throwable $th) {
            \DB::rollback();
            $res = response([
                'status' => 501,
                "message" => $th
            ]);

            return back()->with('statuspass', "Connection failed, Check your Internet connection");
            
        } 
        
    }


    public function checkPaymentStatus()
    {

        $response = Http::post('https://accounts.tingg.africa/api/v1/oauth/token?scope=*&grant_type=password&client_id=instore&username=pizzaman_api_user&password=_f.6e8%3BBt%269kZ%5B%3EwpJ%2AIVW%29J64%2CJuAoS');
        $token = $response->collect();
        $access = $token->toArray();

        $curl = curl_init();

                curl_setopt_array($curl, array(
                CURLOPT_URL => "https://payments.instore.tingg.africa/payment/?merchantTransactionID=12135",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    "Authorization: Bearer " . $access['access_token'],
                    "cache-control: no-cache",
                    "postman-token: decc9e11-4688-f388-ec4e-7a5b00f3b238"
                ),
                ));

                $response = curl_exec($curl);
                $err = curl_error($curl);

                curl_close($curl);

                if ($err) {
                echo "cURL Error #:" . $err;
                } else {
                echo $response;
                
                }
    }


    public function location()
    {
        try {
        DispatchItem::query()->truncate();
        $response_ = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/locations");

        foreach (json_decode($response_) as $key => $location) {
        DispatchItem::updateOrCreate([
                'id' => $location->id
            ], [
                'location_name' => $location -> location_name,
                'location_branch' => $location -> location_branch,
                'location_price' => $location -> location_price,
                'category' => $location -> category,
            ]);
        }

        Artisan::call('view:clear');
        Artisan::call('cache:clear');

        return back()->with('status', "Delivery locations syncronised successfully");
         
        } catch (\Throwable $th) {
            return back()->with('status','Location syncronisation faild, please check connection and retry');
        }
    }

    public function branches()
    {
        try {
        Branch::query()->truncate();
        $response_ = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/branches");

        foreach (json_decode($response_) as $key => $branch) {
            Branch::updateOrCreate([
                'id' => $branch->id
            ], [
                'branch_name' => $branch->branch_name
            ]);
        }

        Artisan::call('view:clear');
        Artisan::call('cache:clear');

        return back()->with('status', "Outlets syncronised successfully");
        } catch (\Throwable $th) {
            return back()->with('status','Outlets syncronisation faild, please check connection and retry');
        }
        
    }


    public function Switch(Request $request)
    {   
        $request->session()->put('switch_branch', $request->branch);
        return back()->with('status', 'BRANCH SWITCHED TO ' . $request->branch);
    }


    public function getPriceLocation($id)
    {   
       $price = \DB::table('dispatch_items')->where('id', $id)->first();
       return $results = $price -> location_price;
    }



    public function ProcessingTransactions(Request $request)
    {   
        // getDay close
        $getDayClose = \DB::table('close_days')->first();

        if (auth()->user()->role == "Call Center") {
            $process = \DB::table('dispatches')
            ->select('dispatches.order_number', 'dispatches.ordered_at', 'dispatches.customer_phone','dispatches.amount', 'dispatches.deliveryamount', 'dispatches.order_number', 'dispatches.dispatched_at', 'dispatches.dispatch_branch', 'riders.rd_name','riders.rd_phone')
            ->join('riders', 'dispatches.rider_id','riders.id')
            ->where('dispatches.status', 1)
            ->where('dispatches.dispatch_status', 0)
            ->whereDate('dispatches.created_at', $getDayClose->day_close)
            ->get();
        }else {
            $process = \DB::table('dispatches')
            ->select('dispatches.order_number', 'dispatches.ordered_at', 'dispatches.customer_phone','dispatches.amount', 'dispatches.deliveryamount', 'dispatches.order_number', 'dispatches.dispatched_at', 'dispatches.dispatch_branch', 'riders.rd_name','riders.rd_phone')
            ->join('riders', 'dispatches.rider_id','riders.id')
            ->where('dispatches.status', 1)
            ->where('dispatches.dispatch_status', 0)
            ->whereDate('dispatches.created_at', $getDayClose->day_close)
            ->where('dispatches.dispatch_branch',empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch'))
            ->get();
        }

        return view('processing', [
            'process' => $process
        ]);
    }



    public function loadUtility()
    {
        try {

            // Beneficciarys
            Beneficiary::query()->truncate();
            $onhouse = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/v1/on-house/beneficiaries");
    
            foreach (json_decode($onhouse) as $key => $onhouse) {
                Beneficiary::updateOrCreate([
                    'id' => $onhouse->id
                ], [
                    'name' => $onhouse->name,
                    'phone' => $onhouse->phone
                ]);
            }
    
            Artisan::call('view:clear');
            Artisan::call('cache:clear');
    
            return back()->with('status', "Utilities syncronised successfully");
            } catch (\Throwable $th) {
                return back()->with('status','Utilities syncronisation faild, please check connection and retry');
            }

    }




public function updaateSystem()
    {   

        try {
            // Perform DB Transaction
            \DB::beginTransaction();
            if (auth()->user()->role == "Call Center") {
                $url = 'https://egalite.erpandas.com/uploads/callupdates.zip';
            }else {
                $url = 'https://egalite.erpandas.com/uploads/updates.zip';
            }
            

            $contents = file_get_contents($url);
            $name = substr($url, strrpos($url, '/') + 1);
            Storage::put($name, $contents);
        
            if (auth()->user()->role == "Call Center") {
                $appfile = 'callupdates.zip';
            }else {
                $appfile = 'updates.zip';
            }

            $path = Storage::path($appfile);
            $zip = new \ZipArchive();
            $res = $zip->open($path);
            if ($res === TRUE) {

                $storageDestinationPath = base_path();
            
                    if (!\File::exists( $storageDestinationPath)) {
                        \File::makeDirectory($storageDestinationPath, 0755, true);
                    }
                    $zip->extractTo($storageDestinationPath);
                    $zip->close();

                    Artisan::call('view:clear');
                    Artisan::call('cache:clear');
                    Artisan::call('migrate');

                    \DB::commit();
                    return back()->with('status', 'Software Updated Successfully');

                }else {
                    return back()->with('status', 'System is up to date!');
                }

            } catch (\Throwable $th) {
                \DB::rollback();
                throw new RuntimeException('Failed to extract the ZIP archive.');
            } 
    }


    public function saveBeneficiary()
    {

        if (empty(session()->get('invoice_number'))) {
            $generateInvoice = substr(empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch'), 0,3) . "DEL-". rand(5034580,10034580)+rand(534580,10034580) . date("Yd") . date('Hi');
            session()->put('invoice_number', $generateInvoice);
        }
        $data = [
            'name' => request('name'),
            'comment' => request('comment'),
            'invoice_number' => session()->get('invoice_number'),
            'user_id' => auth()->user()->id
        ];

        $url = "https://egalite.erpandas.com/api/v1/save-onhouse-beneficiary";

        $response = Http::retry(3, 2000)->post($url, $data);

        return $response;
    }


}
