<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $orders = \DB::table('order_transactions')
        ->whereDate('created_at', \Carbon\carbon::today())
        ->where('user_id', auth()->id())
        ->orderBy('id', 'DESC')
        ->paginate(10);
        return view('home', [
            'orders' => $orders
        ]);
    }
}
