<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\FinalProduction;
use App\Models\OrderTransaction;
use App\Models\Customer;
use App\Models\Invoice;
use Session;
use Illuminate\Support\Facades\Cache;

class InvoiceController extends Controller
{


    public function __construct()
    {
        $this->middleware('auth');
    }


    public function index()
    {
        $products = Cache::rememberForever('products', function () {
            return \DB::table('final_productions')->get();
        });
        
        $view = (auth()->user()->role === 'Call Center') ? 'customer-details' : 'create-invoice';
        
        return view($view, compact('products'));
    }


    public function barcodeAddCart(Request $request, $barcode)
    {
         // get name of Item from ID
         $item = \DB::table('final_productions')->where('barcode', 'like', '%' . $barcode . '%')
         ->orWhere('product_code', 'like', '%' . $barcode . '%')
         ->first();

         if (empty($item)) {
             return "empty";
         }
        
         // validate the cost
         $new_item = (float)$item->UnitPrice;
         $total = $item->UnitPrice*1;
         $agency_tota1 = round((1.1 * $item->UnitPrice)) * 1;
         $id = $item->FinalProductionID;
         // End Validate
           
         $cart = $request->session()->get('cart', []);
         if(isset($cart[$id])) {
             $cart[$id]['invoice_quantity']++;
             $cart[$id]['invoice_total_price'] = ($cart[$id]['invoice_quantity'])*$cart[$id]['invoice_unit_price'];
         } else {
             $cart[$id] = [
                 'id' => $id,
                 'user_id' => auth()->user()->id,
                 "branch" => auth()->user()->branch,
                 "customer_id" =>  empty($request -> customer_id) ? 1 :$request -> customer_id,
                 "invoice_product_name" => $item -> Name,
                 "invoice_status" => 1,
                 "invoice_sales_person_category" => auth()->user()->sales_person_category,
                 "invoice_quantity"=> 1,
                 "invoice_unit_price" =>!empty($request ->agency) ?  round((1.1 * $item->UnitPrice)) : $item->UnitPrice,
                 "agency"=> $request ->agency,
                 "invoice_total_price"=> !empty($request ->agency) ? (float)$agency_tota1 : (float)$total,
                 "item_category"=> $item->production_category,
                 ];
         }
           
         $request->session()->put('cart', $cart);
         return $request->session()->get('cart');
    }


    public function customerSale($customer_contact)
    {
        // load Products
        if (empty(Cache::get('products'))) {
            Cache::put('products', \DB::table('final_productions')->get());
        }

        session()->put('customer_contact', $customer_contact);

        $products = Cache::get('products'); 
        
        return view('customer-details-loyality', [
            'products' => $products,
        ]);
    }


    public function returnedCustomer($id, Request $request)
        {
            // Load products from cache or database
            $products = Cache::rememberForever('products', function () {
                return \DB::table('final_productions')->get();
            });

            // Load customer from cache or database
                $customer = Customer::find($id);

                // Store customer details in session
                $request->session()->put([
                    'customer_contact' => $customer->customer_contact,
                    'customer_name' => $customer->customer_name,
                ]);

            // Return view with products and customer data
            return view('customer-details-loyality', compact('products', 'customer'));
        }


   
    public function addCart(Request $request)
    {
        $this->validate($request, [
            'invoice_quantity' => ['required']
        ]);
        // get name of Item from ID
        $item = \DB::table('final_productions')->where('FinalProductionID', $request -> invoice_product_name)->first();
        
        // validate the cost
        $new_item = $item->UnitPrice;
        $total = $item->UnitPrice*$request -> invoice_quantity;
        $agency_tota1 = $item->UnitPrice*$request -> invoice_quantity;
        // $agency_tota1 = round((1.1 * $item->UnitPrice)) * $request -> invoice_quantity;
        $id = $request -> invoice_product_name;
        // End Validate
          
        $cart = $request->session()->get('cart', []);
        if(isset($cart[$id])) {
            $cart[$id]['invoice_quantity'] = $cart[$id]['invoice_quantity'] + $request -> invoice_quantity;
            $cart[$id]['invoice_total_price'] = $cart[$id]['invoice_quantity']*$cart[$id]['invoice_unit_price'];
        } else {
            $cart[$id] = [
                'id' => $id,
                'user_id' => auth()->user()->id,
                "branch" => empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch'),
                "customer_id" => empty($request -> customer_id) ? 1 : $request -> customer_id,
                "invoice_product_name" => $item -> Name,
                "invoice_status" => $request -> status,
                "invoice_sales_person_category" => auth()->user()->sales_person_category,
                "invoice_quantity"=>$request -> invoice_quantity,
                "invoice_unit_price" =>!empty($request ->agency) ?  $item->UnitPrice : $item->UnitPrice,
                "agency"=> $request ->agency,
                "invoice_total_price"=> !empty($request ->agency) ? $agency_tota1 : $total,
                "item_category"=> $item->production_category,
                ];
        }
          
        $request->session()->put('cart', $cart);
        return $request->session()->get('cart');
    }


    public function destroy(Request $request)
    {   
        $request->session()->forget([
            'cart','invoice_number', 'discount','customer_name','customer_address','customer_contact', 'cartcall', 'loyalty','loyality_point'
        ]);
        return back();
    }


    public function IncreaseCart(Request $request, $id, $quantity)
    {

    // $product = \DB::table('final_productions')->where('FinalProductionID', $id)->first();
    // When Add to cart is clicked
    // Get appropriate values and set
    $cart = $request->session()->get('cart', []);
    if(isset($cart[$id])) {
        $cart[$id]['invoice_quantity']++;
        $cart[$id]['invoice_total_price'] = $cart[$id]['invoice_quantity']*$cart[$id]['invoice_unit_price'];
    }

    $request->session()->put('cart', $cart);

        return response([
            'status' => 200,
            'message' => "success"
            ]);
    }


    public function DecreaseCart(Request $request, $id, $quantity)
    {
    
    if ($quantity <= 0) {
        abort(419, "Quantity cannot be less than 1");
    }
    // When Add to cart is clicked
    // Get appropriate values and set
    $cart = $request->session()->get('cart', []);
    if(isset($cart[$id])) {
        if ($cart[$id]['invoice_quantity'] <= 1) {
            abort(419, "Quantity cannot be less than 1");
        }
        $cart[$id]['invoice_quantity']--;
        $cart[$id]['invoice_total_price'] = $cart[$id]['invoice_quantity']*$cart[$id]['invoice_unit_price'];
    }

    $request->session()->put('cart', $cart);

    return response([
        'status' => 200,
        'message' => "success"
    ]);

    }
    


    public function InvoiceDumpDestroy($id)
        {
            $cart = session()->get('cart', []);
            if (!isset($cart[$id])) {
                return response([
                    'status' => 400,
                    'Message' => "Item not found in cart"
                ]);
            }
            unset($cart[$id]);
            session()->put('cart', $cart);
            return response([
                'status' => 200,
                'Message' => "Successfully removed from cart"
            ]);
        }


    public function generateInvoicePay(Request $request)
    {   
        
        $this->validate($request, [
            'amount_paid' => 'required',
            'payment_mode' => 'required',
            'waiters' => 'required'
        ]);
    
        try {
            // Start DB Transaction
            \DB::beginTransaction();
    
            // Check if cart is empty
            $cart = session()->get('cart');
            if (empty($cart)) {
                return back()->with('statuspass', 'Cart is empty');
            }
    
            // Generate invoice number
            $branch = empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch');
            $generateInvoice = substr($branch, 0, 3) . rand(5034580, 10034580) + rand(5034580, 10034580) . date('Ymd') . date('Hi');
    
            // Get customer ID
            $customerSearchResponse = Http::get("https://egalite.erpandas.com/api/v1/walk-in-customer");
            $customer_id = $customerSearchResponse['id'];
    
            // Prepare data to send to API
            $data = [
                'customer_id' => $customer_id,
                'branch' => $branch,
                'user_id' => auth()->id(),
                'invoice_number' => $generateInvoice,
                'discount_type' => empty(session()->get('discount')) ? null : session()->get('discount')['type'],
                'discount' => empty(session()->get('discount')) ? null : session()->get('discount')['discount'],
                'sales_person_category' => auth()->user()->sales_person_category,
                'amount_paid' => $request->input('amount_paid'),
                'payment_method' => $request->input('payment_mode'),
                'orders' => $cart,
                'waiter' => $request->input('waiters'),
                'token' => 'Andasv9'
            ];
    
            // Send order to API
            $url = 'https://egalite.erpandas.com/api/v1/submit-order';
            $response = Http::retry(3, 2000)->post($url, $data);
    
            // If there's a discount code, send it to API
            if (session()->get('is_discount_code') == 1) {
                $cele_data = [
                    'discount_code' => session()->get('discount_code'),
                    'invoice_number' => $generateInvoice,
                ];
                $url_celeb = 'https://egalite.erpandas.com/api/v1/submit-discount-code';
                $cele_response = Http::retry(3, 2000)->post($url_celeb, $cele_data);
            }
    
            // Save order to database
            $order = OrderTransaction::create([
                'transaction_number' => $generateInvoice,
                'branch' => $branch,
                'date' => date('Y-m-d'),
                'orders' => json_encode($cart),
                'payment_method' => $request->input('payment_mode'),
                'discount_type' => empty(session()->get('discount')) ? '' : session()->get('discount')['type'],
                'discount' => empty(session()->get('discount')) ? '' : session()->get('discount')['discount'],
                'user_id' => auth()->id(),
            ]);
            

        $request->session()->forget([
            'cart','invoice_number', 'discount','customer_name','customer_address','customer_contact', 'cartcall', 'loyalty','loyality_point','switch_branch', 'is_discount_code', 'discount_code'
        ]);

        \DB::commit();
        return $response;

        } catch (\Throwable $th) {
            \DB::rollback();
            $res = response([
                'status' => 501,
                "message" => $th
            ]);

            return back()->with('statuspass', "Check your Internet connection, Order did not go through........" . '<a href="#" data-bs-toggle="modal" data-bs-target="#generateRe">' . "try again" . '</a>');
            
        } 
    }



    public function locationPrice(Request $request)
    {
        // get name of location from ID
        $item = \DB::table('dispatch_items')->where('id',$request -> location_name)->first();
        $id = $item->id;

        $cart = $request->session()->get('cart', []);
        if(isset($cart[$id])) {
            abort(419, "Cannot be Incremented");
        } else {
            $cart[$id] = [
                    'id' => $id,
                    'user_id' => auth()->user()->id,
                    "branch" => empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch'),
                    "customer_id" => $request -> id,
                    "invoice_product_name" => $item -> location_name,
                    "invoice_status" => "General",
                    "invoice_sales_person_category" => auth()->user()->sales_person_category,
                    "invoice_quantity"=> 1,
                    "invoice_unit_price" => $item -> location_price,
                    "agency"=> $request ->agency,
                    "invoice_total_price"=> $item -> location_price,
                    "item_category"=> "TRANSPORT",
                ];
        }
          
        $request->session()->put('cart', $cart);
        return response([
            'status'=> 1000,
            'Message'=> 'Item Added Successfully'
        ]);
    }



    public function printLastTransaction()
    {
        try {
        $CustomerSearch = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/v1/last-transaction/" . auth()->id());
        return $CustomerSearch;

        } catch (\Throwable $th) {
            return back()->with('status', "Couldn't print your last transaction, please check your connection & try again");
        }
    }


    public function Reprint($invoice_number)
    {
        try {
            $response = Http::retry(1, 2000)->get("https://egalite.erpandas.com/api/v1/reprint/" . $invoice_number);
            return $response;
        } catch (\Throwable $th) {
            return back()->with('status', "Couldn't print recceipt, please check your connection & try again");
        }
    }



    public function generateInvoicePayDelivery(Request $request)
    {   
        $this->validate(request(), [
            'amount_paid' => 'required',
            'payment_mode' => 'required',
            'waiters' => 'required'
        ]);

        if (strlen($request->session()->get('customer_contact')) >10) {
            return back()->with('statuspass', "Customer contact exceeds the maximum limit, Kindly check");
        }
        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        if (empty($request->session()->get('customer_name')) || empty($request->session()->get('customer_contact'))) {
            return back()->with('statuspass', "Oops! something went wrong, Kindly check customer details.. cannot be empty");
        }

        $generateInvoice = substr(empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch'), 0,3) . "DEL-". rand(5034580,10034580)+rand(534580,10034580) . date("Yd") . date('Hi');

        $customer_data = [
            'customer_name' => session()->get('customer_name'),
            'customer_contact' => session()->get('customer_contact'),
            'customer_address' => session()->get('customer_address'),
            'customer_note' => session()->get('customer_note'),
            'api_key' => "PIZZADOrable401",
            'user_id' => auth()->id(),
            'branch' => empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch')
        ];
        $url = "https://egalite.erpandas.com/api/v1/save-new-customer";
        $response = Http::retry(3, 2000)->post($url, $customer_data);
        $customer_id = (string)$response;

        $data = [
            'customer_id' => $customer_id,
            'branch' => empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch'),
            'user_id' => auth()->id(),
            'invoice_number' =>  $generateInvoice,
            'discount_type' => empty(session()->get('discount')) ? NULL : session()->get('discount')['type'],
            'discount' => empty(session()->get('discount')) ? NULL : session()->get('discount')['discount'],
            'sales_person_category' => auth()->user()->sales_person_category,
            'amount_paid' => request('amount_paid'),
            'payment_method' => request('payment_mode'),
            'orders' =>  session()->get('cart'),
            'waiter' => request('waiters'),
            'token' => "Andasv9"
        ];



        $url = "https://egalite.erpandas.com/api/v1/submit-order";
        $response = Http::retry(3, 2000)->post($url, $data);


        if (session()->get('is_discount_code') == 1) {
            $cele_data = [
                 'discount_code' => session()->get('discount_code'),
                 'invoice_number' => $generateInvoice,
            ];
            $url_celeb = "https://egalite.erpandas.com/api/v1/submit-discount-code";
            $cele_response = Http::retry(3, 2000)->post($url_celeb, $cele_data);
         }

        


       $order = OrderTransaction::create([
            'transaction_number' => $generateInvoice,
            'branch' => empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch'),
            'date' => date('Y-m-d'),
            'orders' => json_encode(session()->get('cart')),
            'payment_method' => request('payment_mode'),
            'discount_type' => empty(session()->get('discount')) ? "" : session()->get('discount')['type'],
            'discount' => empty(session()->get('discount')) ? "" : session()->get('discount')['discount'],
            'user_id' => auth()->id(),
        ]);

        $request->session()->forget([
            'invoice_number', 'discount','customer_name','customer_address','customer_contact','customer_note','cart','switch_branch','is_discount_code', 'discount_code'
        ]);

        \DB::commit();

        return $response;

        } catch (\Throwable $th) {
            \DB::rollback();
            $res = response([
                'status' => 501,
                "message" => $th
            ]);
            return back()->with('statuspass', "Oops Something Happend, Timeout, Kindly check your connection");
        
    } 


    }


    public function HoldTransaction(Request $request)
    {

        if (strlen($request->session()->get('customer_contact')) >10) {
            return back()->with('statuspass', "Customer contact exceeds the maximum limit, Kindly check");
        }
        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        if (empty($request->session()->get('customer_name')) || empty($request->session()->get('customer_contact'))) {
            return back()->with('statuspass', "Oops! something went wrong, Kindly check customer details.. cannot be empty");
        }

        $generateInvoice = substr(empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch'), 0,2) . "DEL-". rand(5034580,10034580)+rand(534580,10034580) . date("Yd") . date('Hi');

        $customer_data = [
            'customer_name' => session()->get('customer_name'),
            'customer_contact' => session()->get('customer_contact'),
            'customer_address' => session()->get('customer_address'),
            'customer_note' => session()->get('customer_note'),
            'api_key' => "PIZZADOrable401",
            'user_id' => auth()->id(),
            'branch' => empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch')
        ];
        $url = "https://egalite.erpandas.com/api/v1/save-new-customer";
        $response = Http::retry(3, 2000)->post($url, $customer_data);
        $customer_id = (string)$response;

        $data = [
            'customer_id' => $customer_id,
            'branch' => empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch'),
            'user_id' => auth()->id(),
            'invoice_number' =>  $generateInvoice,
            'discount_type' => empty(session()->get('discount')) ? NULL : session()->get('discount')['type'],
            'discount' => empty(session()->get('discount')) ? NULL : session()->get('discount')['discount'],
            'sales_person_category' => auth()->user()->sales_person_category,
            'amount_paid' => 0,
            'payment_method' => "HOLD",
            'orders' =>  session()->get('cart'),
            'waiter' => request('waiters'),
            'token' => "Andasv9"
        ];



        $url = "https://egalite.erpandas.com/api/v1/submit-order-held";
        $response = Http::retry(3, 2000)->post($url, $data);


        if (session()->get('is_discount_code') == 1) {
            $cele_data = [
                 'discount_code' => session()->get('discount_code'),
                 'invoice_number' => $generateInvoice,
            ];
            $url_celeb = "https://egalite.erpandas.com/api/v1/submit-discount-code";
            $cele_response = Http::retry(3, 2000)->post($url_celeb, $cele_data);
         }

        


       $order = OrderTransaction::create([
            'transaction_number' => $generateInvoice,
            'branch' => empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch'),
            'date' => date('Y-m-d'),
            'orders' => json_encode(session()->get('cart')),
            'payment_method' => "HOLD",
            'discount_type' => empty(session()->get('discount')) ? "" : session()->get('discount')['type'],
            'discount' => empty(session()->get('discount')) ? "" : session()->get('discount')['discount'],
            'user_id' => auth()->id(),
        ]);

        $request->session()->forget([
            'invoice_number', 'discount','customer_name','customer_address','customer_contact','customer_note','cart','switch_branch','is_discount_code', 'discount_code'
        ]);

        \DB::commit();

        return $response;

        } catch (\Throwable $th) {
            \DB::rollback();
            $res = response([
                'status' => 501,
                "message" => $th
            ]);
            return back()->with('statuspass', "Oops Something Happend, Timeout, Kindly check your connection");
        
    } 
    }


    public function SyncSales()
    {
        $orders = \DB::table('invoices')
        ->SelectRaw('branch as branch, invoice_product_name as product_name, sum(invoice_quantity) as qty, sum(invoice_total_price) as cost')
        ->groupBy('invoice_product_name')
        ->groupBy('branch')
        ->whereDate('created_at', \Carbon\carbon::today())
        ->where('invoices_user_id', auth()->id())
        ->get();

        return view('orders-syncroniztion', [
            'orders' => $orders
        ]);
    }



    public function notDisplay(Request $request)
    {
        $request->session()->put('display_screen', 0);
        return session()->get('display_screen');
        return response([
            'status' => 200
        ]);
    }


    public function deliverySale()
    {
        $products = Cache::rememberForever('products', function () {
            return \DB::table('final_productions')->get();
        });
        
        return view('customer-details', compact('products'));
    }


}
