<?php

namespace App\Http\Controllers;

use App\Models\OrderTransaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class OrderTransactionController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->validate(request(), [
            'search' => 'required|max:300'
        ]);

        try {
        $response = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/v1/delivery-orders-call-center/" . request('search'));
        return view('delivery', [
            'dispatchorders' => $response,
        ]);

        } catch (\Throwable $th) {
            return back()->with('status', "Something went wrong, check internet connection");
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\OrderTransaction  $orderTransaction
     * @return \Illuminate\Http\Response
     */
    public function show(OrderTransaction $orderTransaction)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\OrderTransaction  $orderTransaction
     * @return \Illuminate\Http\Response
     */
    public function edit(OrderTransaction $orderTransaction)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\OrderTransaction  $orderTransaction
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, OrderTransaction $orderTransaction)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\OrderTransaction  $orderTransaction
     * @return \Illuminate\Http\Response
     */
    public function destroy(OrderTransaction $orderTransaction)
    {
        //
    }
}
