<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class ReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function report()
    {
        try {
            
        $response = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/v1/report/" . auth()->id());
        $discount = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/v1/report/discount/" . auth()->id());
        $held = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/v1/report-held/" . auth()->id());

        $total = array_sum(array_column(json_decode($response), 'invoice_total_price'));
        return view('reporting', [
            'invoices' => $response,
            'total_sale' => (string)$total,
            'discounting' => (string)$discount,
            'HeldTransactions' =>  (string)$held
        ]);

        } catch (\Throwable $th) {
            return back()->with('status', 'failed to show report, Kindly check your internet connection');
        }
    }
}
