@extends('layouts.app')

@section('content')

<!-- Breadcrumb container start -->
<div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
<nav aria-label="breadcrumb">
<ol class="breadcrumb">
<li class="breadcrumb-item"><a href="/">Home</a></li>
<li class="breadcrumb-item"><a href="#">Active Outlet</a></li>
<li class="breadcrumb-item active" aria-current="page">{{empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch')}}</li>
</ol>
</nav>
</div>
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
    <input type="text" hidden value="{{empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch')}}" id="branch">
        <!-- Card start -->
        <div class="card">
            <div class="card-header-lg">
                <h4>Create Invoice</h4>
                <div class="text-end">
                    <a href="#" data-bs-toggle="modal" data-bs-target="{{auth()->user()->role == "Call Center" ? '#switchModal' : ''}}" style="text-decoration:underline" class="text-primary">SWITCH {{empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch')}}</a>
                </div>
            </div>
            <div class="card-body">

                <!-- Row start -->
                <div class="row justify-content-between">

                    <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">

                        <!-- Row start -->
                        <div class="row gutters">

                            <div class="col-12">
                                <div class="form-section-header light-bg">Customer Details</div>
                            </div>
                            <div class="col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <input class="form-control" autocomplete="off" type="text" placeholder="Customer Name" value="{{!empty(session()->get('customer_name')) ? session()->get('customer_name') : ''}}" id="CustomerName" onChange="CustomerName()" required>
                                    <div class="field-placeholder">Customer Name <span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>
                            <div class="col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <textarea class="form-control" rows="3" autocomplete="off" placeholder="Customer Address" id="CustomerAddress" onChange="CustomerAddress()"  onChange="CustomerAddress()">{{!empty(session()->get('customer_address')) ? session()->get('customer_address') : ''}}</textarea>
                                    <div class="field-placeholder">Address</div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>

                            <div class="col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <input class="form-control" autocomplete="off" value="{{!empty(session()->get('customer_phone')) ? session()->get('customer_phone') : ''}}" id="CustomerContact" onChange="CustomerContact()" name="customer_phone"  placeholder="0123456789"  type="number">
                                    <div class="field-placeholder">Phone <span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>

                        </div>
                        <!-- Row end -->

                    </div>
                    <div class="col-xl-5 col-lg-5 col-md-7 col-sm-7 col-12">
                    <form id="newinvoice">
                        @csrf
                        <!-- Row start -->
                        <div class="row gutters">

                            <div class="col-12">
                                <div class="form-section-header light-bg">Product Info</div>
                            </div>
                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                <select name="invoice_product_name" class="select-single js-states" title="Select Product Category" id="ddlViewBy" data-live-search="true">
                                    <option selected disabled> - Select Item -</option>
                                    @foreach($products as $product)
                                            <option value="{{$product->FinalProductionID}}" 
                                            <?php
                                                if (empty($product->activated_branches)) {
                                                    echo '';
                                                }else {
                                                    echo in_array(auth()->user()->branch, json_decode($product->activated_branches)) == true ? 'disabled' : '';
                                                }
                                                ?>>
                                                [{{empty($app->currency) ? "GHS" : $app->currency}}{!!@strtoupper($product->UnitPrice)!!}]  {!!@strtoupper($product->Name)!!} {{$product->barcode}}
                                            </option>
                                    @endforeach
                                    </select>
                                    <div class="field-placeholder">Product Name<span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>
                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <input type="text" class="form-control" value="1" id="quantity" name="invoice_quantity" onKeyUp="calculateTotal()">
                                    <div class="field-placeholder">Quantity</div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>

                            <div class="col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <textarea class="form-control" autocomplete="off" onchange="editNote()" rows="3"placeholder="Add Note" id="noteText">{{!empty(session()->get('customer_note')) ? session()->get('customer_note') : ''}}</textarea>
                                    <div class="field-placeholder">Notes</div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>

                            <div class="col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                @if(auth()->user()->sales_person_category == "Delivery")
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <button class="btn btn-outline-primary "><i class="icon-shopping-cart1" aria-hidden="true"></i> Add to Cart</button> 
                                        <button class="btn btn-outline-info" style="margin-left:30px" onclick="getDeliveryValue()" type="button" data-bs-toggle="modal" data-bs-target="#exampleModalExtraLarge">
                                        <i class="icon-directions_car" aria-hidden="true"></i> Dispatch Fee</button>
                                    </div>
                                    @else
                                    @if(auth()->user()->role == "Sales_Person")
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <button class="btn btn-outline-primary "><i class="icon-shopping-cart1" aria-hidden="true"></i> Add to Cart</button> 
                                    </div>
                                    @else
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <button class="btn btn-outline-primary "><i class="icon-shopping-cart1" aria-hidden="true"></i> Add to Cart</button> 
                                        <button class="btn btn-outline-info" onclick="getDeliveryValue()" type="button" data-bs-toggle="modal" data-bs-target="#exampleModalExtraLarge">
                                        <i class="icon-directions_car" aria-hidden="true"></i> Dispatch Fee</button>
                                    </div>
                                    
                                        @endif
                                    @endif   
                                </div>
                                <!-- Field wrapper end -->
                            </div>
                            
                           
                            
                        </form>
                        </div>
                        <!-- Row end -->

                    </div>

                </div>
                <!-- Row end -->

                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-12">
                    <div id="tabler">
                    @if(empty($checkseesion))
                        <!-- Card start -->
                        <div class="card">
                            <div class="card-body">
                                <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                No Item added to cart. Kindly select Item and add to cart {{auth()->user()->sales_person_category == "Counter" ? "or use Barcode" : ""}}
                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                <a href="{{route('printLastTransaction')}}" style="color:#ffffff;">Print Last Transaction</a><span class="visually-hidden">Loading...</span>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            </div>
                        </div>
                        <!-- Card end -->
                        @else 
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th colspan="7" class="pt-3 pb-3">Invoice Details</th>
                                    </tr>
                                    <tr>
                                        <th>Product</th>
                                        <th>Quantity</th>
                                        <th>Unit</th>
                                        <th>Price</th>
                                        <th>Category</th>
                                        <th>Amount (Net)</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach($cartItems as $key => $cart)
                                    <tr>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <select class="select-single js-states w-100" data-live-search="true">
                                                    <option>{!!@strtoupper($cart['invoice_product_name'])!!}</option>
                                                </select>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                        <div class="d-flex mb-4" style="max-width: 300px">
                                                <button class="btn btn-light btn-sm" id="{{$cart['id']}}" onclick="decrease(id)">
                                                <i class="icon-minus"></i>
                                                </button>
                            
                                                <div class="form-outline">
                                                <input min="1" readonly type="number" id="qty{{$cart['id']}}" id="qty{{$cart['id']}}" value="{{$cart['invoice_quantity']}}" name="quantity"  class="form-control" />
                                                </div>
                            
                                                <button class="btn btn-light btn-sm" id="{{$cart['id']}}" onclick="increase(id)">
                                                <i class="icon-plus1"></i>
                                                </button>
                                        </div>
                                        <!-- Quantity -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="text" readonly class="form-control" value="PCS">
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="text" readonly class="form-control" value="@convert($cart['invoice_unit_price'])" id="ItemPrice{{$cart['id']}}">
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <div class="input-group">
                                                    <input type="text" value="{{@strtoupper($cart['item_category'])}}" class="form-control" readonly>
                                                </div>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <div class="input-group">
                                                <input type="text" id="demo{{$cart['id']}}" readonly class="form-control" value="{{empty($app->currency) ? "GHS" : $app->currency}}@convert($cart['invoice_unit_price'] * $cart['invoice_quantity'])">
                                                </div>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <div class="table-actions">
                                            <button class="btn btn-light" id="{{$cart['id']}}" onClick="DeleteItem(this.id)">
                                                <i class="icon-trash-2"></i>
                                            </button>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                    <tr>
                                        <td>
                                        </td>
                                        <td colspan="6">
                                            <div class="row gutters justify-content-end">
                                                <div class="col-auto">
                                                    <label class="col-form-label">Discount % of Total Amount</label>
                                                </div>
                                                <div class="col-auto" style="max-width: 90px;">
                                                <button type="button" class="btn btn-primary mb-2" data-bs-toggle="modal" data-bs-target="#exampleModalSmall">
                                                Add %  
                                                </button>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="4">&nbsp;</td>
                                        <td colspan="2">
                                        <p class="m-0">Subtotal</p>
                                        <p class="m-0">Discount</p>
                                        <p class="m-0">VAT</p>
                                        <h5 class="mt-2">Total Amount</h5>
                                        </td>
                                        <td>
                                        <div id="subtotals">
                                        <p class="m-0">@convert(empty($checkseesion) ? 0 : $totalCart)</p>
                                        <p class="m-0" id="discounting">
                                            @if(empty(session()->get('discount')))
                                                    {{empty($app->currency) ? "GHS" : $app->currency}}0.00
                                            @else
                                            @if(session()->get('discount')['type'] == "Cash")
                                                {{ empty($app->currency) ? "GHS" : $app->currency}} {{session()->get('discount')['discount']}}
                                            @elseif(session()->get('discount')['type'] == "Percentage")
                                                {{ session()->get('discount')['discount'] . "%"}}
                                            @endif
                                            @endif
                                        </p>
                                        <p class="m-0">{{empty($app->currency) ? "GHS" : $app->currency}}0.00</p>
                                        @if(empty(session()->get('discount')))
                                        <h5 class="mt-2" id="tcost">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(empty($checkseesion) ? 0 : $totalCart)</h5>
                                        @else
                                        @if(session()->get('discount')['type'] == "Percentage")
                                        <h5 class="mt-2" id="tcost">{{empty($app->currency) ? "GHS" : $app->currency}} @convert( $totalCart * ((100 - session()->get('discount')['discount']))/100)</h5>
                                        @else
                                        <h5 class="mt-2" id="tcost">{{empty($app->currency) ? "GHS" : $app->currency}} @convert( $totalCart - session()->get('discount')['discount'] )</h5>
                                        @endif
                                        @endif
                                        </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        @endif 
                        </div>
                         
                    </div>
                </div>
                <!-- Row end -->

                <!-- Row start -->
                <div class="row gutters">

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="form-actions-footer">
                        <div class="text-end">
                <!-- Discount Button trigger modal -->
                                <button type="button" class="btn btn-outline-success ms-1" data-bs-toggle="modal" data-bs-target="#exampleModalSmallceleb">
                                <i class="icon-gift"></i> Gift Cards
                                </button>
                            <a href="#" class="btn btn-outline-secondary stripes-btn" data-bs-toggle="modal" data-bs-target="#staticBackdropTingging"><i class="icon-attach_money"></i>Online Payment</a>
                            <a href="#" onclick="confirmHold()" class="btn btn-danger ms-1"><i class="icon-pause1"></i> Hold </a> 
                            <a href="#" onclick="confirmCreateNew()" class="btn btn-outline-dark ms-1"><i class="icon-x-circle"></i> Void Invoice</a>                           
                            <a href="#" data-bs-toggle="modal" data-bs-target="#generateRe" class="btn btn-info ms-1"></i>Generate Receipt</a>
                        
                        </div>
                        </div>
                    </div>

                </div>
                <!-- Row end -->

            </div>
        </div>
        <!-- Card end -->
                                              
    </div>
</div>
<!-- Row end -->


     <!-- Tingg Modal -->
     @include('tingg.invoice-payment-modal')

     @include('modal.switch-branch')

     <!-- delivery Modal -->
    @include('inc.delivery')


<!-- Table Modal start -->
<div class="modal fade" id="generateRe" tabindex="-1" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
        @if(session()->get('sales_type') == "CREDIT NOTE")
            <h5 class="modal-title" id="exampleModalLongTitle">Credit Sales</h5>
        @else
            <h5 class="modal-title" id="exampleModalLongTitle">Receive Payment</h5>
        @endif
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <form action="{{route('generateInvoicePayDelivery')}}" id="paymentDel" method="post">
            @csrf            

                <!-- Row start -->
                <div class="row gutters">

                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                    @if(Route::currentRouteName() == "indexAgency")
                        <select class="select-single js-states" name="payment_mode" title="Select Product Category" data-live-search="true">
                           <option value="{{$agencying}}">{{$agencying}}</option>
                        </select>
                    @else
                        <select class="select-single js-states" name="payment_mode" title="Select Product Category" data-live-search="true">
                            <option value="CASH">CASH</option>
                            <option value="MOBILE MONEY">MOBILE MONEY</option>
                            <option value="CREDIT CARD ">CREDIT CARD</option>
                            <option value="JUMIA">JUMIA</option>
                            <option value="BOLT">BOLT</option>
                            <option value="GLOVO">GLOVO</option>
                        </select>
                    @endif
                        <div class="field-placeholder">Payment mode<span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->
                    </div>


                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12" style="display:none">
                        <?php $waiters = \DB::table('users')->where('role', 'Waiter')->get(); ?>
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <select class="select-single js-states" name="waiters" title="Select Product Category" data-live-search="true">
                            @foreach($waiters as $waiter)
                            <option value="{{$waiter->id}}">{{$waiter->name}}</option>
                            @endforeach
                        </select>
                        <div class="field-placeholder">Waiter</div>
                    </div>
                    <!-- Field wrapper end -->
                    </div>

                    @if(Route::currentRouteName() == "indexAgency")
                    <input type="number" step="0.01" min="0" value="0" name="amount_paid" hidden required>
                    @else
                    @if(auth()->user()->sales_person_category == "Delivery")
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <input type="number" step="0.001" min="0" value="0" name="amount_paid" required="">
                            </div>
                            <div class="field-placeholder">Amount received<span class="text-danger">*</span></div>
                        </div>
                        <!-- Field wrapper end -->
                    </div>
                    @else
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <input type="number" step="0.01" min="0" value="" name="amount_paid" required="">
                            </div>
                            <div class="field-placeholder">Amount received<span class="text-danger">*</span></div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                    @endif
                    @endif
                    @if(Route::currentRouteName() !== "indexAgency")
                    @if(session()->get('sales_type') == "CREDIT NOTE")
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <input type="date" name="due_date" required>
                            </div>
                            <div class="field-placeholder">Due Date<span class="text-danger">*</span></div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                    @else
                        <input type="date" name="due_date" hidden value="#" readonly required>
                    @endif

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <input type="text" name="transaction_id">
                            </div>
                            <div class="field-placeholder">Trans. Ref</div>
                            <small class="text-mute" >Enter transaction ID, cheque number, transfer ID or any ID related to payment</small>
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                    
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <textarea name="payment_note"></textarea>
                            </div>
                            <div class="field-placeholder">Payment Note <span class="text-danger"></span></div>
                            
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                    @endif

                    <input type="text" value="" id="displayOption" name="display" hidden>
    
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <button class="btn btn-primary" type="button" onclick="ClosePay()"> <i class="icon-save"></i> Pay</button>
                    </div>
                </div>
                <!-- Row end -->
            </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" id="closebtn" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
    </div>
<!-- Modal end -->


<!-- Modal start -->
<div class="modal fade" id="exampleModalSmall" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog modal-center">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">APPLY COUPON</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="dis">
            <form id="discountAmount">
                @csrf
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                    <select name="type" class="select-single js-states">
                        <option value="Percentage">PERCENTAGE</option>
                        <option value="Cash">CASH</option>
                    </select>
                        <div class="field-placeholder">Type <span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <input class="form-control" type="number" step="0.01" name="discount" required>
                        <div class="field-placeholder">Amount or % <span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>
                
                <button type="submit" class="btn btn-outline-primary">Apply</button>
            </form>
           
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" id="cancelCoupon">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->

<!-- Modal start -->
<div class="modal fade" id="exampleModalSmallceleb" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">COUPON CODE OR GIFT CARD</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="disinf" >
           
            <form id="discountAmountCoupon">
                @csrf
                <input type="text" name="type" value="Percentage" hidden>
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <input  type="text" name="submit_celeb" hidden value="Apply Code">

												
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <input class="form-control" placeholder="Coupon Code Or Scan Gift Card" type="text" autocomplete="off" name="discount_code">
                        <div class="field-placeholder">Coupon code<span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>
                <input  type="submit" name="submit_celeb" id="" value="Apply Code" class="btn btn-outline-primary">
            </form>
            
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" id="cancelgift" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->



<script>
    
    $("#newinvoice").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('InvoiceDump')}}",
                dataType: "json",
                data: $('#newinvoice').serialize(),
                success: function(data){
                    document.getElementById('quantity').value = "1";
                    // RELOAD TABLE
                    $("#tabler").load(" #tabler");

                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Item Added to Cart, add new Item'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });



            
    $("#discountAmount").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('OrderDiscount')}}",
                dataType: "json",
                data: $('#discountAmount').serialize(),
                success: function(data){
                    $("#subtotals").load(" #subtotals");
                    document.getElementById('cancelCoupon').click();
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'bottom-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Discount Applied to Order'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });

        $("#discountAmountCoupon").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('OrderDiscount')}}",
                dataType: "json",
                data: $('#discountAmountCoupon').serialize(),
                success: function(data){
                    $("#subtotals").load(" #subtotals");
                    document.getElementById('cancelgift').click();
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'bottom-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Discount Applied to Order'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong! Mismatch Coupon Code or Gift Card',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });




        function DeleteItem(id) {
            // $('.trhidden'+id).hide();
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                $("#tabler").load(" #tabler");
            }
            xhttp.open("GET", "/ceqafoods/delete-item/"+id);
            xhttp.send();
            
        }

        function increase(id) {
            document.getElementById('qty'+ id).stepUp()
            var quantity = document.getElementById('qty'+ id).value;
            var price = document.getElementById('ItemPrice'+ id).value;
            // var quantity = (++quantity)
            document.getElementById('demo'+ id).value = quantity * price;

            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {

                $("#subtotals").load(" #subtotals");

            }
            xhttp.open("GET", "/increase-cart/"+id + "/" + quantity);
            xhttp.send();
        }


        function decrease(id) {
            document.getElementById('qty'+ id).stepDown()
            var quantity = document.getElementById('qty'+ id).value;
            var price = document.getElementById('ItemPrice'+ id).value;
            // var quantity = (++quantity)
            document.getElementById('demo'+ id).value = quantity * price;

            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {

                $("#subtotals").load(" #subtotals");

            }
            xhttp.open("GET", "/decrease-cart/"+id + "/" + quantity);
            xhttp.send();
        }

        
        function calculateTotal() {
            quantity = document.getElementById("quantity").value;
            price = document.getElementById("price").value;
            // document.getElementById("result").innerHTML = num1 * num2;
            document.getElementById("total").value = quantity*price;
        }


        function getValue() {
            var invoiceinput = document.getElementById("myInput").value;
            var e = document.getElementById("getStatus");
            if (e.value === "On The House") {
                $('#onthehouse').modal('show')
                document.getElementById("inv").value = invoiceinput
            }else{
                console.log("error")
            }
        }


        function getDeliveryValue() {
            var invoiceinput = document.getElementById("myInput").value;
            document.getElementById("delivery_id").value = invoiceinput
        }

        function confirmCreateNew() {
            Swal.fire({
                title: 'Are you sure?',
                text: "Are you sure you want to void transaction?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, void invoice!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{route('deleteDump')}}";
                }
                })
        }

        function CustomerName(){
            var name = document.getElementById('CustomerName').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
             
            }
            xhttp.open("GET", "/customer-name/"+name);
            xhttp.send();
        }

        function CustomerAddress(){
            var address = document.getElementById('CustomerAddress').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
             
            }
            xhttp.open("GET", "/customer-address/"+address);
            xhttp.send();
        }

        function CustomerContact(){
            var contact = document.getElementById('CustomerContact').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
             
            }
            xhttp.open("GET", "/customer-contact/"+contact);
            xhttp.send();
        }

        function editNote() {
            var note = document.getElementById('noteText').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
             
            }
            xhttp.open("GET", "/customer-note/" + note);
            xhttp.send();
        }


        function ClosePay() {
            document.getElementById('displayOption').value = 2;
            var closeClick = document.getElementById('closebtn');
            var branch =  document.getElementById('branch').value;
            closeClick.click();
            Swal.fire({
                title: 'Create a Sale, Are you sure?' + branch,
                text: "by confirming, you are creating a sale and may not be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, pay!'
                }).then((result) => {
                if (result.isConfirmed) {
                    $('#loading-wrapper').show();
                    document.getElementById("paymentDel").submit();
                }
                })
            

        }


        function ClosePayDisplay() {
            var closeClick = document.getElementById('closebtn');
            document.getElementById('displayOption').value = 0;
            var branch =  document.getElementById('branch').value;
            closeClick.click();
            Swal.fire({
                title: 'Create a Sale, Are you sure?' + branch,
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, save and print receipt!'
                }).then((result) => {
                if (result.isConfirmed) {
                    $('#loading-wrapper').show();
                    document.getElementById("paymentDel").submit();
                }
                })

        }



        function confirmHold() {
            Swal.fire({
                title: 'Are you sure?',
                text: "Are you sure you want to temporarily suspend the transaction and keep the items or services selected on hold?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Hold!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{route('HoldTransaction')}}";
                }
                })
        }

</script>

@endsection