

@extends('layouts.app')

@section('content')


<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
    
        <!-- Search results start -->
        <div class="search-results-container">
        <form action="{{route('searchCustomer')}}" method="get">
            <!-- Row start -->
            <div class="row justify-content-end">
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <div class="input-group">														
                            <input type="text" class="form-control" placeholder="Search loyal customer here" name="customer">
                            <button class="btn btn-primary" type="submit">Search</button>
                        </div>
                        <div class="field-placeholder">Customer</div>
                    </div>
                    <!-- Field wrapper end -->
                </div>
            </div>
            <!-- Row end -->
            </form>
            <div class="search-results-header">
                <div class="search-results-title">Results: <span>{{request('customer')}}</span></div>
            </div>
            <div class="search-results-body">

            <div class="table-responsive">
                <table id="copy-print-scroll" class="table v-middle">
                    <thead>
                        <tr>
                            <th>Customer</th>
                            <th>Points</th>
                            <th></th>													  
                        </tr>
                    </thead>
                    <tbody>
                    @foreach(json_decode($customer) as $customer_loyalty)
                    @if($customer_loyalty->customer_name == "WALK-IN CUSTOMER")
                        @continue
                    @endif
                        <?php $Ly = \DB::table('loyalty_points')->where('customer_id', $customer_loyalty->id)->first();
                            $balance_transaction = 
                            \DB::table('loyalty_points')->where('customer_id', $customer_loyalty->id)->sum('increase') -
                            \DB::table('loyalty_points')->where('customer_id', $customer_loyalty->id)->sum('decrease');
                        ?>
                        <tr>
                            <td>
                            <div class="media-box">
                                <img src="/img/user15.png" class="media-avatar" alt="User">
                                <div class="media-box-body">
                                    <a href="#" class="text-truncate">{{$customer_loyalty-> customer_name}}</a>
                                    <p>{{$customer_loyalty->created_at}}</p>
                                </div>
                            </div>
                            </td>
                            <td>
                            <div class="media-box">
                                <div class="media-box-body">
                                    <a href="#" class="text-truncate"><a class="btn btn-outline-primary btn-sm" href="{{route('redeem', $customer_loyalty->id)}}"> <i class="icon-gift"></i> Redeem Points @convert(empty($balance_transaction) ? 0 : $balance_transaction)</a></a>
                                    <p>L-CODE: #{{$customer_loyalty->customer_phone}}</p>
                                    <div class="rating-block">
                                            <div class="rate2"></div>
                                        </div>
                                </div>
                            </div>
                            </td>
                            <td><p class="desc">Last transaction for this customer was at <span class="text-primary">{{$customer_loyalty-> customer_branch}}</span>, entered by <span class="text-primary">{{$customer_loyalty-> customer_enteredby}}</span></p> </td>
                        </tr>
                        @endforeach
                    </tbody>    
            </table>
            </div>
            </div>
        </div>
        <!-- Search results end -->

    </div>
</div>
<!-- Row end -->


@endsection