@extends('layouts.app')

@section('content')

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-attach_money"></i>
            </div>
            <div class="sale-details">
                <h2>GHS @convert($total_sale)</h2>
                <p>Net Sales</p>
                <h5><span class="high"><i class="icon-trending-up"></i> 7.2%</span> since last week</h5>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-shopping-bag1"></i>
            </div>
            <div class="sale-details">
                <h2>{{count(json_decode($invoices))}}</h2>
                <p>Products</p>
                <h5><span class="high"><i class="icon-trending-up"></i> 7.5%</span> since last week</h5>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-briefcase"></i>
            </div>
            <div class="sale-details">
                <h2>995</h2>
                <p>Discounts</p>
                <h5><span class="low"><i class="icon-trending-down"></i> 5.7%</span> since last week</h5>
            </div>
        </div>
    </div>							
</div>
<!-- Row end -->

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <div class="card">
            <div class="card-body">
                
                <div class="table-responsive">
                <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                                <th>Transaction ID</th>
                                <th>Outlet</th>
                                <th>Date</th>													  
                                <th>Payment Method</th>	
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($orders as $order)
                            <tr>
                                <td>
                                <div class="media-box">
                                    <img src="img/products/bag.jpg" class="media-avatar" alt="Product">
                                    <div class="media-box-body">
                                        <a href="#" class="text-truncate">{{$order->transaction_number}}</a>
                                    </div>
                                </div>
                                </td>
                                <td>{{$order->branch}}</td>
                                <td>{{$order->created_at}}</td>													  
                                <td>{{$order->payment_method}}</td>
                                <td>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </table>
                </div>

            </div>
        </div>

    </div>
</div>
<!-- Row end -->


@endsection
