@extends('layouts.app')

@section('content')

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-attach_money"></i>
            </div>
            <div class="sale-details">
                <h2>GHS{{$total_sale - $discounting}}</h2>
                <p>Net Sales</p>
                <h5><span class="high"><i class="icon-trending-up"></i> {{count(json_decode($invoices))}}</span> Products Sold</h5>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-shopping-bag1"></i>
            </div>
            <div class="sale-details">
                <h2>GHS{{array_sum(array_column(json_decode($HeldTransactions), 'invoice_total_price'))}} </h2>
                <p>Held Transactions</p>
                <h5><span class="high"><i class="icon-trending-up"></i> 7.5%</span> since last week</h5>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-briefcase"></i>
            </div>
            <div class="sale-details">
                <h2>GHS{{$discounting}}</h2>
                <p>Discount</p>
                <h5><span class="high"><i class="icon-trending-up"></i> 7.7%</span> since last week</h5>
            </div>
        </div>
    </div>							
</div>
<!-- Row end -->

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <div class="card">
            <div class="card-body">


            <ul class="nav nav-tabs" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <a class="nav-link active" id="first-tab" data-bs-toggle="tab" href="#first" role="tab" aria-controls="first" aria-selected="true"> Orders</a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link" id="second-tab" data-bs-toggle="tab" href="#second" role="tab" aria-controls="second" aria-selected="false">Held Transactions</a>
                </li>
            </ul>
            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="first" role="tabpanel">

                <div class="table-responsive" style="margin-top:20px">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                                <th>OrderId</th>
                                <th>Created at</th>
                                <th>Product</th>
                                <th>Outlet</th>													  
                                <th>Rate</th>													  
                                <th>Qty</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach(json_decode($invoices) as $invoices)
                            <tr>
                                <td>
                                <div class="media-box">
                                    <div class="media-box-body">
                                        <a href="#" class="text-truncate">{{ $invoices->invoice_number}}</a>
                                    </div>
                                </div>
                                </td>
                                <td>{{$invoices->created_at}}</td>											  
                                <td>{{@strtoupper($invoices->invoice_product_name)}}</td>
                                <td>{{$invoices->branch}}</td>													  
                                <td>@convert($invoices->invoice_unit_price)</td>
                                <td>@convert($invoices->invoice_quantity)</td>
                                <td>@convert($invoices->invoice_total_price)</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                </div>
                <div class="tab-pane fade" id="second" role="tabpanel">
                    
                    <div style="margin-top:150px;margin-bottom:150px">
                        <center><button class="btn btn-primary">Load Held Transactions</button></center>
                    </div>

                </div>
    
            </div>
        </div>
                
                

            </div>
        </div>

    </div>
</div>
<!-- Row end -->


@endsection
