@extends('layouts.app')

@section('content')

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-attach_money"></i>
            </div>
            <div class="sale-details">
                <h2>GHS @convert($total_sale)</h2>
                <p>Net Sales</p>
                <h5><span class="high"><i class="icon-trending-up"></i> 7.2%</span> since last week</h5>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-shopping-bag1"></i>
            </div>
            <div class="sale-details">
                <h2>{{count(json_decode($invoices))}}</h2>
                <p>Products</p>
                <h5><span class="high"><i class="icon-trending-up"></i> 7.5%</span> since last week</h5>
            </div>
        </div>
    </div>
    <!-- <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-briefcase"></i>
            </div>
            <div class="sale-details">
                <h2>995</h2>
                <p>Revenue</p>
                <h5><span class="low"><i class="icon-trending-down"></i> 5.7%</span> since last week</h5>
            </div>
        </div>
    </div>							 -->
</div>
<!-- Row end -->

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <div class="card">
            <div class="card-body">
                
                <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                                <th>Transaction number</th>
                                <th>Created at</th>
                                <th>Product Name</th>
                                <th>Outlet</th>													  
                                <th>Unit Price</th>													  
                                <th>Quantity</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach(json_decode($invoices) as $invoices)
                            <tr>
                                <td>
                                <div class="media-box">
                                    <div class="media-box-body">
                                        <a href="#" class="text-truncate">{{ $invoices->invoice_number}}</a>
                                    </div>
                                </div>
                                </td>
                                <td>{{$invoices->created_at}}</td>											  
                                <td>{{@strtoupper($invoices->invoice_product_name)}}</td>
                                <td>{{$invoices->branch}}</td>													  
                                <td>@convert($invoices->invoice_unit_price)</td>
                                <td>@convert($invoices->invoice_quantity)</td>
                                <td>@convert($invoices->invoice_total_price)</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
        </div>

    </div>
</div>
<!-- Row end -->


@endsection
