<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Http;

use App\Models\LoyaltyPoint;
use App\Models\Customer;
use Illuminate\Http\Request;
use Session;
use Illuminate\Support\Facades\Cache;

class CustomerController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function searchCustomer()
    {
        session()->forget('customer_name', 'customer_phone', 'customer_address');
        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        $response = Http::retry(3, 3000)->get("https://egalite.erpandas.com/api/v1/search-customer/" . request('customer'));

        if (empty(json_decode($response)) || null) {
        
            session()->forget(['customer_name', 'customer_address', 'customer_phone', 'customer_note']);

            if (empty(Cache::get('products'))) {
                Cache::put('products', \DB::table('final_productions')->get());
            }
    
            $products = Cache::get('products'); 
            return view('customer-details-loyality', [
                'products' => $products
            ]);
        }

        $ids = implode(",", array_column(json_decode($response), 'id'));

        
        $url = "https://egalite.erpandas.com/api/v1/search-loyalty-points/" . $ids;
        $response_loyalty = Http::retry(3, 2000)->get($url);

        foreach (json_decode($response_loyalty) as $key =>  $response_loyalty) {
            LoyaltyPoint::updateOrCreate([
                'customer_id' => $response_loyalty->customer_id
            ], [
                'increase' => $response_loyalty->increase,
                'decrease' => $response_loyalty->decrease
            ]);
        }
        
        \DB::commit();

        return view('loyalty', [
            'customer' => $response,
        ]);

        } catch (\Throwable $th) {
            \DB::rollback();
            $res = response([
                'status' => 501,
                "message" => $th
            ]);
            return back()->with('statuspass', "Oops Something Happend. Kindly check your Internet connection");
            
        } 
    }




    public function searchCustomerAdv(Request $request)
    {
       
        session()->forget('customer_name', 'customer_phone', 'customer_address');
        $new_customer = Customer::where('customer_contact', request('customer'))->first();

        

        if (empty($new_customer) || null) {

            $response = Http::retry(3, 3000)->get("https://egalite.erpandas.com/api/v1/search-customer/" . request('customer'));

            if (empty(json_decode($response)) || null) {

                return redirect()->to('/place-order-customer/' .request('customer'));

            }else {

                    $response = $response[0];
                    $customer = Customer::updateOrCreate([
                        'customer_contact' => $response['customer_phone']
                    ],
                    [
                        'customer_name' => $response['customer_name'],
                        'customer_contact' => $response['customer_phone'],
                    ]);

                
                    
                    return redirect()->route('returnedCustomer', $customer->id);
                }
            }else {
                return redirect()->route('returnedCustomer', $new_customer->id);
            }

            return redirect()->to('delivery-sale');

        
    }



    public function deliveryTransaction($customer_id, Request $request)
    {
        // Load products from cache
        $products = Cache::rememberForever('products', function() {
            return \DB::table('final_productions')->get();
        });

        // Load customer data
        $response = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/v1/customer/" . $customer_id);

        // Load customer loyalty points
        $customer_pts = LoyaltyPoint::where('customer_id', $customer_id)->first();
        $points = $customer_pts ? $customer_pts->increase - $customer_pts->decrease : 0;

        // Store customer data in session
        session()->put([
            'customer_name' => $response['customer_name'],
            'customer_address' => $response['customer_address'],
            'customer_contact' => $response['customer_phone'],
            'customer_note' => $response['customer_note']
        ]);

        // Store loyalty points in session
        session()->put('loyality_point', $points);

        // Render view with product data
        return view('create-invoice-delivery', [
            'products' => $products
        ]);

    }


    public function storeCustomer(Request $request)
    {
        $this->validate($request, [
            'customer_name'=> ['required', 'string', 'max:255'],
            'customer_phone'=> ['required', 'string', 'max:255'],
        ]);

        $customer_data = [
            'customer_name' => request('customer_name'),
            'customer_contact' => request('customer_phone'),
            'customer_address' => request('customer_address'),
            'customer_note' => request('customer_note'),
            'api_key' => "PIZZADOrable401",
            'user_id' => auth()->id(),
            'branch' => empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch')
        ];

        $url = "https://egalite.erpandas.com/api/v1/save-new-customer";
        $response = Http::retry(3, 2000)->post($url, $customer_data);

        if (request('create_inv') == 1) {
            return redirect()->route('redeem', (string)$response);
        }else {
            
            return back()->with('status', request('customer_name') . " added successfully");
        }
    }


    public function update(Request $request)
    {
        $this->validate($request, [
            'customer_name'=> ['required', 'string', 'max:255'],
            'customer_phone'=> ['required', 'string', 'max:255'],
        ]);

         $customer_data = [
            'customer_name' => request('customer_name'),
            'customer_contact' => request('customer_phone'),
            'customer_address' => request('customer_address'),
            'customer_note' => request('customer_note'),
            'api_key' => "PIZZADOrable401",
            'user_id' => auth()->id(),
            'branch' => empty(session()->get('switch_branch')) ? auth()->user()->branch : session()->get('switch_branch')
        ];

        $url = "https://egalite.erpandas.com/api/v1/save-new-customer";
        $response = Http::retry(3, 2000)->post($url, $customer_data);
         return response([
             'status' => 200,
             'message' => 'Success'
         ]);
    }


    
    public function CustomerName(Request $request, $name)
    {
        $request->session()->put('customer_name',$name);
    }

    public function CustomerNameLoyal(Request $request,$name)
    {
    
        $customer = Customer::where('customer_contact', session()->get('customer_contact'))
        ->update([
            'customer_name' => $name
        ]);

        $request->session()->put('customer_name',$name);

    }

    public function CustomerNote(Request $request, $note)
    {
        $request->session()->put('customer_note',$note);
    }


    public function CustomerAddress(Request $request, $address)
    {
        $request->session()->put('customer_address',$address);
    }


    public function CustomerContact(Request $request, $contact)
    {
        $request->session()->put('customer_contact',$contact);
    }

}
