<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class DiscountController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function store(Request $request)
    {  
        // CHECK IF ITS A LOYALITY POINT
    $request->session()->put('loyalty', request('loyal'));

    if ($request->submit_celeb == "Apply Code") {

        $this->validate(request(), [
            'discount_code'=> 'required|max:50'
        ]);
        
        // check if code exist
        
       
        $check_code = Http::retry(3, 2000)->get("https://egalite.erpandas.com/api/v1/discount/" . $request->discount_code);
        
        
        if (empty($check_code) || null) {
            abort(419, "Mismatch Gift Card");
        }else {
            $sum = 0;
            $checkseesion = session()->get('cart');
                if (!empty($checkseesion) || null) {
                    foreach ($checkseesion as $item) {
                    $result = (float)$item['invoice_quantity'] * (float)$item['invoice_unit_price'];
                    $sum+=$result;
                    }
                }

                $data = [
                    'type' => "Cash",
                    'discount' => $check_code['discount_percentage'],
                ];

            

            session()->put('is_discount_code', 1);
            session()->put('discount_code', $request->discount_code);
            
            session()->put('discount', $data);

        }
    }else {
        if (request('type') == "Percentage") {
            if (request('discount') > 100) {
                abort(419, "Percentage Can not be greater than 100");
            }
        }
        $sum = 0;
            $checkseesion = session()->get('cart');
                if (!empty($checkseesion) || null) {
                    foreach ($checkseesion as $item) {
                    $result = (float)$item['invoice_quantity'] * (float)$item['invoice_unit_price'];
                    $sum+=$result;
                    }
                }

                $data = [
                    'type' => request('type'),
                    'discount' => request('discount'),
                ];
            
            session()->put('discount', $data);
            
         }
         return 123;

    }
}
