<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Auth;
use View;
use DB;
use Blade;
use Carbon\carbon;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Paginator::useBootstrap();
        View::composer('*', function($view){

            $sum = 0;
            $checkseesion = session()->get('cart');
            $view->with('cartItems', session()->get('cart'));
            $view->with('checkseesion', $checkseesion);
            if (!empty($checkseesion) || null) {
                foreach ($checkseesion as $item) {
                $result = (float)$item['invoice_quantity'] * (float)$item['invoice_unit_price'];
                $sum+=$result;
                }
                $view->with('totalCart', $sum);
            }




            Blade::directive('convert', function ($money) {
                return "<?php echo number_format($money, 2); ?>";
            });

        });
        
    }
}
