@extends('layouts.app')

@section('content')

    <!-- Row start -->
    <div class="row gutters">
    <div class="col-xl-8 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <h5 class="m-0">Welcome Back, {{auth()->user()->name}}! </h5> 
        <small>Logged In at: <b class="text-primary">{{ \Carbon\Carbon::parse(auth()->user()->last_seen)->diffForHumans() }}</b>,
        Active Date: {{date('Y-m-d')}},
        Outlet: {{auth()->user()->branch}}

        </small>

        <!-- Consultants banner start -->
        <div class="consulting-banner">
            <div class="consulting-banner-bg"></div>
            <div class="consulting-body">
                <div class="consulting-content">
                    <h4>ANDASLITE: Second Serve Tennis Shop</h4> 
                    <p>To make the experience hassle-free, <br /> Kindly read our user guide or watch our video tutorials</p>
                </div>
            </div>
        </div>
        <!-- Consultants banner end -->
        
    </div>
    <div class="col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <!-- Consultants card start -->
        <div class="consulting-card">
            <div class="consulting-card-bg"></div>
            <div class="consulting-card-body">
                <h4>Get Started</h4>
                Hey there! <br>
                <p>We have assembled some links to get you started</p>
                @if(auth()->user()->role == "Call Center")
                <a href="{{route('deliverySale')}}" class="btn btn-outline-info stripes-btn">
                   <i class="icon-shield1"></i> Personalized sales</a>
                @else
                @if(auth()->user()->branch ==  "DAKODWOM BRANCH" || session()->get('switch_branch') == "DAKODWOM BRANCH")
                @if(auth()->user()->sales_person_category == "Counter")
                <a href="#"  data-bs-toggle="modal" data-bs-target="#scheduleModalDelivery" class="btn btn-outline-info stripes-btn">
                   <i class="icon-shield1"></i> Personalized sales</a>
                @else
                <a href="{{route('deliverySale')}}" class="btn btn-outline-info stripes-btn">
                   <i class="icon-shield1"></i> Personalized sales</a>
                @endif
                @else
                <a href="{{route('newInvoice')}}" class="btn btn-primary stripes-btn"><i class="icon-shopping-cart1"></i> Walk In Sale</a>
                @if(auth()->user()->sales_person_category == "Counter")
                <a href="#"  data-bs-toggle="modal" data-bs-target="#scheduleModalDelivery" class="btn btn-outline-info stripes-btn">
                   <i class="icon-shield1"></i> Personalized sales</a>
                @else
                <a href="{{route('deliverySale')}}" class="btn btn-outline-info stripes-btn">
                   <i class="icon-shield1"></i> Personalized sales</a>
                @endif
                  
                @endif
                @endif
                
            </div>
        </div>
        <!-- Consultants card end -->
        
    </div>
</div>
<!-- Row end -->

        <div class="row gutters">

        <div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-12">
            <div class="stats-tile2">
                <div class="sale-icon">
                    <i class="icon-question_answer"></i>
                </div>
                <div class="sale-details">
                    <p>Get Started FAQ</p>
                </div>
            </div>
            <div class="stats-tile2">
                <div class="sale-icon">
                    <i class="icon-local_library"></i>
                </div>
                <div class="sale-details">
                    <p>Knowledge Articles</p>
                </div>
            </div>
        </div>
        <div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-12">
            <div class="stats-tile2">
                <div class="sale-icon">
                    <i class="icon-video"></i>
                </div>
                <div class="sale-details">
                    <p>Video Tutorial</p>
                </div>
            </div>
            <div class="stats-tile2">
                <div class="sale-icon">
                    <i class="icon-headphones"></i>
                </div>
                <div class="sale-details">
                <p><a href="mailto:info@andasconsult.com">Customer Support</a></p>
                </div>
            </div>
        </div>
        <div class="col-xl-8 col-lg-6 col-md-12 col-sm-12 col-12">

            <div class="card">
                <div class="card-header">
                    <div class="card-title">Transaction for the day</div>
                </div>
                <div class="card-body">
                        
                <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                                <th>Transaction ID</th>
                                <th>Outlet</th>
                                <th>Date</th>													  
                                <th>Payment Method</th>	
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($orders as $order)
                            <tr>
                                <td>
                                <div class="media-box">
                                    <img src="img/products/bag.jpg" class="media-avatar" alt="Product">
                                    <div class="media-box-body">
                                        <a href="{{route('Reprint', $order->transaction_number)}}" class="text-truncate">{{$order->transaction_number}}</a>
                                    </div>
                                </div>
                                </td>
                                <td>{{$order->branch}}</td>
                                <td>{{$order->created_at}}</td>													  
                                <td>{{$order->payment_method}}</td>
                                <td>
                                <div class="actions">
                                        <a href="{{route('Reprint', $order->transaction_number)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                            <i class="icon-print text-secondary"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                </div>
            </div>

        </div>
</div>
        <!-- Row end -->
@endsection
