
<!doctype html>
<html lang="en">
    
<head>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<link rel="shortcut icon" href="/img/andas.jpg" />
		<title>ANDASLITE POS V.1.12</title>

		<!-- Bootstrap css -->
		<link rel="stylesheet" href="{{asset('css/bootstrap.min.css')}}">
		<!-- Icomoon Font Icons css -->
		<link rel="stylesheet" href="{{asset('fonts/style.css')}}">
		<!-- Main css -->
		<link rel="stylesheet" href="{{asset('css/main.css')}}">
		<!-- Date Range CSS -->
		<link rel="stylesheet" href="{{asset('vendor/daterange/daterange.css')}}">
		<!-- Uploader CSS -->
		<link rel="stylesheet" href="{{asset('vendor/dropzone/dropzone.min.css')}}" />
		
		<!-- fontAwesome -->
		<link href="{{asset('fontawesome/css/all.css')}}" rel="stylesheet">
		<!-- Data Tables -->
		<link rel="stylesheet" href="{{asset('vendor/datatables/dataTables.bs4.css')}}" />
		<link rel="stylesheet" href="{{asset('vendor/datatables/dataTables.bs4-custom.css')}}" />
		<link href="{{asset('vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- Bootstrap Select CSS -->
		<link rel="stylesheet" href="{{asset('vendor/bs-select/bs-select.css')}}" />

		<!-- Mega Menu -->
		<link rel="stylesheet" href="{{asset('vendor/megamenu/css/megamenu.css')}}">

		<!-- Search Filter JS -->
		<link rel="stylesheet" href="{{asset('vendor/search-filter/search-filter.css')}}">
		<link rel="stylesheet" href="{{asset('vendor/search-filter/custom-search-filter.css')}}">

        <!-- Sweet Alert-->
		<link href="{{asset('vendor/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />
		<!-- Ajax Call -->
		<script src="{{asset('js/ajax.min.js')}}"></script>


	</head>
	<body>

		<!-- Loading wrapper start -->
		<div id="loading-wrapper">
			<div class="spinner-border"></div>
			Proccessing.. please wait...
		</div>
		<!-- Loading wrapper end -->
		
		<!-- Page wrapper start -->
		<div class="page-wrapper">

		<!-- Sidebar wrapper start -->
		<nav class="sidebar-wrapper">
		
<!-- Sidebar content start -->
<div class="sidebar-tabs">

	<!-- Tabs nav start -->
	<div class="nav" role="tablist" aria-orientation="vertical">
		<a href="#" class="logo">
			<img src="/img/andas.jpg" alt="andas logo">
		</a>
		<a class="nav-link active" id="home-tab" data-bs-toggle="tab" href="#tab-home" role="tab" aria-controls="tab-home" aria-selected="true">
			<i class="icon-home2"></i>
			<span class="nav-link-text">Dashboards</span>
		</a>
	</div>
	<!-- Tabs nav end -->

	<!-- Tabs content start -->
	<div class="tab-content">
				
		<!-- Chat tab -->
		<div class="tab-pane fade show active" id="tab-home" role="tabpanel" aria-labelledby="home-tab">

			<!-- Tab content header start -->
			<div class="tab-pane-header">
				Dashboards
			</div>
			<!-- Tab content header end -->

			<!-- Sidebar menu starts -->
			<div class="sidebarMenuScroll">
				<div class="sidebar-menu">
					<ul class="tile-menu">
						<li>
							<a href="/home">
								<i class="icon-laptop"></i> Dashboard
							</a>
						</li>
						<li>
							<a href="{{route('newInvoice')}}"><i class="icon-shopping-cart1"></i>
							@if(auth()->user()->role == "Call Center")
							New Sale
							@else
							Walk In Sale
							@endif
							</a>
						</li>
						<li>
							<a href="{{route('printLastTransaction')}}"><i class="icon-shopping-bag1"></i> Last Transaction</a>
						</li>
						@if(auth()->user()->role != "Call Center")
							@if(auth()->user()->branch ==  "DAKODWOM BRANCH" || session()->get('switch_branch') == "DAKODWOM BRANCH")
								@if(auth()->user()->sales_person_category == "Counter")
								<li>
									<a href="#" data-bs-toggle="modal" data-bs-target="#scheduleModalDelivery"><i class="icon-shield1"></i> Personalized sales</a>
								</li>
								@else
								<li>
									<a href="{{route('deliverySale')}}" ><i class="icon-shield1"></i> Personalized sales</a>
								</li>
								@endif
							@else
								@if(auth()->user()->sales_person_category == "Counter")
								<li>
									<a href="#" data-bs-toggle="modal" data-bs-target="#scheduleModalDelivery"><i class="icon-shield1"></i> Personalized sales</a>
								</li>
								@else
								<li>
									<a href="{{route('deliverySale')}}" ><i class="icon-shield1"></i> Personalized sales</a>
								</li>
								@endif
							@endif

						@endif
						<li>
							<a href="{{route('report')}}"><i class="icon-bar-chart"></i> Reports</a>
						</li>
						<li>
							<a href="{{route('GetWaiter')}}"><i class="icon-user1"></i>Waiter Management</a>
						</li>
						<li>
							<a href="#" data-bs-toggle="modal" data-bs-target="#submitTicketModal"><i class="icon-user-plus"></i> New Customer</a>
						</li>
						
						<li>
							<a href="#" data-bs-toggle="modal" data-bs-target="#scheduleModal"><i class="icon-briefcase"></i> Loyalty Reward</a>
						</li>
						<li>
							<a href="#" data-bs-toggle="modal" data-bs-target="#Advancesearch"><i class="icon-directions_car"></i>Track Order</a>
						</li>
						<li>
							<a href="{{route('branch')}}"><i class="icon-rss_feed"></i>Sync Outlets</a>
						</li>
						<li>
							<a href="{{route('location')}}"><i class="icon-location-pin"></i>Sync Locations</a>
						</li>
						<li>
							<a href="{{route('utility')}}"><i class="icon-trending-up"></i>Sync Utilities</a>
						</li>
						<li>
							<a href="#" onclick="updateSoftware()"><i class="icon-upload-cloud"></i>Software Update</a>
						</li>
					</ul>
				</div>
			</div>
			<!-- Sidebar menu ends -->

			<!-- Sidebar actions starts -->
			<a href="{{route('syncProduction')}}" class="sidebar-actions">
			
				<div class="support-tile blue">
				<i class="icon-layers2"></i> Sync Products
				</div>
			</a>
			<!-- Sidebar actions ends -->

		</div>


		<!-- Settings tab -->
		<div class="tab-pane fade" id="tab-settings" role="tabpanel" aria-labelledby="settings-tab">
			
			<!-- Tab content header start -->
			<div class="tab-pane-header">
				Settings
			</div>
			<!-- Tab content header end -->

			<!-- Settings start -->
			<div class="sidebarMenuScroll">
				<div class="sidebar-settings">
					<div class="accordion" id="settingsAccordion">
						<div class="accordion-item">
							<h2 class="accordion-header" id="genInfo">
								<button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#genCollapse" aria-expanded="true" aria-controls="genCollapse">
									General Info
								</button>
							</h2>
							<div id="genCollapse" class="accordion-collapse collapse show" aria-labelledby="genInfo" data-bs-parent="#settingsAccordion">
								<div class="accordion-body">
									<div class="field-wrapper">
										<input type="text" value="Jeivxezer Lopexz" />
										<div class="field-placeholder">Full Name</div>
									</div>

									<div class="field-wrapper">
										<input type="email" value="jeivxezer-lopexz@email.com" />
										<div class="field-placeholder">Email</div>
									</div>

									<div class="field-wrapper">
										<input type="text" value="0 0000 00000" />
										<div class="field-placeholder">Contact</div>
									</div>
									<div class="field-wrapper m-0">
										<button class="btn btn-primary stripes-btn">Save</button>
									</div>
								</div>
							</div>
						</div>
						<div class="accordion-item">
							<h2 class="accordion-header" id="chngPwd">
								<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#chngPwdCollapse" aria-expanded="false" aria-controls="chngPwdCollapse">
									Change Password
								</button>
							</h2>
							<div id="chngPwdCollapse" class="accordion-collapse collapse" aria-labelledby="chngPwd" data-bs-parent="#settingsAccordion">
								<div class="accordion-body">
									<div class="field-wrapper">
										<input type="text" value="">
										<div class="field-placeholder">Current Password</div>
									</div>
									<div class="field-wrapper">
										<input type="password" value="">
										<div class="field-placeholder">New Password</div>
									</div>
									<div class="field-wrapper">
										<input type="password" value="">
										<div class="field-placeholder">Confirm Password</div>
									</div>
									<div class="field-wrapper m-0">
										<button class="btn btn-primary stripes-btn">Save</button>
									</div>

								</div>
							</div>
						</div>
						<div class="accordion-item">
							<h2 class="accordion-header" id="sidebarNotifications">
								<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#notiCollapse" aria-expanded="false" aria-controls="notiCollapse">
									Notifications
								</button>
							</h2>
							<div id="notiCollapse" class="accordion-collapse collapse" aria-labelledby="sidebarNotifications" data-bs-parent="#settingsAccordion">
								<div class="accordion-body">
									<div class="list-group m-0">
										<div class="noti-container">
											<div class="noti-block">
												<div>Alerts</div>
												<div class="form-switch">
													<input class="form-check-input" type="checkbox" id="showAlertss" checked>
													<label class="form-check-label" for="showAlertss"></label>
												</div>
											</div>
											<div class="noti-block">
												<div>Enable Sound</div>
												<div class="form-switch">
													<input class="form-check-input" type="checkbox" id="soundEnable">
													<label class="form-check-label" for="soundEnable"></label>
												</div>
											</div>
											<div class="noti-block">
												<div>Allow Chat</div>
												<div class="form-switch">
													<input class="form-check-input" type="checkbox" id="allowChat">
													<label class="form-check-label" for="allowChat"></label>
												</div>
											</div>
											<div class="noti-block">
												<div>Desktop Messages</div>
												<div class="form-switch">
													<input class="form-check-input" type="checkbox" id="desktopMessages">
													<label class="form-check-label" for="desktopMessages"></label>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- Settings end -->

			<!-- Sidebar actions starts -->
			<div class="sidebar-actions">
				<div class="support-tile blue">
					<a href="account-settings.html" class="btn btn-light m-auto">Advance Settings</a>
				</div>
			</div>
			<!-- Sidebar actions ends -->
		</div>

	</div>
	<!-- Tabs content end -->

</div>
<!-- Sidebar content end -->

</nav>
<!-- Sidebar wrapper end -->
		

			<!-- *************
				************ Main container start *************
			************* -->
			<div class="main-container">

				<!-- Page header starts -->
				<div class="page-header">
					
					<!-- Row start -->
					<div class="row gutters">
						<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-9">

							<!-- Search container start -->
							<div class="search-container">

								<!-- Toggle sidebar start -->
								<div class="toggle-sidebar" id="toggle-sidebar">
									<i class="icon-menu"></i>
								</div>
								<!-- Toggle sidebar end -->
								

								<!-- Search input group start -->
								<div class="ui fluid category search">
									<div class="ui icon input">
										<input class="prompt" type="text" disabled placeholder="Search">
										<i class="search icon icon-search1"></i>
									</div>
									<div class="results"></div>
								</div>
								<!-- Search input group end -->

							</div>
							<!-- Search container end -->

						</div>
						<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-3">

							<!-- Header actions start -->
							<ul class="header-actions">
								<li class="dropdown">
									<a href="#" id="userSettings" class="user-settings" data-toggle="dropdown" aria-haspopup="true">
										<span class="avatar">
											<img src="/img/user.svg" alt="User Avatar">
											<span class="status busy"></span>
										</span>
									</a>
									<div class="dropdown-menu dropdown-menu-end md" aria-labelledby="userSettings">
										<div class="header-profile-actions">
											<a class="dropdown-item" href="{{ route('logout') }}"
                                      		 onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
													<i class="icon-log-out1"></i> Logout
													</a>
											<form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
												@csrf
											</form>
										</div>
									</div>
								</li>
							</ul>
							<!-- Header actions end -->

						</div>
					</div>
					<!-- Row end -->					

				</div>
				<!-- Page header ends -->

				<!-- Content wrapper scroll start -->
				<div class="content-wrapper-scroll">
				
					<!-- Content wrapper start -->
					<div class="content-wrapper">
					@include('inc.errorfile')

						@yield('content')

					</div>
					<!-- Content wrapper end -->
	
					@include('modal.customer-data')

					


<!-- Modal start -->
<div class="modal fade" id="Advancesearch" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="exampleModalCenterTitle">Advance Search</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
					<p><small>Advance search for Invoice Numbers, Customer Phone Number Or by Customer Outlet</small></p>
						<form action="{{route('deliveryOrders')}}" method="get">
							<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
								<!-- Field wrapper start -->
								<div class="field-wrapper">
									<div class="input-group">														
										<input type="text" class="form-control" name="search" placeholder="Search by Invoice No., customer Contact or Outlet">
										<button class="btn btn-primary" type="submit">Search</button>
									</div>
									<div class="field-placeholder">Search</div>
								</div>
								<!-- Field wrapper end -->
							</div>
						<!-- Row end -->
						</form>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
				</div>
			</div>
		</div>
	</div>
	<!-- Modal end -->



	<!-- Modal start -->
<div class="modal fade" id="scheduleModalDelivery" tabindex="-1" aria-labelledby="scheduleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="scheduleModalLabel">Search Customer Contact</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
            <form action="{{route('searchCustomerAdv')}}" method="get">
                    <!-- Field wrapper start -->
                <div class="field-wrapper">
                    <div class="input-group">														
                        <input  class="form-control" required name="customer" placeholder="Customer Contact" type="tel" id="phone" name="phone" pattern="[0-9]{3}[0-9]{3}[0-9]{4}">
                        <button class="btn btn-primary" type="submit">Search</button>
                    </div>
                    <div class="field-placeholder">Search Customer</div>
					<small class="text-danger"> contact must be 10 digits</small>
                </div>
                <!-- Field wrapper end -->
               </form>

            </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->
					

<!-- Modal start -->
<div class="modal fade" id="scheduleModal" tabindex="-1" aria-labelledby="scheduleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="scheduleModalLabel">Customer Advanced Search</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
            <form action="{{route('searchCustomer')}}" method="get">
                    <!-- Field wrapper start -->
                <div class="field-wrapper">
                    <div class="input-group">														
                        <input type="text" class="form-control" required name="customer" placeholder="search by name, loyalty code, phone number, last outlet of purchase">
                        <button class="btn btn-primary" type="submit">Search</button>
                    </div>
                    <div class="field-placeholder">Search Customer</div>
                </div>
                <!-- Field wrapper end -->
               </form>

            </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->

					<!-- App Footer start -->
					<div class="app-footer">© 2022 ANDAS POS LITE VERSION 1.1.2</div>
					<!-- App footer end -->

				</div>
				<!-- Content wrapper scroll end -->

			</div>
			<!-- *************
				************ Main container end *************
			************* -->

		</div>
		<!-- Page wrapper end -->


		<script>
			function updateSoftware() {
            Swal.fire({
                title: 'Update Software! are you sure?',
                text: "You won't be able to revert this update!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, update software!'
                }).then((result) => {
                if (result.isConfirmed) {
					$('#loading-wrapper').show();
                    window.location.href = "{{route('update')}}";
                }
                })
        }
		</script>

		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('js/jquery.min.js')}}"></script>
		<script src="{{asset('js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('js/modernizr.js')}}"></script>
		<script src="{{asset('js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->


		<!-- Sweet Alerts js -->
		<script src="{{asset('vendor/libs/sweetalert2/sweetalert2.min.js')}}"></script>
		
		<!-- Megamenu JS -->
		<script src="{{asset('vendor/megamenu/js/megamenu.js')}}"></script>
		<script src="{{asset('vendor/megamenu/js/custom.js')}}"></script>
		<!-- Slimscroll JS -->
		<script src="{{asset('vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('vendor/slimscroll/custom-scrollbar.js')}}"></script>
		<!-- Search Filter JS -->
		<script src="{{asset('vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('vendor/search-filter/custom-search-filter.js')}}"></script>
		<!-- Apex Charts -->
		<script src="{{asset('vendor/apex/apexcharts.min.js')}}"></script>
		<script src="{{asset('vendor/apex/custom/home/salesGraph.js')}}"></script>
		<!-- Circleful Charts -->
		<script src="{{asset('vendor/circliful/circliful.min.js')}}"></script>
		<script src="{{asset('vendor/circliful/circliful.custom.js')}}"></script>
		<!-- Bootstrap Select JS -->
		<script src="{{asset('vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('vendor/bs-select/bs-select-custom.js')}}"></script>
		<!-- Data Tables -->
		<script src="{{asset('vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		<!-- Custom Data tables -->
		<script src="{{asset('vendor/datatables/custom/custom-datatables.js')}}"></script>
		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/buttons.print.min.js')}}"></script>
		<!-- Dropzone JS -->
		<script src="{{asset('vendor/dropzone/dropzone.min.js')}}"></script>
		<!-- Date Range JS -->
		<script src="{{asset('vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('vendor/daterange/custom-daterange.js')}}"></script>
		<!-- Main Js Required -->
		<script src="{{asset('js/main.js')}}"></script>

	</body>

</html>