@extends('layouts.app')

@section('content')

 <!-- Breadcrumb container start -->
 <div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="/home">Dashboards</a></li>
              <li class="breadcrumb-item active" aria-current="page">Waiter Management</li>
            </ol>
        </nav>
    </div>
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <div class="d-flex justify-content-end">
        @if(\Route::currentRouteName() !== "confirmed")
            <a href="{{route('confirmed')}}" class="btn btn-primary stripes-btn"><i class="icon-download1"></i> Confirmed Transactions</a>
        @endif
        </div>
    </div>
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->


<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <div class="card">
            <div class="card-body">
                
                <div class="table-responsive">
                <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                                <th>Transaction ID</th>
                                <th>Outlet</th>
                                <th>Waiter</th>													  
                                <th>Created at</th>	
                                @if(\Route::currentRouteName() == "confirmed")
                                <th>Paid at</th>
                                @else
                                <th>Action</th>
                                @endif
                            </tr>
                        </thead>
                        <tbody>
                            @foreach(json_decode($waiter_transactions) as $order)
                            <tr>
                                <td>
                                <div class="media-box">
                                    <img src="img/products/bag.jpg" class="media-avatar" alt="Product">
                                    <div class="media-box-body">
                                        <a href="{{route('Reprint', $order->invoice_number)}}" class="text-truncate">{{$order->invoice_number}}</a>
                                    </div>
                                </div>
                                </td>
                                <td>{{$order->branch}}</td>
                                <td>
                                    <?php 
                                        
                                        $username = \DB::table('users')->where('id', $order->table_served_by)->first(); 
                                        if (empty($username)) {
                                            $name = "No Waiter Assigned";
                                        }else {
                                            $name = $username->name;
                                        }

                                
                                    ?>
                                        {{$name}}
                                </td>													  
                                <td>{{ \Carbon\Carbon::parse($order->created_at)->diffForHumans() }} </td>
                                @if(\Route::currentRouteName() == "confirmed")
                                    <td>{{$order->settled_at}} <br>
                                    Accepted by: <strong>{{$order->settled_by}}</strong>
                                </td>
                                @else
                                <td>
                                    <a href="#" id="{{$order->id}}" onclick="confirmPay(this.id)" class="btn btn-outline-primary btn-sm">Confirm Payment</a>
                                </td>
                                @endif
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </table>
                </div>

            </div>
        </div>

    </div>
</div>
<!-- Row end -->

<script>

    function confirmPay(id) {
        Swal.fire({
                title: 'Are you sure?',
                text: "You want to confirm receipt of payment from a waiter, are you sure ? you may not be able to revert",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Confirrm!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "/waiter-Ccnfrimwaiter/" + id;
                }
                })
    }

</script>


@endsection
