<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Http;
use App\Models\FinalProduction;
use App\Models\User;
// use ZipArchive;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});


Route::get('users', function () {
    // return \DB::table('users')->get();
    return \DB::table('celebrity_discounts')->get();
});

Route::get('products', function () {
    return \DB::table('final_productions')->get();
});


Route::post('/add-cart',[App\Http\Controllers\InvoiceController::class,'addCart'])->name('InvoiceDump');
Route::get('/create/invoice-dump/new-transaction',[App\Http\Controllers\InvoiceController::class,'destroy'])->name('deleteDump');

Route::get('/increase-cart/{id}/{quantity}', [App\Http\Controllers\InvoiceController::class,'IncreaseCart'])->name('cartQuantity');
Route::get('/decrease-cart/{id}/{quantity}', [App\Http\Controllers\InvoiceController::class,'DecreaseCart'])->name('DecreasecartQuantity');
Route::get('/ceqafoods/delete-item/{id}',[App\Http\Controllers\InvoiceController::class,'InvoiceDumpDestroy'])->name('InvoiceDumpDestroy');

Route::get('/delivery-sale',[App\Http\Controllers\InvoiceController::class,'deliverySale'])->name('deliverySale');

Route::get('/place-order-customer/{customer_contact}',[App\Http\Controllers\InvoiceController::class,'customerSale'])->name('customerSale');
Route::get('/place-order-returned-customer/{id}',[App\Http\Controllers\InvoiceController::class,'returnedCustomer'])->name('returnedCustomer');

Route::get('/place-order-hold-transaction',[App\Http\Controllers\InvoiceController::class,'HoldTransaction'])->name('HoldTransaction');



Route::get('/not-display',[App\Http\Controllers\InvoiceController::class,'notDisplay'])->name('notDisplay');


Route::post('/add-discount',[App\Http\Controllers\DiscountController::class,'store'])->name('OrderDiscount');

Route::get('/list-customers',[App\Http\Controllers\CustomerController::class,'searchCustomer'])->name('searchCustomer');

Route::get('/list-customers-place-order',[App\Http\Controllers\CustomerController::class,'searchCustomerAdv'])->name('searchCustomerAdv');

Route::get('/create-invoice-delivery/{customer_id}',[App\Http\Controllers\CustomerController::class,'deliveryTransaction'])->name('redeem');

Route::get('/syn-product',[App\Http\Controllers\FinalProductionController::class,'SyncProduct'])->name('syncProduction');

Route::post('/generate-invoice/make-payment',[App\Http\Controllers\InvoiceController::class,'generateInvoicePay'])->name('generateInvoicePay');

Route::post('/generate-invoice/make-payment/delivery',[App\Http\Controllers\InvoiceController::class,'generateInvoicePayDelivery'])->name('generateInvoicePayDelivery');


Route::get('/report',[App\Http\Controllers\ReportController::class,'report'])->name('report');

Route::get('/last-transaction',[App\Http\Controllers\InvoiceController::class,'printLastTransaction'])->name('printLastTransaction');
Route::get('/reprint/{invoice_number}',[App\Http\Controllers\InvoiceController::class,'Reprint'])->name('Reprint');

Route::post('/accept-payment/tingg',[App\Http\Controllers\GeneralController::class,'AcceptPayment'])->name('AcceptPayment');
    
Route::get('/accept-payment/check-status',[App\Http\Controllers\GeneralController::class,'checkPaymentStatus'])->name('checkPaymentStatus');

Route::get('/waiter-management',[App\Http\Controllers\GeneralController::class,'getWatiter'])->name('GetWaiter');
Route::get('/waiter-Ccnfrimwaiter/{id}',[App\Http\Controllers\GeneralController::class,'ConfrimWaiter'])->name('ConfrimWaiter');

Route::get('/waiter-comfirmed-transactions',[App\Http\Controllers\GeneralController::class,'getWatiterConfirm'])->name('confirmed');





Route::get('/customer-note/{note}',[App\Http\Controllers\CustomerController::class,'CustomerNote'])->name('CustomerNote');
Route::get('/customer-name/{name}',[App\Http\Controllers\CustomerController::class,'CustomerName'])->name('CustomerName');
Route::get('/customer-address/{address}',[App\Http\Controllers\CustomerController::class,'CustomerAddress'])->name('CustomerAddress');
Route::get('/customer-contact/{contact}',[App\Http\Controllers\CustomerController::class,'CustomerContact'])->name('CustomerContact');
Route::get('/customer-name/loyal/{name}',[App\Http\Controllers\CustomerController::class,'CustomerNameLoyal'])->name('CustomerNameLoyal');

Route::get('/update-customer',[App\Http\Controllers\CustomerController::class,'update'])->name('updateCustomer');

Route::get('/save-customer',[App\Http\Controllers\CustomerController::class,'storeCustomer'])->name('customer');


Route::get('/orders-delivery',[App\Http\Controllers\OrderTransactionController::class,'index'])->name('deliveryOrders');

Route::get('/location',[App\Http\Controllers\GeneralController::class,'location'])->name('location');

Route::get('/branches',[App\Http\Controllers\GeneralController::class,'branches'])->name('branch');

Route::post('/delivery-location-to-dump',[App\Http\Controllers\InvoiceController::class,'locationPrice'])->name('locationPrice');


Route::get('/get-delivery-price/{id}',[App\Http\Controllers\GeneralController::class,'getPriceLocation']);

Route::get('/switch-branch',[App\Http\Controllers\GeneralController::class,'Switch'])->name('switch');

Route::get('cart', function(){
    return session()->get('cart');
    return \DB::table('dispatch_items')->get();
});


Route::get('/update', [App\Http\Controllers\GeneralController::class, 'updaateSystem'])->name('update');

Route::get('/syc-sales', [App\Http\Controllers\InvoiceController::class, 'SyncSales'])->name('SyncSales');

Route::get('/update-utility', [App\Http\Controllers\GeneralController::class, 'loadUtility'])->name('utility');
Route::post('/save-beneficiary', [App\Http\Controllers\GeneralController::class, 'saveBeneficiary'])->name('saveBeneficiary');

Route::get('/barcode-search/{barcode}', [App\Http\Controllers\InvoiceController::class,'barcodeAddCart'])->name('barcodeAddCart');

Route::get('/new-invoice', [App\Http\Controllers\InvoiceController::class, 'index'])->name('newInvoice');

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
