@extends('layouts.app')

@section('content')


<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <div class="card">
    
        
            <div class="card-body">
            <h3 style="margin:10px">SEARCH RESULTS FOR <span class="text-info">{{request('search')}}....</span></h3>
                <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                        <tr>
                            <th>Invoice Number</th>
                            <th>Created at</th>
                            <th>Status</th>
                            <th>Outlet</th>
                            <th>Customer Contact</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach(json_decode($dispatchorders) as $order)
                        <tr>
                            <td>#{{$order->order_id}} <br>
                            Ordering Time: {{ \Carbon\Carbon::parse($order->created_at)->diffForHumans() }}
                            </td>
                            <td>{{$order->created_at}}</td>
                            <td>
                            {!! $order->dispatch_status == 0 ? '<span class="badge rounded-pill bg-danger">' . "Pending" . '</span>' : '<span class="badge rounded-pill bg-secondary">' . "Dispatching" . '</span>'!!}
                            </td>
                            <td>{{$order->branch}}</td>
                            <td><a href="tel:{{$order->customer_phone}}">{{$order->customer_phone}}</a></td>
                            <td>
                            <a href="https://pos.ceqalimited.com/print-lite-version/{{$order->order_id}}/{{$order->customer_id}}" class="btn btn-outline-primary rounded-pill mb-2">
                                <i class="icon-user1"></i>Preview Order
                            </a>
                             
                            </td>
                        </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
        </div>

    </div>
</div>
<!-- Row end -->


@endsection
